/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.hll;

import com.carrotsearch.junitbenchmarks.AbstractBenchmark;
import com.carrotsearch.junitbenchmarks.BenchmarkOptions;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.hll.VersionOneHyperLogLogCollector;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Ignore
public class HyperLogLogSerdeBenchmarkTest
extends AbstractBenchmark {
    private final HyperLogLogCollector collector;
    private final long NUM_HASHES;
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_128();
    volatile HashCode hashCode;

    public HyperLogLogSerdeBenchmarkTest(HyperLogLogCollector collector, Long num_hashes) {
        this.collector = collector;
        this.NUM_HASHES = num_hashes;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return ImmutableList.of((Object)Arrays.asList(new Comparable[]{new priorByteBufferSerializer(), new Long(1024L)}).toArray(), (Object)Arrays.asList(new Comparable[]{new newByteBufferSerializer(), new Long(1024L)}).toArray(), (Object)Arrays.asList(new Comparable[]{new newByteBufferSerializerWithPuts(), new Long(1024L)}).toArray(), (Object)Arrays.asList(new Comparable[]{new priorByteBufferSerializer(), new Long(256L)}).toArray(), (Object)Arrays.asList(new Comparable[]{new newByteBufferSerializer(), new Long(256L)}).toArray(), (Object)Arrays.asList(new Comparable[]{new newByteBufferSerializerWithPuts(), new Long(256L)}).toArray(), (Object)Arrays.asList(new Comparable[]{new priorByteBufferSerializer(), new Long(32L)}).toArray(), (Object)Arrays.asList(new Comparable[]{new newByteBufferSerializer(), new Long(32L)}).toArray(), (Object)Arrays.asList(new Comparable[]{new newByteBufferSerializerWithPuts(), new Long(32L)}).toArray(), (Object)Arrays.asList(new Comparable[]{new priorByteBufferSerializer(), new Long(4L)}).toArray(), (Object)Arrays.asList(new Comparable[]{new newByteBufferSerializer(), new Long(4L)}).toArray(), (Object)Arrays.asList(new Comparable[]{new newByteBufferSerializerWithPuts(), new Long(4L)}).toArray(), (Object[])new Object[0][]);
    }

    private void fillCollector(HyperLogLogCollector collector) {
        Random rand = new Random(758190L);
        for (long i = 0L; i < this.NUM_HASHES; ++i) {
            collector.add(HASH_FUNCTION.hashLong(rand.nextLong()).asBytes());
        }
    }

    private static HashCode getHash(ByteBuffer byteBuffer) {
        Hasher hasher = HASH_FUNCTION.newHasher();
        while (byteBuffer.position() < byteBuffer.limit()) {
            hasher.putByte(byteBuffer.get());
        }
        return hasher.hash();
    }

    @BeforeClass
    public static void setupHash() {
    }

    @Before
    public void setup() {
        this.fillCollector(this.collector);
    }

    @BenchmarkOptions(benchmarkRounds=100000, warmupRounds=100)
    @Test
    public void benchmarkToByteBuffer() {
        this.hashCode = HyperLogLogSerdeBenchmarkTest.getHash(this.collector.toByteBuffer());
    }

    private static final class priorByteBufferSerializer
    extends VersionOneHyperLogLogCollector {
        private priorByteBufferSerializer() {
        }

        public ByteBuffer toByteBuffer() {
            ByteBuffer myBuffer = this.getStorageBuffer();
            int initialPosition = this.getInitPosition();
            short numNonZeroRegisters = this.getNumNonZeroRegisters();
            if (myBuffer.remaining() == this.getNumBytesForDenseStorage() && numNonZeroRegisters < 128) {
                ByteBuffer retVal = ByteBuffer.wrap(new byte[numNonZeroRegisters * 3 + this.getNumHeaderBytes()]);
                this.setVersion(retVal);
                this.setRegisterOffset(retVal, this.getRegisterOffset());
                this.setNumNonZeroRegisters(retVal, numNonZeroRegisters);
                this.setMaxOverflowValue(retVal, this.getMaxOverflowValue());
                this.setMaxOverflowRegister(retVal, this.getMaxOverflowRegister());
                int startPosition = this.getPayloadBytePosition();
                retVal.position(this.getPayloadBytePosition(retVal));
                for (int i = startPosition; i < startPosition + 1024; ++i) {
                    if (myBuffer.get(i) == 0) continue;
                    retVal.putShort((short)(0xFFFF & i - initialPosition));
                    retVal.put(myBuffer.get(i));
                }
                retVal.rewind();
                return retVal.asReadOnlyBuffer();
            }
            return myBuffer.asReadOnlyBuffer();
        }
    }

    private static final class newByteBufferSerializer
    extends VersionOneHyperLogLogCollector {
        private newByteBufferSerializer() {
        }

        public ByteBuffer toByteBuffer() {
            ByteBuffer myBuffer = this.getStorageBuffer();
            int initialPosition = this.getInitPosition();
            short numNonZeroRegisters = this.getNumNonZeroRegisters();
            if (myBuffer.remaining() == this.getNumBytesForDenseStorage() && numNonZeroRegisters < 128) {
                ByteBuffer retVal = ByteBuffer.wrap(new byte[numNonZeroRegisters * 3 + this.getNumHeaderBytes()]);
                this.setVersion(retVal);
                this.setRegisterOffset(retVal, this.getRegisterOffset());
                this.setNumNonZeroRegisters(retVal, numNonZeroRegisters);
                this.setMaxOverflowValue(retVal, this.getMaxOverflowValue());
                this.setMaxOverflowRegister(retVal, this.getMaxOverflowRegister());
                int startPosition = this.getPayloadBytePosition();
                retVal.position(this.getPayloadBytePosition(retVal));
                byte[] zipperBuffer = new byte[1024];
                ByteBuffer roStorageBuffer = myBuffer.asReadOnlyBuffer();
                roStorageBuffer.position(startPosition);
                roStorageBuffer.get(zipperBuffer);
                ByteOrder byteOrder = retVal.order();
                byte[] tempBuffer = new byte[numNonZeroRegisters * 3];
                int outBufferPos = 0;
                for (int i = 0; i < 1024; ++i) {
                    if (zipperBuffer[i] == 0) continue;
                    short val = (short)(0xFFFF & i + startPosition - initialPosition);
                    if (byteOrder.equals(ByteOrder.LITTLE_ENDIAN)) {
                        tempBuffer[outBufferPos + 0] = (byte)(0xFF & val);
                        tempBuffer[outBufferPos + 1] = (byte)(0xFF & val >> 8);
                    } else {
                        tempBuffer[outBufferPos + 1] = (byte)(0xFF & val);
                        tempBuffer[outBufferPos + 0] = (byte)(0xFF & val >> 8);
                    }
                    tempBuffer[outBufferPos + 2] = zipperBuffer[i];
                    outBufferPos += 3;
                }
                retVal.put(tempBuffer);
                retVal.rewind();
                return retVal.asReadOnlyBuffer();
            }
            return myBuffer.asReadOnlyBuffer();
        }
    }

    private static final class newByteBufferSerializerWithPuts
    extends VersionOneHyperLogLogCollector {
        private newByteBufferSerializerWithPuts() {
        }

        public ByteBuffer toByteBuffer() {
            ByteBuffer myBuffer = this.getStorageBuffer();
            int initialPosition = this.getInitPosition();
            short numNonZeroRegisters = this.getNumNonZeroRegisters();
            if (myBuffer.remaining() == this.getNumBytesForDenseStorage() && numNonZeroRegisters < 128) {
                ByteBuffer retVal = ByteBuffer.wrap(new byte[numNonZeroRegisters * 3 + this.getNumHeaderBytes()]);
                this.setVersion(retVal);
                this.setRegisterOffset(retVal, this.getRegisterOffset());
                this.setNumNonZeroRegisters(retVal, numNonZeroRegisters);
                this.setMaxOverflowValue(retVal, this.getMaxOverflowValue());
                this.setMaxOverflowRegister(retVal, this.getMaxOverflowRegister());
                int startPosition = this.getPayloadBytePosition();
                retVal.position(this.getPayloadBytePosition(retVal));
                byte[] zipperBuffer = new byte[1024];
                ByteBuffer roStorageBuffer = myBuffer.asReadOnlyBuffer();
                roStorageBuffer.position(startPosition);
                roStorageBuffer.get(zipperBuffer);
                for (int i = 0; i < 1024; ++i) {
                    if (zipperBuffer[i] == 0) continue;
                    short val = (short)(0xFFFF & i + startPosition - initialPosition);
                    retVal.putShort(val);
                    retVal.put(zipperBuffer[i]);
                }
                retVal.rewind();
                return retVal.asReadOnlyBuffer();
            }
            return myBuffer.asReadOnlyBuffer();
        }
    }
}

