/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.report;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.druid.indexer.IngestionState;
import org.apache.druid.indexer.report.IngestionStatsAndErrors;
import org.apache.druid.indexer.report.IngestionStatsAndErrorsTaskReport;
import org.apache.druid.indexer.report.KillTaskReport;
import org.apache.druid.indexer.report.SingleFileTaskReportFileWriter;
import org.apache.druid.indexer.report.TaskContextReport;
import org.apache.druid.indexer.report.TaskReport;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.segment.incremental.ParseExceptionReport;
import org.apache.druid.segment.incremental.RowIngestionMetersTotals;
import org.apache.druid.segment.incremental.RowMeters;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TaskReportSerdeTest {
    private final ObjectMapper jsonMapper;
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    public TaskReportSerdeTest() {
        this.jsonMapper = new DefaultObjectMapper();
        this.jsonMapper.registerSubtypes(new Class[]{ExceptionalTaskReport.class});
    }

    @Test
    public void testSerdeOfIngestionReport() throws Exception {
        IngestionStatsAndErrorsTaskReport originalReport = this.buildTestIngestionReport();
        String reportJson = this.jsonMapper.writeValueAsString((Object)originalReport);
        TaskReport deserialized = (TaskReport)this.jsonMapper.readValue(reportJson, TaskReport.class);
        Assert.assertTrue((boolean)(deserialized instanceof IngestionStatsAndErrorsTaskReport));
        IngestionStatsAndErrorsTaskReport deserializedReport = (IngestionStatsAndErrorsTaskReport)deserialized;
        Assert.assertEquals((Object)originalReport, (Object)deserializedReport);
    }

    @Test
    public void testSerdeOfKillTaskReport() throws Exception {
        KillTaskReport originalReport = new KillTaskReport("taskId", new KillTaskReport.Stats(1, 2));
        String reportJson = this.jsonMapper.writeValueAsString((Object)originalReport);
        TaskReport deserialized = (TaskReport)this.jsonMapper.readValue(reportJson, TaskReport.class);
        Assert.assertTrue((boolean)(deserialized instanceof KillTaskReport));
        KillTaskReport deserializedReport = (KillTaskReport)deserialized;
        Assert.assertEquals((Object)originalReport, (Object)deserializedReport);
        Assert.assertEquals((long)originalReport.hashCode(), (long)deserializedReport.hashCode());
    }

    @Test
    public void testSerdeOfTaskContextReport() throws Exception {
        TaskContextReport originalReport = new TaskContextReport("taskId", (Map)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2"));
        String reportJson = this.jsonMapper.writeValueAsString((Object)originalReport);
        TaskReport deserialized = (TaskReport)this.jsonMapper.readValue(reportJson, TaskReport.class);
        Assert.assertTrue((boolean)(deserialized instanceof TaskContextReport));
        TaskContextReport deserializedReport = (TaskContextReport)deserialized;
        Assert.assertEquals((Object)originalReport, (Object)deserializedReport);
    }

    @Test
    public void testWriteReportMapToFileAndRead() throws Exception {
        IngestionStatsAndErrorsTaskReport report1 = this.buildTestIngestionReport();
        File reportFile = this.temporaryFolder.newFile();
        SingleFileTaskReportFileWriter writer = new SingleFileTaskReportFileWriter(reportFile);
        writer.setObjectMapper(this.jsonMapper);
        TaskReport.ReportMap reportMap1 = TaskReport.buildTaskReports((TaskReport[])new TaskReport[]{report1});
        writer.write("testID", reportMap1);
        TaskReport.ReportMap reportMap2 = (TaskReport.ReportMap)this.jsonMapper.readValue(reportFile, TaskReport.ReportMap.class);
        Assert.assertEquals((Object)reportMap1, (Object)reportMap2);
    }

    @Test
    public void testWriteReportMapToStringAndRead() throws Exception {
        IngestionStatsAndErrorsTaskReport ingestionReport = this.buildTestIngestionReport();
        TaskReport.ReportMap reportMap = TaskReport.buildTaskReports((TaskReport[])new TaskReport[]{ingestionReport});
        String json = this.jsonMapper.writeValueAsString((Object)reportMap);
        TaskReport.ReportMap deserializedReportMap = (TaskReport.ReportMap)this.jsonMapper.readValue(json, TaskReport.ReportMap.class);
        Assert.assertEquals((Object)reportMap, (Object)deserializedReportMap);
    }

    @Test
    public void testWritePlainMapAndReadAsReportMap() throws Exception {
        long now = System.currentTimeMillis();
        List<ParseExceptionReport> buildUnparseableEvents = Arrays.asList(new ParseExceptionReport("abc,def", "invalid timestamp", Arrays.asList("row: 1", "col: 1"), now), new ParseExceptionReport("xyz,pqr", "invalid timestamp", Arrays.asList("row: 1", "col: 1"), now));
        ImmutableMap unparseableEvents = ImmutableMap.of((Object)"determinePartitions", Collections.emptyList(), (Object)"buildSegments", buildUnparseableEvents);
        ImmutableMap emptyAverageMinuteMap = ImmutableMap.of((Object)"processed", (Object)0, (Object)"processedBytes", (Object)0, (Object)"unparseable", (Object)0, (Object)"thrownAway", (Object)0, (Object)"processedWithError", (Object)0);
        ImmutableMap emptyAverages = ImmutableMap.of((Object)"1m", (Object)emptyAverageMinuteMap, (Object)"5m", (Object)emptyAverageMinuteMap, (Object)"15m", (Object)emptyAverageMinuteMap);
        ImmutableMap expectedAverages = ImmutableMap.of((Object)"determinePartitions", (Object)emptyAverages, (Object)"buildSegments", (Object)emptyAverages);
        RowIngestionMetersTotals determinePartitionTotalStats = RowMeters.with().errors(10L).unparseable(1L).thrownAway(1L).bytes(2000L).totalProcessed(100L);
        RowIngestionMetersTotals buildSegmentTotalStats = RowMeters.with().errors(5L).unparseable(2L).thrownAway(1L).bytes(2500L).totalProcessed(150L);
        ImmutableMap expectedTotals = ImmutableMap.of((Object)"determinePartitions", (Object)determinePartitionTotalStats, (Object)"buildSegments", (Object)buildSegmentTotalStats);
        ImmutableMap expectedRowStats = ImmutableMap.of((Object)"movingAverages", (Object)expectedAverages, (Object)"totals", (Object)expectedTotals);
        HashMap<String, Object> expectedPayload = new HashMap<String, Object>();
        expectedPayload.put("ingestionState", IngestionState.COMPLETED);
        expectedPayload.put("unparseableEvents", unparseableEvents);
        expectedPayload.put("rowStats", expectedRowStats);
        HashMap<String, Object> ingestionStatsAndErrors = new HashMap<String, Object>();
        ingestionStatsAndErrors.put("taskId", "abc");
        ingestionStatsAndErrors.put("payload", expectedPayload);
        ingestionStatsAndErrors.put("type", "ingestionStatsAndErrors");
        HashMap<String, HashMap<String, Object>> expectedReportMap = new HashMap<String, HashMap<String, Object>>();
        expectedReportMap.put("ingestionStatsAndErrors", ingestionStatsAndErrors);
        String plainMapJson = this.jsonMapper.writeValueAsString(expectedReportMap);
        TaskReport.ReportMap deserializedReportMap = (TaskReport.ReportMap)this.jsonMapper.readValue(plainMapJson, TaskReport.ReportMap.class);
        Optional ingestStatsReport = deserializedReportMap.findReport("ingestionStatsAndErrors");
        Assert.assertTrue((boolean)ingestStatsReport.isPresent());
        Assert.assertEquals((Object)"ingestionStatsAndErrors", (Object)((IngestionStatsAndErrorsTaskReport)ingestStatsReport.get()).getReportKey());
        Assert.assertEquals((Object)"abc", (Object)((IngestionStatsAndErrorsTaskReport)ingestStatsReport.get()).getTaskId());
        IngestionStatsAndErrors observedPayload = ((IngestionStatsAndErrorsTaskReport)ingestStatsReport.get()).getPayload();
        Assert.assertEquals(expectedPayload.get("ingestionState"), (Object)observedPayload.getIngestionState());
        Assert.assertNull((Object)observedPayload.getSegmentsRead());
        Assert.assertNull((Object)observedPayload.getSegmentsPublished());
        Assert.assertNull((Object)observedPayload.getErrorMsg());
        Assert.assertNull((Object)observedPayload.getRecordsProcessed());
        Map observedRowStats = observedPayload.getRowStats();
        Assert.assertEquals((Object)expectedAverages, observedRowStats.get("movingAverages"));
        Map observedTotals = (Map)observedRowStats.get("totals");
        this.verifyTotalRowStats(observedTotals, determinePartitionTotalStats, buildSegmentTotalStats);
        this.verifyUnparseableEvents(observedPayload.getUnparseableEvents(), buildUnparseableEvents);
        String reportMapJson = this.jsonMapper.writeValueAsString((Object)deserializedReportMap);
        Map deserializedPlainMap = (Map)this.jsonMapper.readValue(reportMapJson, JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        Map ingestStatsReport2 = (Map)deserializedPlainMap.get("ingestionStatsAndErrors");
        Map observedPayload2 = (Map)ingestStatsReport2.get("payload");
        Assert.assertEquals((Object)expectedPayload.get("ingestionState").toString(), observedPayload2.get("ingestionState"));
        Assert.assertNull(observedPayload2.get("segmentsRead"));
        Assert.assertNull(observedPayload2.get("segmentsPublished"));
        Assert.assertNull(observedPayload2.get("errorMsg"));
        Assert.assertNull(observedPayload2.get("recordsProcessed"));
        Map observedRowStats2 = (Map)observedPayload2.get("rowStats");
        Assert.assertEquals((Object)expectedAverages, observedRowStats2.get("movingAverages"));
        Map observedTotals2 = (Map)observedRowStats2.get("totals");
        this.verifyTotalRowStats(observedTotals2, determinePartitionTotalStats, buildSegmentTotalStats);
        this.verifyUnparseableEvents((Map)observedPayload2.get("unparseableEvents"), buildUnparseableEvents);
    }

    @Test
    public void testSerializationOnMissingPartitionStats() throws Exception {
        String json = "{\n  \"type\": \"ingestionStatsAndErrors\",\n  \"taskId\": \"ingestionStatsAndErrors\",\n  \"payload\": {\n    \"ingestionState\": \"COMPLETED\",\n    \"unparseableEvents\": {\n      \"hello\": \"world\"\n    },\n    \"rowStats\": {\n      \"number\": 1234\n    },\n    \"errorMsg\": \"an error message\",\n    \"segmentAvailabilityConfirmed\": true,\n    \"segmentAvailabilityWaitTimeMs\": 1000\n  }\n}";
        IngestionStatsAndErrorsTaskReport expected = new IngestionStatsAndErrorsTaskReport("ingestionStatsAndErrors", new IngestionStatsAndErrors(IngestionState.COMPLETED, (Map)ImmutableMap.of((Object)"hello", (Object)"world"), (Map)ImmutableMap.of((Object)"number", (Object)1234), "an error message", true, 1000L, null, null, null));
        TaskReport deserialized = (TaskReport)this.jsonMapper.readValue(json, TaskReport.class);
        Assert.assertEquals((Object)expected.getTaskId(), (Object)deserialized.getTaskId());
        Assert.assertEquals((Object)expected, (Object)deserialized);
    }

    @Test
    public void testExceptionWhileWritingReport() throws Exception {
        File reportFile = this.temporaryFolder.newFile();
        SingleFileTaskReportFileWriter writer = new SingleFileTaskReportFileWriter(reportFile);
        writer.setObjectMapper(this.jsonMapper);
        writer.write("theTask", TaskReport.buildTaskReports((TaskReport[])new TaskReport[]{new ExceptionalTaskReport()}));
        Assert.assertEquals((Object)"{\"report\":{\"type\":\"exceptional\"", (Object)Files.asCharSource((File)reportFile, (Charset)StandardCharsets.UTF_8).read());
    }

    private IngestionStatsAndErrorsTaskReport buildTestIngestionReport() {
        return new IngestionStatsAndErrorsTaskReport("testID", new IngestionStatsAndErrors(IngestionState.BUILD_SEGMENTS, Collections.singletonMap("hello", "world"), Collections.singletonMap("number", 1234), "an error message", true, 1000L, Collections.singletonMap("PartitionA", 5000L), Long.valueOf(5L), Long.valueOf(10L)));
    }

    private void verifyUnparseableEvents(Map<String, Object> observed, List<ParseExceptionReport> buildSegmentUnparseableEvents) {
        Assert.assertEquals(Collections.emptyList(), (Object)observed.get("determinePartitions"));
        List observedBuildSegmentUnparseableEvents = (List)observed.get("buildSegments");
        Assert.assertEquals((long)2L, (long)observedBuildSegmentUnparseableEvents.size());
        for (int i = 0; i < buildSegmentUnparseableEvents.size(); ++i) {
            ParseExceptionReport expectedEvent = buildSegmentUnparseableEvents.get(i);
            Object observedEvent = observedBuildSegmentUnparseableEvents.get(i);
            Assert.assertEquals((Object)ImmutableMap.of((Object)"input", (Object)expectedEvent.getInput(), (Object)"errorType", (Object)expectedEvent.getErrorType(), (Object)"details", (Object)expectedEvent.getDetails(), (Object)"timeOfExceptionMillis", (Object)expectedEvent.getTimeOfExceptionMillis()), observedEvent);
        }
    }

    private void verifyTotalRowStats(Map<String, Object> observedTotals, RowIngestionMetersTotals determinePartitionTotalStats, RowIngestionMetersTotals buildSegmentTotalStats) {
        Assert.assertEquals((Object)ImmutableMap.of((Object)"processed", (Object)((int)determinePartitionTotalStats.getProcessed()), (Object)"processedBytes", (Object)((int)determinePartitionTotalStats.getProcessedBytes()), (Object)"processedWithError", (Object)((int)determinePartitionTotalStats.getProcessedWithError()), (Object)"thrownAway", (Object)((int)determinePartitionTotalStats.getThrownAway()), (Object)"unparseable", (Object)((int)determinePartitionTotalStats.getUnparseable())), (Object)observedTotals.get("determinePartitions"));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"processed", (Object)((int)buildSegmentTotalStats.getProcessed()), (Object)"processedBytes", (Object)((int)buildSegmentTotalStats.getProcessedBytes()), (Object)"processedWithError", (Object)((int)buildSegmentTotalStats.getProcessedWithError()), (Object)"thrownAway", (Object)((int)buildSegmentTotalStats.getThrownAway()), (Object)"unparseable", (Object)((int)buildSegmentTotalStats.getUnparseable())), (Object)observedTotals.get("buildSegments"));
    }

    @JsonTypeName(value="exceptional")
    private static class ExceptionalTaskReport
    implements TaskReport {
        private ExceptionalTaskReport() {
        }

        @JsonProperty
        public String getTaskId() {
            throw new UnsupportedOperationException("cannot serialize task ID");
        }

        public String getReportKey() {
            return "report";
        }

        @JsonProperty
        public Object getPayload() {
            throw new UnsupportedOperationException("cannot serialize payload");
        }
    }
}

