/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.guava;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.junit.Assert;
import org.junit.Test;

public class FunctionalIterableTest {
    @Test
    public void testTransform() {
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)FunctionalIterable.create(Arrays.asList("1", "2", "3")).transform((Function)new Function<String, Integer>(){

            public Integer apply(String input) {
                return Integer.parseInt(input);
            }
        })), Arrays.asList(1, 2, 3));
    }

    @Test
    public void testTransformCat() {
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)FunctionalIterable.create(Arrays.asList("1,2", "3,4", "5,6")).transformCat((Function)new Function<String, Iterable<String>>(){

            public Iterable<String> apply(String input) {
                return Splitter.on((String)",").split((CharSequence)input);
            }
        })), Arrays.asList("1", "2", "3", "4", "5", "6"));
    }

    @Test
    public void testKeep() {
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)FunctionalIterable.create(Arrays.asList("1", "2", "3")).keep((Function)new Function<String, Integer>(){

            public Integer apply(String input) {
                if ("2".equals(input)) {
                    return null;
                }
                return Integer.parseInt(input);
            }
        })), Arrays.asList(1, 3));
    }

    @Test
    public void testFilter() {
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)FunctionalIterable.create(Arrays.asList("1", "2", "3")).filter((Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !"2".equals(input);
            }
        })), Arrays.asList("1", "3"));
    }

    @Test
    public void testDrop() {
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)FunctionalIterable.create(Arrays.asList("1", "2", "3")).drop(2)), Collections.singletonList("3"));
    }
}

