/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.parsers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.parsers.JSONPathFieldSpec;
import org.apache.druid.java.util.common.parsers.JSONPathFieldType;
import org.apache.druid.java.util.common.parsers.JSONPathParser;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JSONPathParserTest {
    private static final String JSON = "{\"one\": \"foo\", \"two\" : [\"bar\", \"baz\"], \"three\" : \"qux\", \"four\" : null}";
    private static final String NUMBERS_JSON = "{\"five\" : 5.0, \"six\" : 6, \"many\" : 1234567878900, \"toomany\" : 1234567890000000000000}";
    private static final String WHACKY_CHARACTER_JSON = "{\"one\": \"foo\\uD900\"}";
    private static final String NESTED_JSON = "{\"simpleVal\":\"text\", \"ignore_me\":[1, {\"x\":2}], \"blah\":[4,5,6], \"newmet\":5, \"foo\":{\"bar1\":\"aaa\", \"bar2\":\"bbb\"}, \"baz\":[1,2,3], \"timestamp\":\"2999\", \"foo.bar1\":\"Hello world!\", \"testListConvert\":[1234567890000000000000, \"foo\\uD900\"], \"testListConvert2\":[1234567890000000000000, \"foo\\uD900\", [1234567890000000000000]], \"testMapConvert\":{\"big\": 1234567890000000000000, \"big2\":{\"big2\":1234567890000000000000}}, \"testEmptyList\": [], \"hey\":[{\"barx\":\"asdf\"}], \"met\":{\"a\":[7,8,9]}}";
    private static final String NOT_JSON = "***@#%R#*(TG@(*H(#@(#@((H#(@TH@(#TH(@SDHGKJDSKJFBSBJK";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testSimple() {
        ArrayList fields = new ArrayList();
        JSONPathParser jsonParser = new JSONPathParser(new JSONPathSpec(Boolean.valueOf(true), fields), null, false);
        Map jsonMap = jsonParser.parseToMap(JSON);
        Assert.assertEquals((String)"jsonMap", (Object)ImmutableMap.of((Object)"one", (Object)"foo", (Object)"two", (Object)ImmutableList.of((Object)"bar", (Object)"baz"), (Object)"three", (Object)"qux"), (Object)jsonMap);
    }

    @Test
    public void testWithNumbers() {
        ArrayList fields = new ArrayList();
        JSONPathParser jsonParser = new JSONPathParser(new JSONPathSpec(Boolean.valueOf(true), fields), null, false);
        Map jsonMap = jsonParser.parseToMap(NUMBERS_JSON);
        Assert.assertEquals((String)"jsonMap", (Object)ImmutableMap.of((Object)"five", (Object)5.0, (Object)"six", (Object)6L, (Object)"many", (Object)1234567878900L, (Object)"toomany", (Object)1.23456789E21), (Object)jsonMap);
    }

    @Test
    public void testWithWhackyCharacters() {
        ArrayList fields = new ArrayList();
        JSONPathParser jsonParser = new JSONPathParser(new JSONPathSpec(Boolean.valueOf(true), fields), null, false);
        Map jsonMap = jsonParser.parseToMap(WHACKY_CHARACTER_JSON);
        Assert.assertEquals((String)"jsonMap", (Object)ImmutableMap.of((Object)"one", (Object)"foo?"), (Object)jsonMap);
    }

    @Test
    public void testNestingWithFieldDiscovery() {
        ArrayList<JSONPathFieldSpec> fields = new ArrayList<JSONPathFieldSpec>();
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.ROOT, "baz", "baz"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.PATH, "nested-foo.bar1", "$.foo.bar1"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.PATH, "nested-foo.bar2", "$.foo.bar2"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.PATH, "heybarx0", "$.hey[0].barx"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.PATH, "met-array", "$.met.a"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.ROOT, "testListConvert2", "testListConvert2"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.ROOT, "testMapConvert", "testMapConvert"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.ROOT, "INVALID_ROOT", "INVALID_ROOT_EXPR"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.PATH, "INVALID_PATH", "INVALID_PATH_EXPR"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq-nested-foo.bar1", ".foo.bar1"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq-nested-foo.bar2", ".foo.bar2"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq-heybarx0", ".hey[0].barx"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq-met-array", ".met.a"));
        JSONPathParser jsonParser = new JSONPathParser(new JSONPathSpec(Boolean.valueOf(true), fields), null, false);
        Map jsonMap = jsonParser.parseToMap(NESTED_JSON);
        Assert.assertEquals((Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), jsonMap.get("baz"));
        Assert.assertEquals((Object)ImmutableList.of((Object)4L, (Object)5L, (Object)6L), jsonMap.get("blah"));
        Assert.assertEquals((Object)"text", jsonMap.get("simpleVal"));
        Assert.assertEquals((Object)5L, jsonMap.get("newmet"));
        Assert.assertEquals((Object)"2999", jsonMap.get("timestamp"));
        Assert.assertEquals((Object)"Hello world!", jsonMap.get("foo.bar1"));
        List testListConvert = (List)jsonMap.get("testListConvert");
        Assert.assertEquals((Object)1.23456789E21, testListConvert.get(0));
        Assert.assertEquals((Object)"foo?", testListConvert.get(1));
        List testListConvert2 = (List)jsonMap.get("testListConvert2");
        Assert.assertEquals((Object)1.23456789E21, testListConvert2.get(0));
        Assert.assertEquals((Object)"foo?", testListConvert2.get(1));
        Assert.assertEquals((Object)1.23456789E21, ((List)testListConvert2.get(2)).get(0));
        Map testMapConvert = (Map)jsonMap.get("testMapConvert");
        Assert.assertEquals((Object)1.23456789E21, testMapConvert.get("big"));
        Assert.assertEquals((Object)1.23456789E21, ((Map)testMapConvert.get("big2")).get("big2"));
        Assert.assertEquals((Object)ImmutableList.of(), jsonMap.get("testEmptyList"));
        Assert.assertEquals((Object)"aaa", jsonMap.get("nested-foo.bar1"));
        Assert.assertEquals((Object)"bbb", jsonMap.get("nested-foo.bar2"));
        Assert.assertEquals((Object)"asdf", jsonMap.get("heybarx0"));
        Assert.assertEquals((Object)ImmutableList.of((Object)7L, (Object)8L, (Object)9L), jsonMap.get("met-array"));
        Assert.assertEquals((Object)"aaa", jsonMap.get("jq-nested-foo.bar1"));
        Assert.assertEquals((Object)"bbb", jsonMap.get("jq-nested-foo.bar2"));
        Assert.assertEquals((Object)"asdf", jsonMap.get("jq-heybarx0"));
        Assert.assertEquals((Object)ImmutableList.of((Object)7L, (Object)8L, (Object)9L), jsonMap.get("jq-met-array"));
        Assert.assertFalse((boolean)jsonMap.containsKey("hey"));
        Assert.assertFalse((boolean)jsonMap.containsKey("met"));
        Assert.assertFalse((boolean)jsonMap.containsKey("ignore_me"));
        Assert.assertFalse((boolean)jsonMap.containsKey("foo"));
        Assert.assertNull(jsonMap.get("INVALID_ROOT"));
        Assert.assertNull(jsonMap.get("INVALID_PATH"));
    }

    @Test
    public void testNestingNoDiscovery() {
        ArrayList<JSONPathFieldSpec> fields = new ArrayList<JSONPathFieldSpec>();
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.ROOT, "simpleVal", "simpleVal"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.ROOT, "timestamp", "timestamp"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.PATH, "nested-foo.bar2", "$.foo.bar2"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.PATH, "heybarx0", "$.hey[0].barx"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.PATH, "met-array", "$.met.a"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq-nested-foo.bar2", ".foo.bar2"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq-heybarx0", ".hey[0].barx"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq-met-array", ".met.a"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree-simpleVal", null, Collections.singletonList("simpleVal")));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree-timestamp", null, Collections.singletonList("timestamp")));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree-nested-foo.bar2", null, Arrays.asList("foo", "bar2")));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree-met-array", null, Arrays.asList("met", "a")));
        JSONPathParser jsonParser = new JSONPathParser(new JSONPathSpec(Boolean.valueOf(false), fields), null, false);
        Map jsonMap = jsonParser.parseToMap(NESTED_JSON);
        Assert.assertEquals((Object)"text", jsonMap.get("simpleVal"));
        Assert.assertEquals((Object)"2999", jsonMap.get("timestamp"));
        Assert.assertEquals((Object)"text", jsonMap.get("tree-simpleVal"));
        Assert.assertEquals((Object)"2999", jsonMap.get("tree-timestamp"));
        Assert.assertEquals((Object)"bbb", jsonMap.get("nested-foo.bar2"));
        Assert.assertEquals((Object)"asdf", jsonMap.get("heybarx0"));
        Assert.assertEquals((Object)ImmutableList.of((Object)7L, (Object)8L, (Object)9L), jsonMap.get("met-array"));
        Assert.assertEquals((Object)"bbb", jsonMap.get("jq-nested-foo.bar2"));
        Assert.assertEquals((Object)"asdf", jsonMap.get("jq-heybarx0"));
        Assert.assertEquals((Object)ImmutableList.of((Object)7L, (Object)8L, (Object)9L), jsonMap.get("jq-met-array"));
        Assert.assertEquals((Object)ImmutableList.of((Object)7L, (Object)8L, (Object)9L), jsonMap.get("tree-met-array"));
        Assert.assertEquals((Object)"bbb", jsonMap.get("tree-nested-foo.bar2"));
        Assert.assertFalse((boolean)jsonMap.containsKey("newmet"));
        Assert.assertFalse((boolean)jsonMap.containsKey("foo.bar1"));
        Assert.assertFalse((boolean)jsonMap.containsKey("baz"));
        Assert.assertFalse((boolean)jsonMap.containsKey("blah"));
        Assert.assertFalse((boolean)jsonMap.containsKey("nested-foo.bar1"));
        Assert.assertFalse((boolean)jsonMap.containsKey("hey"));
        Assert.assertFalse((boolean)jsonMap.containsKey("met"));
        Assert.assertFalse((boolean)jsonMap.containsKey("ignore_me"));
        Assert.assertFalse((boolean)jsonMap.containsKey("foo"));
    }

    @Test
    public void testRejectDuplicates() {
        ArrayList<JSONPathFieldSpec> fields = new ArrayList<JSONPathFieldSpec>();
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.PATH, "met-array", "$.met.a"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.PATH, "met-array", "$.met.a"));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Cannot have duplicate field definition: met-array");
        JSONPathParser jsonParser = new JSONPathParser(new JSONPathSpec(Boolean.valueOf(false), fields), null, false);
        jsonParser.parseToMap(NESTED_JSON);
    }

    @Test
    public void testRejectDuplicates2() {
        ArrayList<JSONPathFieldSpec> fields = new ArrayList<JSONPathFieldSpec>();
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.PATH, "met-array", "$.met.a"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.JQ, "met-array", ".met.a"));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Cannot have duplicate field definition: met-array");
        JSONPathParser jsonParser = new JSONPathParser(new JSONPathSpec(Boolean.valueOf(false), fields), null, false);
        jsonParser.parseToMap(NESTED_JSON);
    }

    @Test
    public void testParseFail() {
        ArrayList fields = new ArrayList();
        this.thrown.expect(ParseException.class);
        this.thrown.expectMessage("Unable to parse row [***@#%R#*(TG@(*H(#@(#@((H#(@TH@(#TH(@SDHGKJDSKJFBSBJK]");
        JSONPathParser jsonParser = new JSONPathParser(new JSONPathSpec(Boolean.valueOf(true), fields), null, false);
        jsonParser.parseToMap(NOT_JSON);
    }

    @Test
    public void testJSONPathFunctions() {
        List<JSONPathFieldSpec> fields = Arrays.asList(new JSONPathFieldSpec(JSONPathFieldType.PATH, "met-array-length", "$.met.a.length()"), new JSONPathFieldSpec(JSONPathFieldType.PATH, "met-array-min", "$.met.a.min()"), new JSONPathFieldSpec(JSONPathFieldType.PATH, "met-array-max", "$.met.a.max()"), new JSONPathFieldSpec(JSONPathFieldType.PATH, "met-array-avg", "$.met.a.avg()"), new JSONPathFieldSpec(JSONPathFieldType.PATH, "met-array-sum", "$.met.a.sum()"), new JSONPathFieldSpec(JSONPathFieldType.PATH, "met-array-stddev", "$.met.a.stddev()"), new JSONPathFieldSpec(JSONPathFieldType.PATH, "met-array-append", "$.met.a.append(10)"), new JSONPathFieldSpec(JSONPathFieldType.PATH, "concat", "$.concat($.foo.bar1, $.foo.bar2)"));
        JSONPathParser jsonParser = new JSONPathParser(new JSONPathSpec(Boolean.valueOf(true), fields), null, false);
        Map jsonMap = jsonParser.parseToMap(NESTED_JSON);
        Assert.assertEquals((Object)3, jsonMap.get("met-array-length"));
        Assert.assertEquals((Object)7.0, jsonMap.get("met-array-min"));
        Assert.assertEquals((Object)9.0, jsonMap.get("met-array-max"));
        Assert.assertEquals((Object)8.0, jsonMap.get("met-array-avg"));
        Assert.assertEquals((Object)24.0, jsonMap.get("met-array-sum"));
        Assert.assertEquals((double)0.8165, (double)((Double)jsonMap.get("met-array-stddev")), (double)1.0E-5);
        Assert.assertEquals((Object)ImmutableList.of((Object)7L, (Object)8L, (Object)9L, (Object)10L), jsonMap.get("met-array-append"));
        Assert.assertEquals((Object)"aaabbb", jsonMap.get("concat"));
    }
}

