/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.http.client;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.HttpClientConfig;
import org.apache.druid.java.util.http.client.HttpClientInit;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHandler;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.timeout.ReadTimeoutException;
import org.joda.time.Duration;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JankyServersTest {
    static ExecutorService exec;
    static ServerSocket silentServerSocket;
    static ServerSocket echoServerSocket;
    static ServerSocket closingServerSocket;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @BeforeClass
    public static void setUp() throws Exception {
        exec = Executors.newCachedThreadPool();
        silentServerSocket = new ServerSocket(0);
        echoServerSocket = new ServerSocket(0);
        closingServerSocket = new ServerSocket(0);
        exec.submit(new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Socket clientSocket = silentServerSocket.accept();
                        try {
                            InputStream in = clientSocket.getInputStream();
                            try {
                                while (in.read() != -1) {
                                }
                            }
                            finally {
                                if (in == null) continue;
                                in.close();
                            }
                        }
                        finally {
                            if (clientSocket == null) continue;
                            clientSocket.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        });
        exec.submit(new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Socket clientSocket = closingServerSocket.accept();
                        try {
                            InputStream in = clientSocket.getInputStream();
                            try {
                                in.read();
                                clientSocket.close();
                            }
                            finally {
                                if (in == null) continue;
                                in.close();
                            }
                        }
                        finally {
                            if (clientSocket == null) continue;
                            clientSocket.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        });
        exec.submit(new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Socket clientSocket = echoServerSocket.accept();
                        try {
                            OutputStream out = clientSocket.getOutputStream();
                            try {
                                InputStream in = clientSocket.getInputStream();
                                try {
                                    int b;
                                    while ((b = in.read()) != -1) {
                                        out.write(b);
                                    }
                                }
                                finally {
                                    if (in == null) continue;
                                    in.close();
                                }
                            }
                            finally {
                                if (out == null) continue;
                                out.close();
                            }
                        }
                        finally {
                            if (clientSocket == null) continue;
                            clientSocket.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @AfterClass
    public static void tearDown() throws Exception {
        exec.shutdownNow();
        silentServerSocket.close();
        echoServerSocket.close();
        closingServerSocket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpSilentServerWithGlobalTimeout() throws Throwable {
        Lifecycle lifecycle = new Lifecycle();
        try {
            HttpClientConfig config = HttpClientConfig.builder().withReadTimeout(new Duration(100L)).build();
            HttpClient client = HttpClientInit.createClient((HttpClientConfig)config, (Lifecycle)lifecycle);
            ListenableFuture future = client.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"http://localhost:%d/", (Object[])new Object[]{silentServerSocket.getLocalPort()}))), (HttpResponseHandler)StatusResponseHandler.getInstance());
            Throwable e = null;
            try {
                future.get();
            }
            catch (ExecutionException e1) {
                e = e1.getCause();
            }
            Assert.assertTrue((String)"ReadTimeoutException thrown by 'get'", (boolean)(e instanceof ReadTimeoutException));
        }
        finally {
            lifecycle.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpSilentServerWithRequestTimeout() throws Throwable {
        Lifecycle lifecycle = new Lifecycle();
        try {
            HttpClientConfig config = HttpClientConfig.builder().withReadTimeout(new Duration(31536000L)).build();
            HttpClient client = HttpClientInit.createClient((HttpClientConfig)config, (Lifecycle)lifecycle);
            ListenableFuture future = client.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"http://localhost:%d/", (Object[])new Object[]{silentServerSocket.getLocalPort()}))), (HttpResponseHandler)StatusResponseHandler.getInstance(), new Duration(100L));
            Throwable e = null;
            try {
                future.get();
            }
            catch (ExecutionException e1) {
                e = e1.getCause();
            }
            Assert.assertTrue((String)"ReadTimeoutException thrown by 'get'", (boolean)(e instanceof ReadTimeoutException));
        }
        finally {
            lifecycle.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpsSilentServer() throws Throwable {
        Lifecycle lifecycle = new Lifecycle();
        try {
            HttpClientConfig config = HttpClientConfig.builder().withSslContext(SSLContext.getDefault()).withSslHandshakeTimeout(new Duration(100L)).build();
            HttpClient client = HttpClientInit.createClient((HttpClientConfig)config, (Lifecycle)lifecycle);
            ListenableFuture response = client.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"https://localhost:%d/", (Object[])new Object[]{silentServerSocket.getLocalPort()}))), (HttpResponseHandler)StatusResponseHandler.getInstance());
            Throwable e = null;
            try {
                response.get();
            }
            catch (ExecutionException e1) {
                e = e1.getCause();
            }
            Assert.assertTrue((String)"ChannelException thrown by 'get'", (boolean)(e instanceof ChannelException));
        }
        finally {
            lifecycle.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpConnectionClosingServer() throws Throwable {
        Lifecycle lifecycle = new Lifecycle();
        try {
            HttpClientConfig config = HttpClientConfig.builder().build();
            HttpClient client = HttpClientInit.createClient((HttpClientConfig)config, (Lifecycle)lifecycle);
            ListenableFuture response = client.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"http://localhost:%d/", (Object[])new Object[]{closingServerSocket.getLocalPort()}))), (HttpResponseHandler)StatusResponseHandler.getInstance());
            Throwable e = null;
            try {
                response.get();
            }
            catch (ExecutionException e1) {
                e = e1.getCause();
                e1.printStackTrace();
            }
            Assert.assertTrue((String)"ChannelException thrown by 'get'", (boolean)this.isChannelClosedException(e));
        }
        finally {
            lifecycle.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpsConnectionClosingServer() throws Throwable {
        Lifecycle lifecycle = new Lifecycle();
        try {
            HttpClientConfig config = HttpClientConfig.builder().withSslContext(SSLContext.getDefault()).build();
            HttpClient client = HttpClientInit.createClient((HttpClientConfig)config, (Lifecycle)lifecycle);
            ListenableFuture response = client.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"https://localhost:%d/", (Object[])new Object[]{closingServerSocket.getLocalPort()}))), (HttpResponseHandler)StatusResponseHandler.getInstance());
            Throwable e = null;
            try {
                response.get();
            }
            catch (ExecutionException e1) {
                e = e1.getCause();
                e1.printStackTrace();
            }
            Assert.assertTrue((String)"ChannelException thrown by 'get'", (boolean)this.isChannelClosedException(e));
        }
        finally {
            lifecycle.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpConnectionRefused() throws Throwable {
        Lifecycle lifecycle = new Lifecycle();
        try {
            HttpClientConfig config = HttpClientConfig.builder().withSslContext(SSLContext.getDefault()).build();
            HttpClient client = HttpClientInit.createClient((HttpClientConfig)config, (Lifecycle)lifecycle);
            ServerSocket sock = new ServerSocket(0);
            int port = sock.getLocalPort();
            sock.close();
            ListenableFuture response = client.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"http://localhost:%d/", (Object[])new Object[]{port}))), (HttpResponseHandler)StatusResponseHandler.getInstance());
            Throwable e = null;
            try {
                response.get();
            }
            catch (ExecutionException e1) {
                e = e1.getCause();
                e1.printStackTrace();
            }
            Assert.assertTrue((String)"ChannelException thrown by 'get'", (boolean)this.isChannelClosedException(e));
        }
        finally {
            lifecycle.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpsConnectionRefused() throws Throwable {
        Lifecycle lifecycle = new Lifecycle();
        try {
            HttpClientConfig config = HttpClientConfig.builder().withSslContext(SSLContext.getDefault()).build();
            HttpClient client = HttpClientInit.createClient((HttpClientConfig)config, (Lifecycle)lifecycle);
            ServerSocket sock = new ServerSocket(0);
            int port = sock.getLocalPort();
            sock.close();
            ListenableFuture response = client.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"https://localhost:%d/", (Object[])new Object[]{port}))), (HttpResponseHandler)StatusResponseHandler.getInstance());
            Throwable e = null;
            try {
                response.get();
            }
            catch (ExecutionException e1) {
                e = e1.getCause();
                e1.printStackTrace();
            }
            Assert.assertTrue((String)"ChannelException thrown by 'get'", (boolean)this.isChannelClosedException(e));
        }
        finally {
            lifecycle.stop();
        }
    }

    public boolean isChannelClosedException(Throwable e) {
        return e instanceof ChannelException || e instanceof SocketException && e.getMessage().contains("Connection reset") || e instanceof IOException && e.getMessage().contains("Connection reset by peer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpEchoServer() throws Throwable {
        Lifecycle lifecycle = new Lifecycle();
        try {
            HttpClientConfig config = HttpClientConfig.builder().build();
            HttpClient client = HttpClientInit.createClient((HttpClientConfig)config, (Lifecycle)lifecycle);
            ListenableFuture response = client.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"http://localhost:%d/", (Object[])new Object[]{echoServerSocket.getLocalPort()}))), (HttpResponseHandler)StatusResponseHandler.getInstance());
            this.expectedException.expect(ExecutionException.class);
            this.expectedException.expectMessage("java.lang.IllegalArgumentException: invalid version format: GET");
            response.get();
        }
        finally {
            lifecycle.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpsEchoServer() throws Throwable {
        Lifecycle lifecycle = new Lifecycle();
        try {
            HttpClientConfig config = HttpClientConfig.builder().withSslContext(SSLContext.getDefault()).build();
            HttpClient client = HttpClientInit.createClient((HttpClientConfig)config, (Lifecycle)lifecycle);
            ListenableFuture response = client.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"https://localhost:%d/", (Object[])new Object[]{echoServerSocket.getLocalPort()}))), (HttpResponseHandler)StatusResponseHandler.getInstance());
            this.expectedException.expect(ExecutionException.class);
            this.expectedException.expectMessage("org.jboss.netty.channel.ChannelException: Faulty channel in resource pool");
            response.get();
        }
        finally {
            lifecycle.stop();
        }
    }
}

