/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.http.client.response;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.http.client.response.ClientResponse;
import org.apache.druid.java.util.http.client.response.InputStreamFullResponseHandler;
import org.apache.druid.java.util.http.client.response.InputStreamFullResponseHolder;
import org.jboss.netty.buffer.BigEndianHeapChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.junit.Assert;
import org.junit.Test;

public class InputStreamFullResponseHandlerTest {
    @Test
    public void testSimple() throws Exception {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setChunked(false);
        response.setContent((ChannelBuffer)new BigEndianHeapChannelBuffer("abcd".getBytes(StringUtils.UTF8_STRING)));
        InputStreamFullResponseHandler responseHandler = new InputStreamFullResponseHandler();
        ClientResponse clientResp = responseHandler.handleResponse((HttpResponse)response, null);
        DefaultHttpChunk chunk = new DefaultHttpChunk((ChannelBuffer)new BigEndianHeapChannelBuffer("efg".getBytes(StringUtils.UTF8_STRING)));
        clientResp = responseHandler.handleChunk(clientResp, (HttpChunk)chunk, 0L);
        clientResp = responseHandler.done(clientResp);
        Assert.assertTrue((boolean)clientResp.isFinished());
        Assert.assertEquals((Object)"abcdefg", (Object)IOUtils.toString((InputStream)((InputStreamFullResponseHolder)clientResp.getObj()).getContent(), (Charset)StandardCharsets.UTF_8));
    }

    @Test
    public void testException() throws Exception {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setChunked(false);
        response.setContent((ChannelBuffer)new BigEndianHeapChannelBuffer("abcd".getBytes(StringUtils.UTF8_STRING)));
        InputStreamFullResponseHandler responseHandler = new InputStreamFullResponseHandler();
        ClientResponse clientResp = responseHandler.handleResponse((HttpResponse)response, null);
        RuntimeException ex = new RuntimeException("dummy!");
        responseHandler.exceptionCaught(clientResp, (Throwable)ex);
        Assert.assertTrue((boolean)clientResp.isFinished());
    }
}

