/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.http.client.response;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.http.client.response.ClientResponse;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.InputStreamFullResponseHandler;
import org.apache.druid.java.util.http.client.response.InputStreamFullResponseHolder;
import org.apache.druid.java.util.http.client.response.ObjectOrErrorResponseHandler;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.jboss.netty.buffer.BigEndianHeapChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.junit.Assert;
import org.junit.Test;

public class ObjectOrErrorResponseHandlerTest {
    @Test
    public void testOk() throws Exception {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setChunked(false);
        response.setContent((ChannelBuffer)new BigEndianHeapChannelBuffer("abcd".getBytes(StringUtils.UTF8_STRING)));
        ObjectOrErrorResponseHandler responseHandler = new ObjectOrErrorResponseHandler((HttpResponseHandler)new InputStreamFullResponseHandler());
        ClientResponse clientResp = responseHandler.handleResponse((HttpResponse)response, null);
        DefaultHttpChunk chunk = new DefaultHttpChunk((ChannelBuffer)new BigEndianHeapChannelBuffer("efg".getBytes(StringUtils.UTF8_STRING)));
        clientResp = responseHandler.handleChunk(clientResp, (HttpChunk)chunk, 0L);
        clientResp = responseHandler.done(clientResp);
        Assert.assertTrue((boolean)clientResp.isFinished());
        Assert.assertEquals((Object)"abcdefg", (Object)IOUtils.toString((InputStream)((InputStreamFullResponseHolder)((Either)clientResp.getObj()).valueOrThrow()).getContent(), (Charset)StandardCharsets.UTF_8));
    }

    @Test
    public void testExceptionAfterOk() throws Exception {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setChunked(false);
        response.setContent((ChannelBuffer)new BigEndianHeapChannelBuffer("abcd".getBytes(StringUtils.UTF8_STRING)));
        ObjectOrErrorResponseHandler responseHandler = new ObjectOrErrorResponseHandler((HttpResponseHandler)new InputStreamFullResponseHandler());
        ClientResponse clientResp = responseHandler.handleResponse((HttpResponse)response, null);
        RuntimeException ex = new RuntimeException("dummy!");
        responseHandler.exceptionCaught(clientResp, (Throwable)ex);
        Assert.assertTrue((boolean)clientResp.isFinished());
        Assert.assertTrue((boolean)((Either)clientResp.getObj()).isValue());
        InputStream responseStream = ((InputStreamFullResponseHolder)((Either)clientResp.getObj()).valueOrThrow()).getContent();
        IOException e = (IOException)Assert.assertThrows(IOException.class, () -> IOUtils.toString((InputStream)responseStream, (Charset)StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"java.lang.RuntimeException: dummy!", (Object)e.getMessage());
    }

    @Test
    public void testServerError() throws Exception {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        response.setChunked(false);
        response.setContent((ChannelBuffer)new BigEndianHeapChannelBuffer("abcd".getBytes(StringUtils.UTF8_STRING)));
        ObjectOrErrorResponseHandler responseHandler = new ObjectOrErrorResponseHandler((HttpResponseHandler)new InputStreamFullResponseHandler());
        ClientResponse clientResp = responseHandler.handleResponse((HttpResponse)response, null);
        DefaultHttpChunk chunk = new DefaultHttpChunk((ChannelBuffer)new BigEndianHeapChannelBuffer("efg".getBytes(StringUtils.UTF8_STRING)));
        clientResp = responseHandler.handleChunk(clientResp, (HttpChunk)chunk, 0L);
        clientResp = responseHandler.done(clientResp);
        Assert.assertTrue((boolean)clientResp.isFinished());
        Assert.assertTrue((boolean)((Either)clientResp.getObj()).isError());
        Assert.assertEquals((long)HttpResponseStatus.INTERNAL_SERVER_ERROR.getCode(), (long)((StringFullResponseHolder)((Either)clientResp.getObj()).error()).getResponse().getStatus().getCode());
        Assert.assertEquals((Object)"abcdefg", (Object)((StringFullResponseHolder)((Either)clientResp.getObj()).error()).getContent());
    }
}

