/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.collect.ImmutableMap;
import org.apache.druid.java.util.emitter.core.ConcurrentTimeCounter;
import org.apache.druid.java.util.emitter.core.HttpPostEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.HttpPostEmitterMonitor;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class HttpPostEmitterMonitorTest {
    private HttpPostEmitter mockHttpPostEmitter;
    private HttpPostEmitterMonitor monitor;

    @BeforeEach
    public void setUp() {
        this.mockHttpPostEmitter = (HttpPostEmitter)Mockito.mock(HttpPostEmitter.class);
        this.monitor = new HttpPostEmitterMonitor("testFeed", this.mockHttpPostEmitter, ImmutableMap.of((Object)"dimensionKey", (Object)"dimensionValue"));
    }

    @Test
    public void testDoMonitor() {
        Mockito.when((Object)this.mockHttpPostEmitter.getTotalEmittedEvents()).thenReturn((Object)100L);
        Mockito.when((Object)this.mockHttpPostEmitter.getTotalDroppedBuffers()).thenReturn((Object)10);
        Mockito.when((Object)this.mockHttpPostEmitter.getTotalAllocatedBuffers()).thenReturn((Object)20);
        Mockito.when((Object)this.mockHttpPostEmitter.getTotalFailedBuffers()).thenReturn((Object)5);
        Mockito.when((Object)this.mockHttpPostEmitter.getEventsToEmit()).thenReturn((Object)200L);
        Mockito.when((Object)this.mockHttpPostEmitter.getLargeEventsToEmit()).thenReturn((Object)75L);
        Mockito.when((Object)this.mockHttpPostEmitter.getBuffersToEmit()).thenReturn((Object)30);
        Mockito.when((Object)this.mockHttpPostEmitter.getBuffersToReuse()).thenReturn((Object)15);
        Mockito.when((Object)this.mockHttpPostEmitter.getBatchFillingTimeCounter()).thenReturn((Object)((ConcurrentTimeCounter)Mockito.mock(ConcurrentTimeCounter.class)));
        Mockito.when((Object)this.mockHttpPostEmitter.getSuccessfulSendingTimeCounter()).thenReturn((Object)((ConcurrentTimeCounter)Mockito.mock(ConcurrentTimeCounter.class)));
        Mockito.when((Object)this.mockHttpPostEmitter.getFailedSendingTimeCounter()).thenReturn((Object)((ConcurrentTimeCounter)Mockito.mock(ConcurrentTimeCounter.class)));
        StubServiceEmitter stubServiceEmitter = new StubServiceEmitter("service", "host");
        Assertions.assertTrue((boolean)this.monitor.doMonitor((ServiceEmitter)stubServiceEmitter));
        stubServiceEmitter.verifyValue("emitter/successfulSending/maxTimeMs", 0);
        stubServiceEmitter.verifyValue("emitter/events/emitted/delta", 100L);
        stubServiceEmitter.verifyValue("emitter/successfulSending/minTimeMs", 0);
        stubServiceEmitter.verifyValue("emitter/buffers/emitQueue", 30);
        stubServiceEmitter.verifyValue("emitter/failedSending/minTimeMs", 0);
        stubServiceEmitter.verifyValue("emitter/buffers/allocated/delta", 20);
        stubServiceEmitter.verifyValue("emitter/batchFilling/maxTimeMs", 0);
        stubServiceEmitter.verifyValue("emitter/buffers/dropped/delta", 10);
        stubServiceEmitter.verifyValue("emitter/batchFilling/minTimeMs", 0);
        stubServiceEmitter.verifyValue("emitter/events/emitQueue", 200L);
        stubServiceEmitter.verifyValue("emitter/events/large/emitQueue", 75L);
        stubServiceEmitter.verifyValue("emitter/buffers/reuseQueue", 15);
        stubServiceEmitter.verifyValue("emitter/buffers/failed/delta", 5);
        stubServiceEmitter.verifyValue("emitter/failedSending/maxTimeMs", 0);
    }
}

