/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.js;

import com.fasterxml.jackson.databind.ObjectMapper;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.js.JavaScriptConfig;
import org.junit.Assert;
import org.junit.Test;

public class JavaScriptConfigTest {
    private static ObjectMapper mapper = new ObjectMapper();

    @Test
    public void testSerde() throws Exception {
        String json = "{\"enabled\":true}";
        JavaScriptConfig config = (JavaScriptConfig)mapper.readValue(mapper.writeValueAsString(mapper.readValue(json, JavaScriptConfig.class)), JavaScriptConfig.class);
        Assert.assertTrue((boolean)config.isEnabled());
    }

    @Test
    public void testSerdeWithDefaults() throws Exception {
        String json = "{}";
        JavaScriptConfig config = (JavaScriptConfig)mapper.readValue(mapper.writeValueAsString(mapper.readValue(json, JavaScriptConfig.class)), JavaScriptConfig.class);
        Assert.assertFalse((boolean)config.isEnabled());
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.simple().forClass(JavaScriptConfig.class).usingGetClass().withNonnullFields(new String[]{"enabled"}).verify();
    }

    @Test
    public void testToString() {
        JavaScriptConfig javaScriptConfig = new JavaScriptConfig(true);
        Assert.assertEquals((Object)"JavaScriptConfig{enabled=true}", (Object)javaScriptConfig.toString());
    }

    @Test
    public void testEnabledInstance() {
        JavaScriptConfig javaScriptConfig = JavaScriptConfig.getEnabledInstance();
        Assert.assertTrue((boolean)javaScriptConfig.isEnabled());
        Assert.assertSame((Object)javaScriptConfig, (Object)JavaScriptConfig.getEnabledInstance());
    }
}

