/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import org.apache.druid.error.DruidException;
import org.apache.druid.query.DruidMetrics;
import org.apache.druid.query.QueryException;
import org.junit.Assert;
import org.junit.Test;

public class DruidMetricsTest {
    @Test
    public void testComputeStatusCode_nullError() {
        Assert.assertEquals((long)200L, (long)DruidMetrics.computeStatusCode(null));
    }

    @Test
    public void testComputeStatusCode_allDruidExceptionCategories() {
        for (DruidException.Category cat : DruidException.Category.values()) {
            Assert.assertEquals((long)cat.getExpectedStatus(), (long)DruidMetrics.computeStatusCode((Throwable)DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(cat).build("test", new Object[0])));
        }
    }

    @Test
    public void testComputeStatusCode_queryExceptionCategories() {
        Assert.assertEquals((long)500L, (long)DruidMetrics.computeStatusCode((Throwable)new QueryException(null, "Query cancelled", null, null, null)));
        Assert.assertEquals((long)504L, (long)DruidMetrics.computeStatusCode((Throwable)new QueryException(null, "Query timeout", null, null, null)));
        Assert.assertEquals((long)429L, (long)DruidMetrics.computeStatusCode((Throwable)new QueryException(null, "Query capacity exceeded", null, null, null)));
        Assert.assertEquals((long)401L, (long)DruidMetrics.computeStatusCode((Throwable)new QueryException(null, "Unauthorized request", null, null, null)));
        Assert.assertEquals((long)400L, (long)DruidMetrics.computeStatusCode((Throwable)new QueryException(null, "Query context parse failed", null, null, null)));
        Assert.assertEquals((long)501L, (long)DruidMetrics.computeStatusCode((Throwable)new QueryException(null, "Unsupported query", null, null, null)));
    }
}

