/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.query.IterableRowsCursorHelper;
import org.apache.druid.query.QueryToolChestTestHelper;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.junit.Test;

public class IterableRowsCursorHelperTest {
    List<Object[]> rows = ImmutableList.of((Object)new Object[]{1, "a"}, (Object)new Object[]{3, "b"}, (Object)new Object[]{2, "b"});
    RowSignature rowSignature = RowSignature.builder().add("dim1", ColumnType.LONG).add("dim2", ColumnType.STRING).build();

    @Test
    public void getCursorFromIterable() {
        Cursor cursor = (Cursor)IterableRowsCursorHelper.getCursorFromIterable(this.rows, (RowSignature)this.rowSignature).lhs;
        this.testCursorMatchesRowSequence(cursor, this.rowSignature, this.rows);
    }

    @Test
    public void getCursorFromSequence() {
        Cursor cursor = (Cursor)IterableRowsCursorHelper.getCursorFromSequence((Sequence)Sequences.simple(this.rows), (RowSignature)this.rowSignature).lhs;
        this.testCursorMatchesRowSequence(cursor, this.rowSignature, this.rows);
    }

    @Test
    public void getCursorFromYielder() {
        Cursor cursor = (Cursor)IterableRowsCursorHelper.getCursorFromYielder((Yielder)Yielders.each((Sequence)Sequences.simple(this.rows)), (RowSignature)this.rowSignature).lhs;
        this.testCursorMatchesRowSequence(cursor, this.rowSignature, this.rows);
    }

    private void testCursorMatchesRowSequence(Cursor cursor, RowSignature expectedRowSignature, List<Object[]> expectedRows) {
        ArrayList<Object[]> actualRows = new ArrayList<Object[]>();
        while (!cursor.isDone()) {
            Object[] row = new Object[expectedRowSignature.size()];
            for (int i = 0; i < expectedRowSignature.size(); ++i) {
                ColumnValueSelector columnValueSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector(expectedRowSignature.getColumnName(i));
                row[i] = columnValueSelector.getObject();
            }
            actualRows.add(row);
            cursor.advance();
        }
        QueryToolChestTestHelper.assertArrayResultsEquals(expectedRows, (Sequence<Object[]>)Sequences.simple(actualRows));
    }
}

