/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.FilteredDataSource;
import org.apache.druid.query.JoinAlgorithm;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.RestrictedDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnnestDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.FalseDimFilter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.TrueDimFilter;
import org.apache.druid.query.planning.ExecutionVertexTest;
import org.apache.druid.query.planning.JoinDataSourceAnalysis;
import org.apache.druid.query.policy.NoRestrictionPolicy;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.segment.join.NoopJoinableFactory;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.easymock.Mock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class JoinDataSourceTest {
    public static final JoinableFactoryWrapper NOOP_JOINABLE_FACTORY_WRAPPER = new JoinableFactoryWrapper((JoinableFactory)NoopJoinableFactory.INSTANCE);
    private final TableDataSource fooTable = new TableDataSource("foo");
    private final TableDataSource barTable = new TableDataSource("bar");
    private final LookupDataSource lookylooLookup = new LookupDataSource("lookyloo");
    private final JoinDataSource joinTableToLookup = JoinDataSource.create((DataSource)this.fooTable, (DataSource)this.lookylooLookup, (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), null, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
    private final JoinDataSource joinTableToTable = JoinDataSource.create((DataSource)this.fooTable, (DataSource)this.barTable, (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), null, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
    @Mock
    private JoinableFactoryWrapper joinableFactoryWrapper;

    @Test
    public void test_getTableNames_tableToTable() {
        Assert.assertEquals((Object)ImmutableSet.of((Object)"foo", (Object)"bar"), (Object)this.joinTableToTable.getTableNames());
    }

    @Test
    public void test_getTableNames_tableToLookup() {
        Assert.assertEquals(Collections.singleton("foo"), (Object)this.joinTableToLookup.getTableNames());
    }

    @Test
    public void test_getChildren_tableToTable() {
        Assert.assertEquals((Object)ImmutableList.of((Object)this.fooTable, (Object)this.barTable), (Object)this.joinTableToTable.getChildren());
    }

    @Test
    public void test_getChildren_tableToLookup() {
        Assert.assertEquals((Object)ImmutableList.of((Object)this.fooTable, (Object)this.lookylooLookup), (Object)this.joinTableToLookup.getChildren());
    }

    @Test
    public void test_isCacheable_tableToTable() {
        Assert.assertTrue((boolean)this.joinTableToTable.isCacheable(true));
        Assert.assertTrue((boolean)this.joinTableToTable.isCacheable(false));
    }

    @Test
    public void test_isCacheable_lookup() {
        Assert.assertFalse((boolean)this.joinTableToLookup.isCacheable(true));
        Assert.assertFalse((boolean)this.joinTableToLookup.isCacheable(false));
    }

    @Test
    public void test_isProcessable_tableToTable() {
        Assert.assertFalse((boolean)this.joinTableToTable.isProcessable());
    }

    @Test
    public void test_isProcessable_tableToLookup() {
        Assert.assertTrue((boolean)this.joinTableToLookup.isProcessable());
    }

    @Test
    public void test_isGlobal_tableToTable() {
        Assert.assertFalse((boolean)this.joinTableToTable.isGlobal());
    }

    @Test
    public void test_isGlobal_tableToLookup() {
        Assert.assertFalse((boolean)this.joinTableToLookup.isGlobal());
    }

    @Test
    public void test_withChildren_empty() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.joinTableToTable.withChildren(Collections.emptyList()));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Expected [2] children, got [0]"));
    }

    @Test
    public void test_withChildren_two() {
        DataSource transformed = this.joinTableToTable.withChildren((List)ImmutableList.of((Object)this.fooTable, (Object)this.lookylooLookup));
        Assert.assertEquals((Object)this.joinTableToLookup, (Object)transformed);
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(JoinDataSource.class).usingGetClass().withNonnullFields(new String[]{"left", "right", "rightPrefix", "conditionAnalysis", "joinType"}).withIgnoredFields(new String[]{"joinableFactoryWrapper"}).verify();
    }

    @Test
    public void test_serde() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapperForJoinable(this.joinableFactoryWrapper);
        JoinDataSource joinDataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, (DimFilter)TrueDimFilter.instance(), (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)this.joinableFactoryWrapper, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        JoinDataSource deserialized = (JoinDataSource)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)joinDataSource), DataSource.class);
        Assert.assertEquals((Object)joinDataSource, (Object)deserialized);
    }

    @Test
    public void testException_leftFilterOnNonTableSource() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> JoinDataSource.create((DataSource)new QueryDataSource((Query)ExecutionVertexTest.makeScanQuery((DataSource)this.barTable)), (DataSource)new TableDataSource("table"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, (DimFilter)FalseDimFilter.instance(), (ExprMacroTable)ExprMacroTable.nil(), null, (JoinAlgorithm)JoinAlgorithm.BROADCAST));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"left filter is only supported if left data source is direct table access"));
    }

    @Test
    public void testLeftFilter() {
        JoinDataSource dataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, (DimFilter)TrueDimFilter.instance(), (ExprMacroTable)ExprMacroTable.nil(), null, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        Assert.assertEquals(null, (Object)dataSource.getLeftFilter());
    }

    @Test
    public void testVirtualColumnCandidates() {
        JoinDataSource dataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), null, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        Assert.assertEquals((Object)dataSource.getVirtualColumnCandidates(), (Object)ImmutableSet.of((Object)"x"));
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_noHashJoin() {
        JoinDataSource dataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)NOOP_JOINABLE_FACTORY_WRAPPER, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        Optional<byte[]> cacheKey = Optional.ofNullable(dataSource.getCacheKey());
        Assert.assertTrue((boolean)cacheKey.isPresent());
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_sameKeyForSameJoin() {
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new JoinableFactoryWithCacheKey());
        JoinDataSource joinDataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        JoinDataSource joinDataSource1 = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        byte[] cacheKey1 = joinDataSource.getCacheKey();
        byte[] cacheKey2 = joinDataSource1.getCacheKey();
        Assert.assertNotEquals((long)cacheKey1.length, (long)0L);
        Assert.assertNotEquals((long)cacheKey2.length, (long)0L);
        Assert.assertTrue((boolean)Arrays.equals(cacheKey1, cacheKey2));
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_keyChangesWithTables() {
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new JoinableFactoryWithCacheKey());
        JoinDataSource joinDataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        JoinDataSource joinDataSource1 = JoinDataSource.create((DataSource)new TableDataSource("table11"), (DataSource)new TableDataSource("table12"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        byte[] cacheKey1 = joinDataSource.getCacheKey();
        byte[] cacheKey2 = joinDataSource1.getCacheKey();
        Assert.assertNotEquals((long)cacheKey1.length, (long)0L);
        Assert.assertNotEquals((long)cacheKey2.length, (long)0L);
        Assert.assertFalse((boolean)Arrays.equals(cacheKey1, cacheKey2));
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_keyChangesWithExpressions() {
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new JoinableFactoryWithCacheKey());
        JoinDataSource joinDataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        JoinDataSource joinDataSource1 = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"y == \"j.y\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        byte[] cacheKey1 = joinDataSource.getCacheKey();
        byte[] cacheKey2 = joinDataSource1.getCacheKey();
        Assert.assertNotEquals((long)cacheKey1.length, (long)0L);
        Assert.assertNotEquals((long)cacheKey2.length, (long)0L);
        Assert.assertFalse((boolean)Arrays.equals(cacheKey1, cacheKey2));
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_keyChangesWithJoinType() {
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new JoinableFactoryWithCacheKey());
        JoinDataSource joinDataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        JoinDataSource joinDataSource1 = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.INNER, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        byte[] cacheKey1 = joinDataSource.getCacheKey();
        byte[] cacheKey2 = joinDataSource1.getCacheKey();
        Assert.assertNotEquals((long)cacheKey1.length, (long)0L);
        Assert.assertNotEquals((long)cacheKey2.length, (long)0L);
        Assert.assertFalse((boolean)Arrays.equals(cacheKey1, cacheKey2));
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_keyChangesWithPrefix() {
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new JoinableFactoryWithCacheKey());
        JoinDataSource joinDataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        JoinDataSource joinDataSource1 = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"ab.", (String)"x == \"ab.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        byte[] cacheKey1 = joinDataSource.getCacheKey();
        byte[] cacheKey2 = joinDataSource1.getCacheKey();
        Assert.assertNotEquals((long)cacheKey1.length, (long)0L);
        Assert.assertNotEquals((long)cacheKey2.length, (long)0L);
        Assert.assertFalse((boolean)Arrays.equals(cacheKey1, cacheKey2));
    }

    @Test
    public void testGetAnalysisWithUnnestDS() {
        JoinDataSource dataSource = JoinDataSource.create((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("table1"), (VirtualColumn)new ExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING, ExprMacroTable.nil()), null), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), null, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        JoinDataSourceAnalysis analysis = dataSource.getJoinAnalysisForDataSource();
        Assert.assertEquals((Object)"table1", analysis.getBaseDataSource().getTableNames().iterator().next());
    }

    @Test
    public void testGetAnalysisWithFilteredDS() {
        JoinDataSource dataSource = JoinDataSource.create((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)new TableDataSource("table1"), (DimFilter)TrueDimFilter.instance()), (VirtualColumn)new ExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING, ExprMacroTable.nil()), null), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), null, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        JoinDataSourceAnalysis analysis = dataSource.getJoinAnalysisForDataSource();
        Assert.assertEquals((Object)"table1", analysis.getBaseDataSource().getTableNames().iterator().next());
    }

    @Test
    public void testGetAnalysisWithRestrictedDS() {
        RestrictedDataSource left = RestrictedDataSource.create((DataSource)new TableDataSource("table1"), (Policy)NoRestrictionPolicy.instance());
        JoinDataSource dataSource = JoinDataSource.create((DataSource)left, (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), null, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        JoinDataSourceAnalysis analysis = dataSource.getJoinAnalysisForDataSource();
        Assert.assertEquals((Object)left, (Object)analysis.getBaseDataSource());
        Assert.assertEquals((Object)"table1", analysis.getBaseDataSource().getTableNames().iterator().next());
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_keyChangesWithBaseFilter() {
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new JoinableFactoryWithCacheKey());
        InDimFilter expectedInDimFilter = new InDimFilter("dimTest", Arrays.asList("good", "bad"), null);
        JoinDataSource joinDataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, (DimFilter)expectedInDimFilter, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        JoinDataSource joinDataSource1 = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        byte[] cacheKey1 = joinDataSource.getCacheKey();
        byte[] cacheKey2 = joinDataSource1.getCacheKey();
        Assert.assertNotEquals((long)cacheKey1.length, (long)0L);
        Assert.assertNotEquals((long)cacheKey2.length, (long)0L);
        Assert.assertFalse((boolean)Arrays.equals(cacheKey1, cacheKey2));
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_cachingUnsupported() {
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new JoinableFactoryWithCacheKey());
        JoinDataSource joinDataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new LookupDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        byte[] cacheKey1 = joinDataSource.getCacheKey();
        Assert.assertNull((Object)cacheKey1);
    }

    private static class JoinableFactoryWithCacheKey
    extends NoopJoinableFactory {
        private JoinableFactoryWithCacheKey() {
        }

        public Optional<byte[]> computeJoinCacheKey(DataSource dataSource, JoinConditionAnalysis condition) {
            if (dataSource.isCacheable(false) && condition.canHashJoin()) {
                String tableName = (String)Iterators.getOnlyElement(dataSource.getTableNames().iterator());
                return Optional.of(StringUtils.toUtf8((String)tableName));
            }
            return Optional.empty();
        }
    }
}

