/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.druid.query.QueryException;
import org.junit.Assert;
import org.junit.Test;

public class QueryExceptionTest {
    private static final String ERROR_CODE = "error code";
    private static final String ERROR_CLASS = "error code";
    private static final String HOST = "error code";
    private static final String ERROR_MESSAGE_ORIGINAL = "aaaa";
    private static final String ERROR_MESSAGE_TRANSFORMED = "bbbb";

    @Test
    public void testSanitizeWithTransformFunctionReturningNull() {
        QueryException queryException = new QueryException("error code", ERROR_MESSAGE_ORIGINAL, "error code", "error code");
        AtomicLong callCount = new AtomicLong(0L);
        QueryException actual = queryException.sanitize(s -> {
            callCount.incrementAndGet();
            Assert.assertEquals((Object)ERROR_MESSAGE_ORIGINAL, (Object)s);
            return null;
        });
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)actual.getErrorCode(), (Object)"error code");
        Assert.assertNull((Object)actual.getMessage());
        Assert.assertNull((Object)actual.getHost());
        Assert.assertNull((Object)actual.getErrorClass());
        Assert.assertEquals((long)1L, (long)callCount.get());
    }

    @Test
    public void testSanitizeWithTransformFunctionReturningNewString() {
        QueryException queryException = new QueryException("error code", ERROR_MESSAGE_ORIGINAL, "error code", "error code");
        AtomicLong callCount = new AtomicLong(0L);
        QueryException actual = queryException.sanitize(s -> {
            callCount.incrementAndGet();
            Assert.assertEquals((Object)ERROR_MESSAGE_ORIGINAL, (Object)s);
            return ERROR_MESSAGE_TRANSFORMED;
        });
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)actual.getErrorCode(), (Object)"error code");
        Assert.assertEquals((Object)actual.getMessage(), (Object)ERROR_MESSAGE_TRANSFORMED);
        Assert.assertNull((Object)actual.getHost());
        Assert.assertNull((Object)actual.getErrorClass());
        Assert.assertEquals((long)1L, (long)callCount.get());
    }

    @Test
    public void testSanity() {
        this.expectFailTypeForCode(QueryException.FailType.UNKNOWN, null);
        this.expectFailTypeForCode(QueryException.FailType.UNKNOWN, "Nobody knows me.");
        this.expectFailTypeForCode(QueryException.FailType.QUERY_RUNTIME_FAILURE, "Unknown exception");
        this.expectFailTypeForCode(QueryException.FailType.USER_ERROR, "Json parse failed");
        this.expectFailTypeForCode(QueryException.FailType.USER_ERROR, "Query context parse failed");
        this.expectFailTypeForCode(QueryException.FailType.CAPACITY_EXCEEDED, "Query capacity exceeded");
        this.expectFailTypeForCode(QueryException.FailType.QUERY_RUNTIME_FAILURE, "Query interrupted");
        this.expectFailTypeForCode(QueryException.FailType.CANCELED, "Query cancelled");
        this.expectFailTypeForCode(QueryException.FailType.UNAUTHORIZED, "Unauthorized request");
        this.expectFailTypeForCode(QueryException.FailType.QUERY_RUNTIME_FAILURE, "Unsupported operation");
        this.expectFailTypeForCode(QueryException.FailType.QUERY_RUNTIME_FAILURE, "Truncated response context");
        this.expectFailTypeForCode(QueryException.FailType.TIMEOUT, "Query timeout");
        this.expectFailTypeForCode(QueryException.FailType.UNSUPPORTED, "Unsupported query");
        this.expectFailTypeForCode(QueryException.FailType.USER_ERROR, "Resource limit exceeded");
        this.expectFailTypeForCode(QueryException.FailType.USER_ERROR, "SQL parse failed");
        this.expectFailTypeForCode(QueryException.FailType.USER_ERROR, "Plan validation failed");
        this.expectFailTypeForCode(QueryException.FailType.USER_ERROR, "SQL query is unsupported");
    }

    @Test
    public void testCanConstructWithoutThrowable() {
        QueryException exception = new QueryException((Throwable)null, "Unknown exception", "java.lang.Exception", "test");
        Assert.assertEquals((Object)"Unknown exception", (Object)exception.getErrorCode());
        Assert.assertNull((Object)exception.getMessage());
    }

    @Test
    public void testToStringReturnsUsefulInformation() {
        QueryException queryException = new QueryException("error code", ERROR_MESSAGE_ORIGINAL, "error code", "error code");
        String exceptionToString = queryException.toString();
        Assert.assertTrue((boolean)exceptionToString.startsWith(QueryException.class.getSimpleName()));
        Assert.assertTrue((boolean)exceptionToString.contains("msg=aaaa"));
        Assert.assertTrue((boolean)exceptionToString.contains("code=error code"));
        Assert.assertTrue((boolean)exceptionToString.contains("class=error code"));
        Assert.assertTrue((boolean)exceptionToString.contains("host=error code"));
    }

    private void expectFailTypeForCode(QueryException.FailType expected, String code) {
        QueryException exception = new QueryException((Throwable)new Exception(), code, "java.lang.Exception", "test");
        Assert.assertEquals((String)code, (Object)expected, (Object)exception.getFailType());
    }
}

