/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import org.apache.druid.query.QueryTimeoutException;
import org.junit.Assert;
import org.junit.Test;

public class QueryTimeoutExceptionTest {
    @Test
    public void testSerde() throws IOException {
        ObjectMapper mapper = new ObjectMapper(){
            {
                this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                this.configure(MapperFeature.AUTO_DETECT_GETTERS, false);
                this.configure(MapperFeature.AUTO_DETECT_FIELDS, false);
                this.configure(MapperFeature.AUTO_DETECT_IS_GETTERS, false);
                this.configure(MapperFeature.AUTO_DETECT_SETTERS, false);
                this.configure(MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS, false);
                this.configure(SerializationFeature.INDENT_OUTPUT, false);
                this.configure(SerializationFeature.FLUSH_AFTER_WRITE_VALUE, false);
            }
        };
        QueryTimeoutException timeoutException = (QueryTimeoutException)mapper.readValue(mapper.writeValueAsBytes((Object)new QueryTimeoutException()), QueryTimeoutException.class);
        QueryTimeoutException timeoutExceptionWithMsg = (QueryTimeoutException)mapper.readValue(mapper.writeValueAsBytes((Object)new QueryTimeoutException("Another query timeout")), QueryTimeoutException.class);
        Assert.assertEquals((Object)"Query timeout", (Object)timeoutException.getErrorCode());
        Assert.assertEquals((Object)"Query did not complete within configured timeout period. You can increase query timeout or tune the performance of query.", (Object)timeoutException.getMessage());
        Assert.assertEquals((Object)"Another query timeout", (Object)timeoutExceptionWithMsg.getMessage());
        Assert.assertEquals((Object)"org.apache.druid.query.QueryTimeoutException", (Object)timeoutExceptionWithMsg.getErrorClass());
    }

    @Test
    public void testExceptionHost() {
        Assert.assertEquals((Object)"timeouthost", (Object)new QueryTimeoutException("Timed out", "timeouthost").getHost());
    }
}

