/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.RestrictedDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.TrueDimFilter;
import org.apache.druid.query.policy.NoRestrictionPolicy;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.query.policy.RowFilterPolicy;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class RestrictedDataSourceTest {
    private final TableDataSource fooDataSource = new TableDataSource("foo");
    private final TableDataSource barDataSource = new TableDataSource("bar");
    private final RestrictedDataSource restrictedFooDataSource = RestrictedDataSource.create((DataSource)this.fooDataSource, (Policy)RowFilterPolicy.from((DimFilter)TrueDimFilter.instance()));
    private final RestrictedDataSource restrictedBarDataSource = RestrictedDataSource.create((DataSource)this.barDataSource, (Policy)NoRestrictionPolicy.instance());

    @Test
    public void test_creation_failWithNullPolicy() {
        IAE e = (IAE)Assert.assertThrows(IAE.class, () -> RestrictedDataSource.create((DataSource)this.fooDataSource, null));
        Assert.assertEquals((Object)e.getMessage(), (Object)"Policy can't be null for RestrictedDataSource");
    }

    @Test
    public void test_getTableNames() {
        Assert.assertEquals(Collections.singleton("foo"), (Object)this.restrictedFooDataSource.getTableNames());
        Assert.assertEquals(Collections.singleton("bar"), (Object)this.restrictedBarDataSource.getTableNames());
    }

    @Test
    public void test_getChildren() {
        Assert.assertEquals(Collections.singletonList(this.fooDataSource), (Object)this.restrictedFooDataSource.getChildren());
        Assert.assertEquals(Collections.singletonList(this.barDataSource), (Object)this.restrictedBarDataSource.getChildren());
    }

    @Test
    public void test_isCacheable() {
        Assert.assertFalse((boolean)this.restrictedFooDataSource.isCacheable(true));
    }

    @Test
    public void test_isGlobal() {
        Assert.assertFalse((boolean)this.restrictedFooDataSource.isGlobal());
    }

    @Test
    public void test_isConcrete() {
        Assert.assertTrue((boolean)this.restrictedFooDataSource.isProcessable());
    }

    @Test
    public void test_withChildren() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.restrictedFooDataSource.withChildren(Collections.emptyList()));
        Assert.assertEquals((Object)exception.getMessage(), (Object)"Expected [1] child, got [0]");
        IllegalArgumentException exception2 = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.restrictedFooDataSource.withChildren((List)ImmutableList.of((Object)this.fooDataSource, (Object)this.barDataSource)));
        Assert.assertEquals((Object)exception2.getMessage(), (Object)"Expected [1] child, got [2]");
        RestrictedDataSource newRestrictedDataSource = (RestrictedDataSource)this.restrictedFooDataSource.withChildren((List)ImmutableList.of((Object)this.barDataSource));
        Assert.assertEquals((Object)newRestrictedDataSource.getBase(), (Object)this.barDataSource);
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(RestrictedDataSource.class).usingGetClass().withNonnullFields(new String[]{"base", "policy"}).verify();
    }

    @Test
    public void test_serde_roundTrip() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        RestrictedDataSource deserialized = (RestrictedDataSource)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)this.restrictedFooDataSource), DataSource.class);
        Assert.assertEquals((Object)this.restrictedFooDataSource, (Object)deserialized);
    }

    @Test
    public void test_deserialize_fromObject() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        RestrictedDataSource deserializedRestrictedDataSource = (RestrictedDataSource)jsonMapper.readValue("{\"type\":\"restrict\",\"base\":{\"type\":\"table\",\"name\":\"foo\"},\"policy\":{\"type\":\"noRestriction\"}}", RestrictedDataSource.class);
        Assert.assertEquals((Object)deserializedRestrictedDataSource, (Object)RestrictedDataSource.create((DataSource)this.fooDataSource, (Policy)NoRestrictionPolicy.instance()));
    }

    @Test
    public void test_serialize() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        String s = jsonMapper.writeValueAsString((Object)this.restrictedFooDataSource);
        Assert.assertEquals((Object)"{\"type\":\"restrict\",\"base\":{\"type\":\"table\",\"name\":\"foo\"},\"policy\":{\"type\":\"row\",\"rowFilter\":{\"type\":\"true\"}}}", (Object)s);
    }

    @Test
    public void testStringRep() {
        Assert.assertNotEquals((Object)this.restrictedFooDataSource.toString(), (Object)this.restrictedBarDataSource.toString());
    }
}

