/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.AbstractSerializablePairLongObjectBufferStore;
import org.apache.druid.query.aggregation.AbstractSerializablePairLongObjectColumnHeader;
import org.apache.druid.query.aggregation.SerializablePairLongLong;
import org.apache.druid.query.aggregation.SerializablePairLongLongBufferStore;
import org.apache.druid.query.aggregation.SerializablePairLongLongColumnHeader;
import org.apache.druid.query.aggregation.SerializablePairLongLongComplexColumn;
import org.apache.druid.query.aggregation.SerializablePairLongLongComplexMetricSerde;
import org.apache.druid.query.aggregation.SerializablePairLongLongSimpleStagedSerde;
import org.apache.druid.query.aggregation.SerializedStorage;
import org.apache.druid.segment.column.BaseColumnHolder;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.serde.cell.ByteBufferProvider;
import org.apache.druid.segment.serde.cell.IOIterator;
import org.apache.druid.segment.serde.cell.NativeClearedByteBufferProvider;
import org.apache.druid.segment.serde.cell.StagedSerde;
import org.apache.druid.segment.writeout.HeapByteBufferWriteOutBytes;
import org.apache.druid.segment.writeout.OnHeapMemorySegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SerializablePairLongLongBufferStoreTest {
    private final Random random = new Random(0L);
    private static final int MIN_INTEGER = 100;
    private static final long MIN_LONG = 0L;
    private final SerializablePairLongLong[] integerRangeArr = new SerializablePairLongLong[]{new SerializablePairLongLong(Long.valueOf(100L), Long.valueOf(10L)), new SerializablePairLongLong(Long.valueOf(101L), Long.valueOf(20L)), new SerializablePairLongLong(Long.valueOf(102L), Long.valueOf(30L))};
    private final SerializablePairLongLong[] longRangeArr = new SerializablePairLongLong[]{new SerializablePairLongLong(Long.valueOf(0L), Long.valueOf(10L)), new SerializablePairLongLong(Long.valueOf(101L), Long.valueOf(20L)), new SerializablePairLongLong(Long.valueOf(102L), Long.valueOf(30L)), new SerializablePairLongLong(Long.valueOf(Integer.MAX_VALUE), Long.valueOf(40L)), new SerializablePairLongLong(Long.valueOf(Long.MAX_VALUE), Long.valueOf(50L))};
    private final SegmentWriteOutMedium writeOutMedium = new OnHeapMemorySegmentWriteOutMedium();
    private SerializablePairLongLongBufferStore bufferStore;

    @Before
    public void setup() throws Exception {
        this.bufferStore = new SerializablePairLongLongBufferStore(new SerializedStorage(this.writeOutMedium.makeWriteOutBytes(), (StagedSerde)new SerializablePairLongLongSimpleStagedSerde()));
    }

    @Test
    public void testIteratorSimple() throws Exception {
        for (SerializablePairLongLong value : this.integerRangeArr) {
            this.bufferStore.store((SerializablePair)value);
        }
        IOIterator iterator = this.bufferStore.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Assert.assertEquals((Object)this.integerRangeArr[i], (Object)iterator.next());
            ++i;
        }
    }

    @Test
    public void testIteratorNull() throws Exception {
        this.bufferStore.store(null);
        IOIterator iterator = this.bufferStore.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertNull((Object)iterator.next());
    }

    @Test
    public void testIteratorIdempotentHasNext() throws Exception {
        this.bufferStore.store((SerializablePair)this.integerRangeArr[0]);
        IOIterator iterator = this.bufferStore.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)iterator.hasNext());
    }

    @Test(expected=NoSuchElementException.class)
    public void testIteratorEmptyThrows() throws Exception {
        IOIterator iterator = this.bufferStore.iterator();
        iterator.next();
    }

    @Test
    public void testIteratorEmptyHasNext() throws Exception {
        IOIterator iterator = this.bufferStore.iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testMinValueUsesInteger() throws Exception {
        for (SerializablePairLongLong value : this.integerRangeArr) {
            this.bufferStore.store((SerializablePair)value);
        }
        SerializablePairLongLongColumnHeader columnHeader = (SerializablePairLongLongColumnHeader)this.bufferStore.createColumnHeader();
        Assert.assertEquals((long)((Long)this.integerRangeArr[0].lhs), (long)columnHeader.getMinValue());
        Assert.assertTrue((boolean)columnHeader.isUseIntegerDeltas());
    }

    @Test
    public void testMinValueUsesLong() throws Exception {
        for (SerializablePairLongLong value : this.longRangeArr) {
            this.bufferStore.store((SerializablePair)value);
        }
        SerializablePairLongLongColumnHeader columnHeader = (SerializablePairLongLongColumnHeader)this.bufferStore.createColumnHeader();
        Assert.assertEquals((long)0L, (long)columnHeader.getMinValue());
        Assert.assertFalse((boolean)columnHeader.isUseIntegerDeltas());
    }

    @Test
    public void testMinValueUsesIntegerSerialization() throws Exception {
        for (SerializablePairLongLong value : this.integerRangeArr) {
            this.bufferStore.store((SerializablePair)value);
        }
        SerializablePairLongLongColumnHeader columnHeader = (SerializablePairLongLongColumnHeader)this.bufferStore.createColumnHeader();
        HeapByteBufferWriteOutBytes channel = new HeapByteBufferWriteOutBytes();
        try (ResourceHolder resourceHolder = NativeClearedByteBufferProvider.INSTANCE.get();){
            columnHeader.transferTo((WritableByteChannel)channel);
            ByteBuffer byteBuffer = (ByteBuffer)resourceHolder.get();
            channel.writeTo(byteBuffer);
            byteBuffer.flip();
            SerializablePairLongLongColumnHeader deserializedColumnhHeader = (SerializablePairLongLongColumnHeader)AbstractSerializablePairLongObjectColumnHeader.fromBuffer((ByteBuffer)byteBuffer, SerializablePairLongLong.class);
            Assert.assertEquals((long)100L, (long)deserializedColumnhHeader.getMinValue());
            Assert.assertTrue((boolean)deserializedColumnhHeader.isUseIntegerDeltas());
        }
    }

    @Test
    public void testMinValueSerialization() throws Exception {
        for (SerializablePairLongLong value : this.longRangeArr) {
            this.bufferStore.store((SerializablePair)value);
        }
        SerializablePairLongLongColumnHeader columnHeader = (SerializablePairLongLongColumnHeader)this.bufferStore.createColumnHeader();
        HeapByteBufferWriteOutBytes channel = new HeapByteBufferWriteOutBytes();
        try (ResourceHolder resourceHolder = NativeClearedByteBufferProvider.INSTANCE.get();){
            columnHeader.transferTo((WritableByteChannel)channel);
            ByteBuffer byteBuffer = (ByteBuffer)resourceHolder.get();
            channel.writeTo(byteBuffer);
            byteBuffer.flip();
            SerializablePairLongLongColumnHeader deserializedColumnhHeader = (SerializablePairLongLongColumnHeader)AbstractSerializablePairLongObjectColumnHeader.fromBuffer((ByteBuffer)byteBuffer, SerializablePairLongLong.class);
            Assert.assertEquals((long)0L, (long)deserializedColumnhHeader.getMinValue());
            Assert.assertFalse((boolean)deserializedColumnhHeader.isUseIntegerDeltas());
        }
    }

    @Test
    public void testLargeBuffer() throws Exception {
        SerializablePairLongLong value = new SerializablePairLongLong(Long.valueOf(Long.MAX_VALUE), Long.valueOf(Long.MAX_VALUE));
        this.bufferStore.store((SerializablePair)value);
        IOIterator iterator = this.bufferStore.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)value, (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testLargeValueCount() throws Exception {
        ArrayList<SerializablePairLongLong> valueList = new ArrayList<SerializablePairLongLong>();
        for (int i = 0; i < 10000; ++i) {
            valueList.add(new SerializablePairLongLong(Long.valueOf(Integer.MAX_VALUE + (long)i), Long.valueOf(this.random.nextLong())));
        }
        this.assertBufferedValuesEqual(valueList);
    }

    @Test
    public void testOverflowTransfer() throws Exception {
        this.bufferStore.store((SerializablePair)new SerializablePairLongLong(Long.valueOf(Long.MIN_VALUE), Long.valueOf(10L)));
        this.bufferStore.store((SerializablePair)new SerializablePairLongLong(Long.valueOf(Long.MAX_VALUE), Long.valueOf(10L)));
        SerializablePairLongLongColumnHeader columnHeader = (SerializablePairLongLongColumnHeader)this.bufferStore.createColumnHeader();
        Assert.assertEquals((long)0L, (long)columnHeader.getMinValue());
        AbstractSerializablePairLongObjectBufferStore.TransferredBuffer transferredBuffer = this.bufferStore.transferToRowWriter((ByteBufferProvider)NativeClearedByteBufferProvider.INSTANCE, this.writeOutMedium);
        Assert.assertEquals((long)94L, (long)transferredBuffer.getSerializedSize());
    }

    @Test
    public void testNullOnlyTransfer() throws Exception {
        this.bufferStore.store(null);
        this.bufferStore.store(null);
        this.bufferStore.store(null);
        SerializablePairLongLongColumnHeader columnHeader = (SerializablePairLongLongColumnHeader)this.bufferStore.createColumnHeader();
        Assert.assertEquals((long)0L, (long)columnHeader.getMinValue());
        AbstractSerializablePairLongObjectBufferStore.TransferredBuffer transferredBuffer = this.bufferStore.transferToRowWriter((ByteBufferProvider)NativeClearedByteBufferProvider.INSTANCE, this.writeOutMedium);
        Assert.assertEquals((long)59L, (long)transferredBuffer.getSerializedSize());
    }

    @Test
    public void testTransferIntegerRange() throws Exception {
        for (SerializablePairLongLong value : this.integerRangeArr) {
            this.bufferStore.store((SerializablePair)value);
        }
        Assert.assertTrue((boolean)this.bufferStore.createColumnHeader().isUseIntegerDeltas());
        this.assertTransferredValuesEqual(this.integerRangeArr);
    }

    @Test
    public void testTransferLongRange() throws Exception {
        for (SerializablePairLongLong value : this.longRangeArr) {
            this.bufferStore.store((SerializablePair)value);
        }
        Assert.assertFalse((boolean)this.bufferStore.createColumnHeader().isUseIntegerDeltas());
        this.assertTransferredValuesEqual(this.longRangeArr);
    }

    private void assertBufferedValuesEqual(List<SerializablePairLongLong> input) throws IOException {
        for (SerializablePairLongLong pairLongLong : input) {
            this.bufferStore.store((SerializablePair)pairLongLong);
        }
        IOIterator iterator = this.bufferStore.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Assert.assertEquals((Object)input.get(i), (Object)iterator.next());
            ++i;
        }
        Assert.assertEquals((String)StringUtils.format((String)"element count mismatch: expected %s, got %s", (Object[])new Object[]{input.size(), i}), (long)input.size(), (long)i);
    }

    private void assertTransferredValuesEqual(SerializablePairLongLong[] input) throws IOException {
        AbstractSerializablePairLongObjectBufferStore.TransferredBuffer transferredBuffer = this.bufferStore.transferToRowWriter((ByteBufferProvider)NativeClearedByteBufferProvider.INSTANCE, this.writeOutMedium);
        HeapByteBufferWriteOutBytes resultChannel = new HeapByteBufferWriteOutBytes();
        transferredBuffer.writeTo((WritableByteChannel)resultChannel, null);
        try (SerializablePairLongLongComplexColumn column = SerializablePairLongLongBufferStoreTest.createComplexColumn(transferredBuffer, resultChannel);){
            for (int i = 0; i < input.length; ++i) {
                Assert.assertEquals((Object)input[i], (Object)column.getRowValue(i));
            }
        }
    }

    private static SerializablePairLongLongComplexColumn createComplexColumn(AbstractSerializablePairLongObjectBufferStore.TransferredBuffer transferredBuffer, HeapByteBufferWriteOutBytes resultChannel) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(Ints.checkedCast((long)transferredBuffer.getSerializedSize()));
        resultChannel.readFully(0L, byteBuffer);
        byteBuffer.flip();
        SerializablePairLongLongComplexMetricSerde complexMetricSerde = new SerializablePairLongLongComplexMetricSerde();
        ColumnBuilder builder = new ColumnBuilder();
        complexMetricSerde.deserializeColumn(byteBuffer, builder);
        builder.setType(ValueType.COMPLEX);
        BaseColumnHolder columnHolder = builder.build();
        SerializablePairLongLongComplexColumn column = (SerializablePairLongLongComplexColumn)columnHolder.getColumn();
        return column;
    }
}

