/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.TestObjectColumnSelector;
import org.apache.druid.query.aggregation.any.StringAnyAggregatorFactory;
import org.apache.druid.query.aggregation.any.StringAnyBufferAggregator;
import org.junit.Assert;
import org.junit.Test;

public class StringAnyBufferAggregatorTest {
    StringAnyAggregatorFactory factory = new StringAnyAggregatorFactory("billy", "billy", Integer.valueOf(1024), Boolean.valueOf(true));

    private void aggregateBuffer(TestObjectColumnSelector valueSelector, BufferAggregator agg, ByteBuffer buf, int position) {
        agg.aggregate(buf, position);
        valueSelector.increment();
    }

    @Test
    public void testBufferAggregate() {
        String[] strings = new String[]{"AAAA", "BBBB", "CCCC", "DDDD", "EEEE"};
        int maxStringBytes = 1024;
        TestObjectColumnSelector<String> objectColumnSelector = new TestObjectColumnSelector<String>(strings);
        StringAnyBufferAggregator agg = new StringAnyBufferAggregator(objectColumnSelector, maxStringBytes, true);
        ByteBuffer buf = ByteBuffer.allocate(this.factory.getMaxIntermediateSize());
        int position = 0;
        agg.init(buf, position);
        for (int i = 0; i < strings.length; ++i) {
            this.aggregateBuffer(objectColumnSelector, (BufferAggregator)agg, buf, position);
        }
        String result = (String)agg.get(buf, position);
        Assert.assertEquals((Object)strings[0], (Object)result);
    }

    @Test
    public void testBufferAggregateWithFoldCheck() {
        String[] strings = new String[]{"AAAA", "BBBB", "CCCC", "DDDD", "EEEE"};
        int maxStringBytes = 1024;
        TestObjectColumnSelector<String> objectColumnSelector = new TestObjectColumnSelector<String>(strings);
        StringAnyBufferAggregator agg = new StringAnyBufferAggregator(objectColumnSelector, maxStringBytes, true);
        ByteBuffer buf = ByteBuffer.allocate(this.factory.getMaxIntermediateSize());
        int position = 0;
        agg.init(buf, position);
        for (int i = 0; i < strings.length; ++i) {
            this.aggregateBuffer(objectColumnSelector, (BufferAggregator)agg, buf, position);
        }
        String result = (String)agg.get(buf, position);
        Assert.assertEquals((Object)strings[0], (Object)result);
    }

    @Test
    public void testContainsNullBufferAggregate() {
        String[] strings = new String[]{"CCCC", "AAAA", "BBBB", null, "EEEE"};
        int maxStringBytes = 1024;
        TestObjectColumnSelector<String> objectColumnSelector = new TestObjectColumnSelector<String>(strings);
        StringAnyBufferAggregator agg = new StringAnyBufferAggregator(objectColumnSelector, maxStringBytes, true);
        ByteBuffer buf = ByteBuffer.allocate(this.factory.getMaxIntermediateSize());
        int position = 0;
        agg.init(buf, position);
        for (int i = 0; i < strings.length; ++i) {
            this.aggregateBuffer(objectColumnSelector, (BufferAggregator)agg, buf, position);
        }
        String result = (String)agg.get(buf, position);
        Assert.assertEquals((Object)strings[0], (Object)result);
    }

    @Test
    public void testNullFirstBufferAggregate() {
        String[] strings = new String[]{null, "CCCC", "AAAA", "BBBB", "EEEE"};
        int maxStringBytes = 1024;
        TestObjectColumnSelector<String> objectColumnSelector = new TestObjectColumnSelector<String>(strings);
        StringAnyBufferAggregator agg = new StringAnyBufferAggregator(objectColumnSelector, maxStringBytes, true);
        ByteBuffer buf = ByteBuffer.allocate(this.factory.getMaxIntermediateSize());
        int position = 0;
        agg.init(buf, position);
        for (int i = 0; i < strings.length; ++i) {
            this.aggregateBuffer(objectColumnSelector, (BufferAggregator)agg, buf, position);
        }
        String result = (String)agg.get(buf, position);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testNonStringValue() {
        Double[] doubles = new Double[]{1.0, 2.0};
        int maxStringBytes = 1024;
        TestObjectColumnSelector<Double> objectColumnSelector = new TestObjectColumnSelector<Double>(doubles);
        StringAnyBufferAggregator agg = new StringAnyBufferAggregator(objectColumnSelector, maxStringBytes, true);
        ByteBuffer buf = ByteBuffer.allocate(this.factory.getMaxIntermediateSize());
        int position = 0;
        agg.init(buf, position);
        for (int i = 0; i < doubles.length; ++i) {
            this.aggregateBuffer(objectColumnSelector, (BufferAggregator)agg, buf, position);
        }
        String result = (String)agg.get(buf, position);
        Assert.assertEquals((Object)"1.0", (Object)result);
    }

    @Test
    public void testMvds() {
        ArrayList mvd = Lists.newArrayList((Object[])new String[]{"AAAA", "AAAAB", "AAAC"});
        Object[] mvds = new Object[]{null, "CCCC", mvd, "BBBB", "EEEE"};
        int maxStringBytes = 1024;
        TestObjectColumnSelector<Object> objectColumnSelector = new TestObjectColumnSelector<Object>(mvds);
        StringAnyBufferAggregator agg = new StringAnyBufferAggregator(objectColumnSelector, maxStringBytes, true);
        ByteBuffer buf = ByteBuffer.allocate(this.factory.getMaxIntermediateSize() * 2);
        int position = 0;
        int[] positions = new int[]{0, 1, 43, 100, 189};
        Arrays.stream(positions).forEach(i -> agg.init(buf, i));
        for (int i2 = 0; i2 < mvds.length; ++i2) {
            this.aggregateBuffer(objectColumnSelector, (BufferAggregator)agg, buf, positions[i2]);
        }
        String result = (String)agg.get(buf, position);
        Assert.assertNull((Object)result);
        for (int i3 = 0; i3 < positions.length; ++i3) {
            if (i3 == 2) {
                Assert.assertEquals((Object)((Object)mvd).toString(), (Object)agg.get(buf, positions[2]));
                continue;
            }
            Assert.assertEquals((Object)mvds[i3], (Object)agg.get(buf, positions[i3]));
        }
    }

    @Test
    public void testMvdsWithCustomAggregate() {
        ArrayList mvd = Lists.newArrayList((Object[])new String[]{"AAAA", "AAAAB", "AAAC"});
        Object[] mvds = new Object[]{null, "CCCC", mvd, "BBBB", "EEEE"};
        int maxStringBytes = 1024;
        TestObjectColumnSelector<Object> objectColumnSelector = new TestObjectColumnSelector<Object>(mvds);
        StringAnyBufferAggregator agg = new StringAnyBufferAggregator(objectColumnSelector, 1024, false);
        ByteBuffer buf = ByteBuffer.allocate(this.factory.getMaxIntermediateSize() * 2);
        int position = 0;
        int[] positions = new int[]{0, 1, 43, 100, 189};
        Arrays.stream(positions).forEach(i -> agg.init(buf, i));
        for (int i2 = 0; i2 < mvds.length; ++i2) {
            this.aggregateBuffer(objectColumnSelector, (BufferAggregator)agg, buf, positions[i2]);
        }
        String result = (String)agg.get(buf, position);
        Assert.assertNull((Object)result);
        for (int i3 = 0; i3 < positions.length; ++i3) {
            if (i3 == 2) {
                Assert.assertEquals(mvd.get(0), (Object)agg.get(buf, positions[2]));
                continue;
            }
            Assert.assertEquals((Object)mvds[i3], (Object)agg.get(buf, positions[i3]));
        }
    }
}

