/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.firstlast.first;

import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.aggregation.SerializablePairLongLong;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.firstlast.first.LongFirstAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.first.LongFirstVectorAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.vector.BaseLongVectorValueSelector;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.NoFilterVectorOffset;
import org.apache.druid.segment.vector.ReadableVectorInspector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LongFirstVectorAggregatorTest
extends InitializedNullHandlingTest {
    private static final double EPSILON = 1.0E-5;
    private static final long[] VALUES = new long[]{7L, 15L, 2L, 150L};
    private static final long[] LONG_VALUES = new long[]{1L, 2L, 3L, 4L};
    private static final float[] FLOAT_VALUES = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
    private static final double[] DOUBLE_VALUES = new double[]{1.0, 2.0, 3.0, 4.0};
    private static final boolean[] NULLS = new boolean[]{false, false, false, false};
    private static final String NAME = "NAME";
    private static final String FIELD_NAME = "FIELD_NAME";
    private static final String FIELD_NAME_LONG = "LONG_NAME";
    private static final String TIME_COL = "__time";
    private final long[] times = new long[]{2345001L, 2345100L, 2345200L, 2345300L};
    private final SerializablePairLongLong[] pairs = new SerializablePairLongLong[]{new SerializablePairLongLong(Long.valueOf(2345001L), Long.valueOf(1L)), new SerializablePairLongLong(Long.valueOf(2345100L), Long.valueOf(2L)), new SerializablePairLongLong(Long.valueOf(2345200L), Long.valueOf(3L)), new SerializablePairLongLong(Long.valueOf(2345300L), Long.valueOf(4L))};
    private VectorObjectSelector selector;
    private BaseLongVectorValueSelector timeSelector;
    private ByteBuffer buf;
    private LongFirstVectorAggregator target;
    private LongFirstAggregatorFactory longFirstAggregatorFactory;
    private VectorColumnSelectorFactory selectorFactory;
    private VectorValueSelector nonLongValueSelector;

    @Before
    public void setup() {
        byte[] randomBytes = new byte[1024];
        ThreadLocalRandom.current().nextBytes(randomBytes);
        this.buf = ByteBuffer.wrap(randomBytes);
        this.timeSelector = new BaseLongVectorValueSelector((ReadableVectorOffset)new NoFilterVectorOffset(this.times.length, 0, this.times.length){}){

            public long[] getLongVector() {
                return LongFirstVectorAggregatorTest.this.times;
            }

            @Nullable
            public boolean[] getNullVector() {
                return null;
            }
        };
        this.selector = new VectorObjectSelector(){

            public Object[] getObjectVector() {
                return LongFirstVectorAggregatorTest.this.pairs;
            }

            public int getMaxVectorSize() {
                return 4;
            }

            public int getCurrentVectorSize() {
                return 0;
            }
        };
        this.nonLongValueSelector = new BaseLongVectorValueSelector((ReadableVectorOffset)new NoFilterVectorOffset(LONG_VALUES.length, 0, LONG_VALUES.length)){

            public long[] getLongVector() {
                return LONG_VALUES;
            }

            public float[] getFloatVector() {
                return FLOAT_VALUES;
            }

            public double[] getDoubleVector() {
                return DOUBLE_VALUES;
            }

            @Nullable
            public boolean[] getNullVector() {
                return null;
            }

            public int getMaxVectorSize() {
                return 4;
            }

            public int getCurrentVectorSize() {
                return 4;
            }
        };
        this.selectorFactory = new VectorColumnSelectorFactory(){

            public ReadableVectorInspector getReadableVectorInspector() {
                return new NoFilterVectorOffset(VALUES.length, 0, VALUES.length);
            }

            public SingleValueDimensionVectorSelector makeSingleValueDimensionSelector(DimensionSpec dimensionSpec) {
                return null;
            }

            public MultiValueDimensionVectorSelector makeMultiValueDimensionSelector(DimensionSpec dimensionSpec) {
                return null;
            }

            public VectorValueSelector makeValueSelector(String column) {
                if (LongFirstVectorAggregatorTest.TIME_COL.equals(column)) {
                    return LongFirstVectorAggregatorTest.this.timeSelector;
                }
                if (LongFirstVectorAggregatorTest.FIELD_NAME_LONG.equals(column) || LongFirstVectorAggregatorTest.FIELD_NAME.equals(column)) {
                    return LongFirstVectorAggregatorTest.this.nonLongValueSelector;
                }
                return null;
            }

            public VectorObjectSelector makeObjectSelector(String column) {
                if (LongFirstVectorAggregatorTest.FIELD_NAME.equals(column)) {
                    return LongFirstVectorAggregatorTest.this.selector;
                }
                return null;
            }

            @Nullable
            public ColumnCapabilities getColumnCapabilities(String column) {
                if (LongFirstVectorAggregatorTest.FIELD_NAME.equals(column)) {
                    return ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.LONG);
                }
                if (LongFirstVectorAggregatorTest.FIELD_NAME_LONG.equals(column)) {
                    return ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.DOUBLE);
                }
                return null;
            }
        };
        this.target = new LongFirstVectorAggregator((VectorValueSelector)this.timeSelector, this.selector);
        this.clearBufferForPositions(0, 0);
        this.longFirstAggregatorFactory = new LongFirstAggregatorFactory(NAME, FIELD_NAME, TIME_COL);
    }

    @Test
    public void testFactory() {
        Assert.assertTrue((boolean)this.longFirstAggregatorFactory.canVectorize((ColumnInspector)this.selectorFactory));
        VectorAggregator vectorAggregator = this.longFirstAggregatorFactory.factorizeVector(this.selectorFactory);
        Assert.assertNotNull((Object)vectorAggregator);
        Assert.assertEquals(LongFirstVectorAggregator.class, vectorAggregator.getClass());
    }

    @Test
    public void testInit() {
        this.target.init(this.buf, 0);
        Assert.assertEquals((long)DateTimes.MAX.getMillis(), (long)this.buf.getLong(0));
        Assert.assertEquals((long)0L, (long)this.buf.getLong(9));
    }

    @Test
    public void testAggregate() {
        this.target.aggregate(this.buf, 0, 0, this.pairs.length);
        Pair result = (Pair)this.target.get(this.buf, 0);
        Assert.assertEquals((long)((Long)this.pairs[0].lhs), (long)((Long)result.lhs));
        Assert.assertEquals((double)((Long)this.pairs[0].rhs).longValue(), (double)((Long)result.rhs).longValue(), (double)1.0E-5);
    }

    @Test
    public void testAggregateWithNulls() {
        this.target.aggregate(this.buf, 0, 0, this.pairs.length);
        Pair result = (Pair)this.target.get(this.buf, 0);
        Assert.assertEquals((long)((Long)this.pairs[0].lhs), (long)((Long)result.lhs));
        Assert.assertEquals((double)((Long)this.pairs[0].rhs).longValue(), (double)((Long)result.rhs).longValue(), (double)1.0E-5);
    }

    @Test
    public void testAggregateBatchWithoutRows() {
        int[] positions = new int[]{0, 43, 70};
        int positionOffset = 2;
        this.clearBufferForPositions(positionOffset, positions);
        this.target.aggregate(this.buf, 3, positions, null, positionOffset);
        for (int i = 0; i < positions.length; ++i) {
            Pair result = (Pair)this.target.get(this.buf, positions[i] + positionOffset);
            Assert.assertEquals((long)((Long)this.pairs[i].getLhs()), (long)((Long)result.lhs));
            if (NULLS[i]) {
                Assert.assertNull((Object)result.rhs);
                continue;
            }
            Assert.assertEquals((double)((Long)this.pairs[i].rhs).longValue(), (double)((Long)result.rhs).longValue(), (double)1.0E-5);
        }
    }

    @Test
    public void testAggregateBatchWithRows() {
        int[] positions = new int[]{0, 43, 70};
        int[] rows = new int[]{3, 2, 0};
        int positionOffset = 2;
        this.clearBufferForPositions(positionOffset, positions);
        this.target.aggregate(this.buf, 3, positions, rows, positionOffset);
        for (int i = 0; i < positions.length; ++i) {
            Pair result = (Pair)this.target.get(this.buf, positions[i] + positionOffset);
            Assert.assertEquals((long)this.times[rows[i]], (long)((Long)result.lhs));
            if (NULLS[rows[i]]) {
                Assert.assertNull((Object)result.rhs);
                continue;
            }
            Assert.assertEquals((double)((Long)this.pairs[rows[i]].rhs).longValue(), (double)((Long)result.rhs).longValue(), (double)1.0E-5);
        }
    }

    private void clearBufferForPositions(int offset, int ... positions) {
        for (int position : positions) {
            this.target.init(this.buf, offset + position);
        }
    }
}

