/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.post;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregator;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FloatSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class FieldAccessPostAggregatorTest
extends InitializedNullHandlingTest {
    private static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testSerde() throws JsonProcessingException {
        FieldAccessPostAggregator postAgg = new FieldAccessPostAggregator("name", "column");
        Assert.assertEquals((Object)postAgg, (Object)JSON_MAPPER.readValue(JSON_MAPPER.writeValueAsString((Object)postAgg), FieldAccessPostAggregator.class));
    }

    @Test
    public void testEqualsAndHashcode() {
        EqualsVerifier.forClass(FieldAccessPostAggregator.class).usingGetClass().withIgnoredFields(new String[]{"type"}).verify();
    }

    @Test
    public void testGetTypeBeforeDecorate() {
        FieldAccessPostAggregator postAgg = new FieldAccessPostAggregator("name", "column");
        RowSignature signature = RowSignature.builder().add("column", ColumnType.LONG).build();
        Assert.assertEquals((Object)ColumnType.LONG, (Object)postAgg.getType((ColumnInspector)signature));
    }

    @Test
    public void testGetTypeBeforeDecorateNil() {
        FieldAccessPostAggregator postAgg = new FieldAccessPostAggregator("name", "column");
        RowSignature signature = RowSignature.builder().build();
        Assert.assertNull((Object)postAgg.getType((ColumnInspector)signature));
    }

    @Test
    public void testCompute() {
        String aggName = "rows";
        FieldAccessPostAggregator fieldAccessPostAggregator = new FieldAccessPostAggregator("To be, or not to be, that is the question:", "rows");
        CountAggregator agg = new CountAggregator();
        HashMap<String, Object> metricValues = new HashMap<String, Object>();
        metricValues.put("rows", agg.get());
        Assert.assertEquals((Object)new Long(0L), (Object)fieldAccessPostAggregator.compute(metricValues));
        agg.aggregate();
        agg.aggregate();
        agg.aggregate();
        metricValues.put("rows", agg.get());
        Assert.assertEquals((Object)new Long(3L), (Object)fieldAccessPostAggregator.compute(metricValues));
    }

    @Test
    public void testResultArraySignature() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count"), new DoubleSumAggregatorFactory("double", "col1"), new FloatSumAggregatorFactory("float", "col2")}).postAggregators(new PostAggregator[]{new FieldAccessPostAggregator("a", "count"), new FieldAccessPostAggregator("b", "double"), new FieldAccessPostAggregator("c", "float")}).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("count", ColumnType.LONG).add("double", ColumnType.DOUBLE).add("float", ColumnType.FLOAT).add("a", ColumnType.LONG).add("b", ColumnType.DOUBLE).add("c", ColumnType.FLOAT).build(), (Object)new TimeseriesQueryQueryToolChest().resultArraySignature(query));
    }
}

