/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter.vector;

import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.druid.query.filter.vector.VectorMatch;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class VectorMatchTest {
    private static final int VECTOR_SIZE = 7;
    private static final int VECTOR_BITS = 128;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testAddAllExhaustive() {
        VectorMatch scratch = VectorMatch.wrap((int[])new int[7]);
        int[] arrayOne = new int[7];
        int[] arrayTwo = new int[7];
        int[] arrayExpected = new int[7];
        for (int bitsOne = 0; bitsOne < 128; ++bitsOne) {
            for (int bitsTwo = 0; bitsTwo < 128; ++bitsTwo) {
                int lenOne = VectorMatchTest.populate(arrayOne, bitsOne);
                int lenTwo = VectorMatchTest.populate(arrayTwo, bitsTwo);
                int lenExpected = VectorMatchTest.populate(arrayExpected, bitsOne | bitsTwo);
                VectorMatch matchOne = VectorMatch.wrap((int[])arrayOne).setSelectionSize(lenOne);
                VectorMatch matchTwo = VectorMatch.wrap((int[])arrayTwo).setSelectionSize(lenTwo);
                VectorMatch matchExpected = VectorMatch.wrap((int[])arrayExpected).setSelectionSize(lenExpected);
                VectorMatchTest.assertMatchEquals(StringUtils.format((String)"%s + %s", (Object[])new Object[]{matchOne, matchTwo}), (ReadableVectorMatch)matchExpected, (ReadableVectorMatch)matchOne.addAll((ReadableVectorMatch)matchTwo, scratch));
            }
        }
    }

    @Test
    public void testAddAllOnSelf() {
        VectorMatch match = VectorMatch.wrap((int[])new int[]{0, 1}).setSelectionSize(2);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("'other' must be a different instance from 'this'");
        match.addAll((ReadableVectorMatch)match, VectorMatch.wrap((int[])new int[2]));
    }

    @Test
    public void testRemoveAllExhaustive() {
        int[] arrayOne = new int[7];
        int[] arrayTwo = new int[7];
        int[] arrayExpected = new int[7];
        for (int bitsOne = 0; bitsOne < 128; ++bitsOne) {
            for (int bitsTwo = 0; bitsTwo < 128; ++bitsTwo) {
                int lenOne = VectorMatchTest.populate(arrayOne, bitsOne);
                int lenTwo = VectorMatchTest.populate(arrayTwo, bitsTwo);
                int lenExpected = VectorMatchTest.populate(arrayExpected, bitsOne & ~bitsTwo);
                VectorMatch matchOne = VectorMatch.wrap((int[])arrayOne).setSelectionSize(lenOne);
                VectorMatch matchTwo = VectorMatch.wrap((int[])arrayTwo).setSelectionSize(lenTwo);
                VectorMatch matchExpected = VectorMatch.wrap((int[])arrayExpected).setSelectionSize(lenExpected);
                VectorMatchTest.assertMatchEquals(StringUtils.format((String)"%s - %s", (Object[])new Object[]{matchOne, matchTwo}), (ReadableVectorMatch)matchExpected, (ReadableVectorMatch)matchOne.removeAll((ReadableVectorMatch)matchTwo));
            }
        }
    }

    @Test
    public void testRemoveAllOnSelf() {
        VectorMatch match = VectorMatch.wrap((int[])new int[]{0, 1}).setSelectionSize(2);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("'other' must be a different instance from 'this'");
        match.removeAll((ReadableVectorMatch)match);
    }

    @Test
    public void testCopyFromExhaustive() {
        VectorMatch target = VectorMatch.wrap((int[])new int[7]);
        int[] array = new int[7];
        int[] arrayTwo = new int[7];
        for (int bits = 0; bits < 128; ++bits) {
            int len = VectorMatchTest.populate(array, bits);
            VectorMatchTest.populate(arrayTwo, bits);
            VectorMatch match = VectorMatch.wrap((int[])array).setSelectionSize(len);
            target.copyFrom((ReadableVectorMatch)match);
            Assert.assertArrayEquals((int[])array, (int[])arrayTwo);
            VectorMatchTest.assertMatchEquals(match.toString(), (ReadableVectorMatch)match, (ReadableVectorMatch)target);
        }
    }

    @Test
    public void testCopyFromOnSelf() {
        VectorMatch match = VectorMatch.wrap((int[])new int[]{0, 1}).setSelectionSize(2);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("'other' must be a different instance from 'this'");
        match.copyFrom((ReadableVectorMatch)match);
    }

    private static void assertMatchEquals(String message, ReadableVectorMatch expected, ReadableVectorMatch actual) {
        Assert.assertEquals((String)message, (Object)expected.toString(), (Object)actual.toString());
    }

    private static int populate(int[] array, int bits) {
        int len = 0;
        for (int bit = 0; bit < 7; ++bit) {
            int mask = 1 << bit;
            if ((bits & mask) != mask) continue;
            array[len++] = bit;
        }
        return len;
    }
}

