/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.groupby.epinephelinae.GroupByTestColumnSelectorFactory;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.IntKey;
import org.apache.druid.query.groupby.epinephelinae.IntKeySerde;
import org.apache.druid.query.groupby.epinephelinae.ReusableEntry;
import org.junit.Assert;

public class GrouperTestUtil {
    private GrouperTestUtil() {
    }

    public static Grouper.KeySerde<IntKey> intKeySerde() {
        return IntKeySerde.INSTANCE;
    }

    public static GroupByTestColumnSelectorFactory newColumnSelectorFactory() {
        return new GroupByTestColumnSelectorFactory();
    }

    public static <T> List<Grouper.Entry<T>> sortedEntries(Iterator<Grouper.Entry<T>> entryIterator, Function<T, T> keyCopyFn, Comparator<T> keyComparator) {
        ArrayList<Grouper.Entry<T>> retVal = new ArrayList<Grouper.Entry<T>>();
        while (entryIterator.hasNext()) {
            Grouper.Entry<T> entry = entryIterator.next();
            Object[] valuesCopy = new Object[entry.getValues().length];
            System.arraycopy(entry.getValues(), 0, valuesCopy, 0, entry.getValues().length);
            ReusableEntry entryCopy = new ReusableEntry(keyCopyFn.apply(entry.getKey()), valuesCopy);
            retVal.add((Grouper.Entry<T>)entryCopy);
        }
        retVal.sort(Comparator.comparing(Grouper.Entry::getKey, keyComparator));
        return retVal;
    }

    public static <T> void assertEntriesEquals(Iterator<Grouper.Entry<T>> expectedEntries, Iterator<Grouper.Entry<T>> actualEntries) {
        int i = 0;
        while (expectedEntries.hasNext() && actualEntries.hasNext()) {
            GrouperTestUtil.assertEntriesEqual(StringUtils.format((String)"entry [%d]", (Object[])new Object[]{i}), expectedEntries.next(), actualEntries.next());
            ++i;
        }
        if (expectedEntries.hasNext()) {
            Assert.fail((String)StringUtils.format((String)"expected additional entry [%,d]", (Object[])new Object[]{i}));
        }
        if (actualEntries.hasNext()) {
            Assert.fail((String)StringUtils.format((String)"encountered too many entries [%,d]", (Object[])new Object[]{i}));
        }
    }

    public static <T> void assertEntriesEqual(Grouper.Entry<T> expectedEntry, Grouper.Entry<T> actualEntry) {
        GrouperTestUtil.assertEntriesEqual(null, expectedEntry, actualEntry);
    }

    public static <T> void assertEntriesEqual(@Nullable String message, Grouper.Entry<T> expectedEntry, Grouper.Entry<T> actualEntry) {
        Assert.assertEquals((String)StringUtils.format((String)"%s: key", (Object[])new Object[]{message}), (Object)expectedEntry.getKey(), (Object)actualEntry.getKey());
        Assert.assertArrayEquals((String)StringUtils.format((String)"%s: values", (Object[])new Object[]{message}), (Object[])expectedEntry.getValues(), (Object[])actualEntry.getValues());
    }
}

