/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.collection;

import it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.util.Random;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.groupby.epinephelinae.collection.HashTableUtils;
import org.junit.Assert;
import org.junit.Test;

public class HashTableUtilsTest {
    @Test
    public void test_previousPowerOfTwo() {
        Int2IntLinkedOpenHashMap expectedResults = new Int2IntLinkedOpenHashMap();
        expectedResults.put(Integer.MIN_VALUE, Integer.MIN_VALUE);
        expectedResults.put(-2147483647, Integer.MIN_VALUE);
        expectedResults.put(-4, Integer.MIN_VALUE);
        expectedResults.put(-3, Integer.MIN_VALUE);
        expectedResults.put(-2, Integer.MIN_VALUE);
        expectedResults.put(-1, Integer.MIN_VALUE);
        expectedResults.put(0, Integer.MIN_VALUE);
        expectedResults.put(1, 1);
        expectedResults.put(2, 2);
        expectedResults.put(3, 2);
        expectedResults.put(4, 4);
        expectedResults.put(5, 4);
        expectedResults.put(6, 4);
        expectedResults.put(7, 4);
        expectedResults.put(8, 8);
        expectedResults.put(0x3FFFFFFF, 0x20000000);
        expectedResults.put(0x40000000, 0x40000000);
        expectedResults.put(0x40000001, 0x40000000);
        expectedResults.put(0x7FFFFFFE, 0x40000000);
        expectedResults.put(Integer.MAX_VALUE, 0x40000000);
        for (Int2IntMap.Entry entry : expectedResults.int2IntEntrySet()) {
            Assert.assertEquals((String)(entry.getIntKey() + " => " + entry.getIntValue()), (long)entry.getIntValue(), (long)HashTableUtils.previousPowerOfTwo((int)entry.getIntKey()));
        }
    }

    private static WritableMemory generateRandomButNotReallyRandomMemory(int length) {
        WritableMemory randomMemory = WritableMemory.allocate((int)length);
        Random random = new Random(0L);
        byte[] randomBytes = new byte[length];
        random.nextBytes(randomBytes);
        randomMemory.putByteArray(0L, randomBytes, 0, length);
        return randomMemory;
    }

    @Test
    public void test_hashMemory_allByteLengthsUpTo128() {
        int maxBytes = 128;
        WritableMemory randomMemory = HashTableUtilsTest.generateRandomButNotReallyRandomMemory(128);
        for (int numBytes = 0; numBytes < 128; ++numBytes) {
            Memory regionToHash = randomMemory.region((long)(128 - numBytes), (long)numBytes);
            Assert.assertEquals((String)StringUtils.format((String)"numBytes[%s] nonzero position check", (Object[])new Object[]{numBytes}), (long)HashTableUtils.hashMemory((Memory)regionToHash, (long)0L, (int)numBytes), (long)HashTableUtils.hashMemory((Memory)randomMemory, (long)(128 - numBytes), (int)numBytes));
            WritableMemory copyOfRegion = WritableMemory.allocate((int)numBytes);
            regionToHash.copyTo(0L, copyOfRegion, 0L, (long)numBytes);
            Assert.assertTrue((String)StringUtils.format((String)"numBytes[%s] copy equality check", (Object[])new Object[]{numBytes}), (boolean)regionToHash.equalTo(0L, (Object)copyOfRegion, 0L, (long)numBytes));
            for (int bit = 0; bit < numBytes * 8; ++bit) {
                int bytePosition = bit / 8;
                byte mask = (byte)(1 << bit % 8);
                copyOfRegion.putByte((long)bytePosition, (byte)(copyOfRegion.getByte((long)bytePosition) ^ mask));
                Assert.assertNotEquals((String)StringUtils.format((String)"numBytes[%s] bit[%s] flip check", (Object[])new Object[]{numBytes, bit}), (long)HashTableUtils.hashMemory((Memory)regionToHash, (long)0L, (int)numBytes), (long)HashTableUtils.hashMemory((Memory)copyOfRegion, (long)0L, (int)numBytes));
                copyOfRegion.putByte((long)bytePosition, (byte)(copyOfRegion.getByte((long)bytePosition) ^ mask));
                Assert.assertTrue((String)StringUtils.format((String)"numBytes[%s] bit[%s] reset check", (Object[])new Object[]{numBytes, bit}), (boolean)regionToHash.equalTo(0L, (Object)copyOfRegion, 0L, (long)numBytes));
            }
        }
    }

    @Test
    public void test_memoryEquals_allByteLengthsUpTo128() {
        int maxBytes = 128;
        WritableMemory randomMemory = HashTableUtilsTest.generateRandomButNotReallyRandomMemory(128);
        for (int numBytes = 0; numBytes < 128; ++numBytes) {
            WritableMemory copyOfRegion = WritableMemory.allocate((int)numBytes);
            randomMemory.copyTo((long)(128 - numBytes), copyOfRegion, 0L, (long)numBytes);
            Assert.assertTrue((String)StringUtils.format((String)"numBytes[%s] nonzero position check", (Object[])new Object[]{numBytes}), (boolean)HashTableUtils.memoryEquals((Memory)randomMemory, (long)(128 - numBytes), (Memory)copyOfRegion, (long)0L, (int)numBytes));
            for (int bit = 0; bit < numBytes * 8; ++bit) {
                int bytePosition = bit / 8;
                byte mask = (byte)(1 << bit % 8);
                copyOfRegion.putByte((long)bytePosition, (byte)(copyOfRegion.getByte((long)bytePosition) ^ mask));
                Assert.assertFalse((String)StringUtils.format((String)"numBytes[%s] bit[%s] flip check", (Object[])new Object[]{numBytes, bit}), (boolean)HashTableUtils.memoryEquals((Memory)randomMemory, (long)(128 - numBytes), (Memory)copyOfRegion, (long)0L, (int)numBytes));
                copyOfRegion.putByte((long)bytePosition, (byte)(copyOfRegion.getByte((long)bytePosition) ^ mask));
                Assert.assertTrue((String)StringUtils.format((String)"numBytes[%s] bit[%s] reset check", (Object[])new Object[]{numBytes, bit}), (boolean)HashTableUtils.memoryEquals((Memory)randomMemory, (long)(128 - numBytes), (Memory)copyOfRegion, (long)0L, (int)numBytes));
            }
        }
    }
}

