/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.vector;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.query.groupby.epinephelinae.VectorGrouper;
import org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnProcessorFactory;
import org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnSelector;
import org.apache.druid.query.groupby.epinephelinae.vector.VectorGroupByEngine;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.QueryableIndexTimeBoundaryInspector;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.segment.VectorColumnProcessorFactory;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorCursor;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.Interval;
import org.junit.Test;
import org.mockito.Mockito;

public class VectorGroupByEngineIteratorTest
extends InitializedNullHandlingTest {
    @Test
    public void testCreateOneGrouperAndCloseItWhenClose() throws IOException {
        Interval interval = TestIndex.DATA_INTERVAL;
        DoubleSumAggregatorFactory factory = new DoubleSumAggregatorFactory("index", "index");
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.DAY_GRAN).setInterval(interval).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", null, null)}).setAggregatorSpecs(new AggregatorFactory[]{factory}).build();
        QueryableIndexCursorFactory cursorFactory = new QueryableIndexCursorFactory(TestIndex.getMMappedTestIndex());
        QueryableIndexTimeBoundaryInspector timeBoundaryInspector = QueryableIndexTimeBoundaryInspector.create((QueryableIndex)TestIndex.getMMappedTestIndex());
        CursorHolder cursorHolder = cursorFactory.makeCursorHolder(GroupingEngine.makeCursorBuildSpec((GroupByQuery)query, null));
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[4096]);
        VectorCursor cursor = cursorHolder.asVectorCursor();
        List dimensions = query.getDimensions().stream().map(dimensionSpec -> (GroupByVectorColumnSelector)ColumnProcessors.makeVectorProcessor((DimensionSpec)dimensionSpec, (VectorColumnProcessorFactory)GroupByVectorColumnProcessorFactory.instance(), (VectorColumnSelectorFactory)cursor.getColumnSelectorFactory())).collect(Collectors.toList());
        final MutableObject grouperCaptor = new MutableObject();
        VectorGroupByEngine.VectorGroupByEngineIterator iterator = new VectorGroupByEngine.VectorGroupByEngineIterator(query, new GroupByQueryConfig(), GroupByQueryRunnerTest.DEFAULT_PROCESSING_CONFIG, (TimeBoundaryInspector)timeBoundaryInspector, cursor, cursorHolder.getTimeOrder(), interval, dimensions, byteBuffer, null){

            VectorGrouper makeGrouper() {
                grouperCaptor.setValue((Object)((VectorGrouper)Mockito.spy((Object)super.makeGrouper())));
                return (VectorGrouper)grouperCaptor.getValue();
            }
        };
        iterator.close();
        ((VectorGrouper)Mockito.verify((Object)((VectorGrouper)grouperCaptor.getValue()))).close();
        cursorHolder.close();
    }
}

