/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.druid.segment.AggregateProjectionMetadata;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.junit.Assert;
import org.junit.Test;

public class SegmentAnalysisTest {
    @Test
    public void testEquals() {
        EqualsVerifier.forClass(SegmentAnalysis.class).usingGetClass().verify();
    }

    @Test
    public void testSerde() throws Exception {
        LinkedHashMap<String, ColumnAnalysis> columns = new LinkedHashMap<String, ColumnAnalysis>();
        columns.put("b", new ColumnAnalysis(ColumnType.LONG, ColumnType.LONG.asTypeString(), true, true, 0L, null, null, null, null));
        columns.put("a", new ColumnAnalysis(ColumnType.FLOAT, ColumnType.FLOAT.asTypeString(), true, true, 0L, null, null, null, null));
        columns.put("f", new ColumnAnalysis(ColumnType.STRING, ColumnType.STRING.asTypeString(), true, true, 0L, null, null, null, null));
        columns.put("c", new ColumnAnalysis(ColumnType.DOUBLE, ColumnType.DOUBLE.asTypeString(), true, true, 0L, null, null, null, null));
        SegmentAnalysis analysis = new SegmentAnalysis("id", (List)Intervals.ONLY_ETERNITY, columns, 1L, 2L, (Map)ImmutableMap.of((Object)"cnt", (Object)new CountAggregatorFactory("cnt")), (Map)ImmutableMap.of((Object)"channel_added_hourly", (Object)new AggregateProjectionMetadata(AggregateProjectionMetadata.schemaBuilder((String)"channel_added_hourly").timeColumnName("__virtualGranularity").virtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__virtualGranularity")}).groupAndOrder(new String[]{"__virtualGranularity", "channel"}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum_added", "added")}).build(), 16)), new TimestampSpec(null, null, null), Granularities.SECOND, Boolean.valueOf(true));
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        SegmentAnalysis analysis2 = (SegmentAnalysis)jsonMapper.readValue(jsonMapper.writeValueAsBytes((Object)analysis), SegmentAnalysis.class);
        Assert.assertEquals((Object)analysis, (Object)analysis2);
        Assert.assertEquals((Object)ImmutableList.copyOf(columns.entrySet()), (Object)ImmutableList.copyOf(analysis2.getColumns().entrySet()));
    }
}

