/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.rowsandcols.RowsAndColumns;

public class InlineScanOperator
implements Operator {
    private Iterable<RowsAndColumns> iterable;

    public static InlineScanOperator make(RowsAndColumns ... item) {
        return new InlineScanOperator(Arrays.asList(item));
    }

    public static InlineScanOperator make(List<RowsAndColumns> items) {
        return new InlineScanOperator(items);
    }

    public InlineScanOperator(Iterable<RowsAndColumns> iterable) {
        Preconditions.checkNotNull(iterable);
        this.iterable = iterable;
    }

    public Closeable goOrContinue(Closeable continuation, Operator.Receiver receiver) {
        Iterator<RowsAndColumns> iter = continuation == null ? this.iterable.iterator() : ((Continuation)continuation).iter;
        Operator.Signal keepItGoing = Operator.Signal.GO;
        while (keepItGoing == Operator.Signal.GO && iter.hasNext()) {
            keepItGoing = receiver.push(iter.next());
        }
        if (keepItGoing == Operator.Signal.PAUSE && iter.hasNext()) {
            return new Continuation(iter);
        }
        receiver.completed();
        return null;
    }

    private static class Continuation
    implements Closeable {
        private final Iterator<RowsAndColumns> iter;

        public Continuation(Iterator<RowsAndColumns> iter) {
            this.iter = iter;
        }

        @Override
        public void close() {
        }
    }
}

