/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.operator.NaivePartitioningOperatorFactory;
import org.apache.druid.query.operator.WindowOperatorQuery;
import org.apache.druid.query.spec.LegacySegmentSpec;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.column.RowSignature;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WindowOperatorQueryTest {
    WindowOperatorQuery query;

    @Before
    public void setUp() {
        this.query = new WindowOperatorQuery((DataSource)InlineDataSource.fromIterable(new ArrayList(), (RowSignature)RowSignature.empty()), (QuerySegmentSpec)new LegacySegmentSpec((Object)Intervals.ETERNITY), (Map)ImmutableMap.of((Object)"sally", (Object)"sue"), RowSignature.empty(), new ArrayList(), null);
    }

    @Test
    public void getOperators() {
        Assert.assertTrue((boolean)this.query.getOperators().isEmpty());
    }

    @Test
    public void getRowSignature() {
        Assert.assertEquals((long)0L, (long)this.query.getRowSignature().size());
    }

    @Test
    public void hasFilters() {
        Assert.assertFalse((boolean)this.query.hasFilters());
    }

    @Test
    public void getFilter() {
        Assert.assertNull((Object)this.query.getFilter());
    }

    @Test
    public void getType() {
        Assert.assertEquals((Object)"windowOperator", (Object)this.query.getType());
    }

    @Test
    public void withOverriddenContext() {
        Assert.assertEquals((Object)"sue", (Object)this.query.context().get("sally"));
        QueryContext context = this.query.withOverriddenContext((Map)ImmutableMap.of((Object)"sally", (Object)"soo")).context();
        Assert.assertEquals((Object)"soo", (Object)context.get("sally"));
    }

    @Test
    public void withDataSource() {
        Set tableNames = this.query.getDataSource().getTableNames();
        Assert.assertEquals((long)0L, (long)tableNames.size());
        TableDataSource newDs = new TableDataSource("bob");
        Assert.assertSame((Object)newDs, (Object)this.query.withDataSource((DataSource)newDs).getDataSource());
    }

    @Test
    public void withQuerySpec() {
        MultipleIntervalSegmentSpec spec = new MultipleIntervalSegmentSpec(Collections.emptyList());
        Assert.assertSame((Object)spec, (Object)((WindowOperatorQuery)this.query.withQuerySegmentSpec((QuerySegmentSpec)spec)).getQuerySegmentSpec());
    }

    @Test
    public void withOperators() {
        ImmutableList operators = ImmutableList.builder().add((Object)new NaivePartitioningOperatorFactory(Collections.singletonList("some"))).build();
        Assert.assertSame((Object)operators, (Object)((WindowOperatorQuery)this.query.withOperators((List)operators)).getOperators());
    }

    @Test
    public void testEquals() {
        EqualsVerifier.simple().forClass(WindowOperatorQuery.class).withNonnullFields(new String[]{"duration", "querySegmentSpec"}).usingGetClass().verify();
        Assert.assertNotEquals((Object)this.query, (Object)this.query.toString());
    }
}

