/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.query.operator.window.WindowFrame;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WindowFrameTest {
    @Test
    public void testEqualsRows() {
        EqualsVerifier.forClass(WindowFrame.Rows.class).usingGetClass().verify();
    }

    @Test
    public void testEqualsGroups() {
        EqualsVerifier.forClass(WindowFrame.Groups.class).usingGetClass().verify();
    }

    @Test
    public void testOffsetFrameUnbounded() {
        WindowFrame.Rows of = new WindowFrame.Rows(null, null);
        Assertions.assertEquals((int)-100, (int)of.getLowerOffsetClamped(100));
        Assertions.assertEquals((int)100, (int)of.getUpperOffsetClamped(100));
    }

    @Test
    public void testOffsetFrameNormal() {
        WindowFrame.Rows of = new WindowFrame.Rows(Integer.valueOf(-1), Integer.valueOf(2));
        Assertions.assertEquals((int)-1, (int)of.getLowerOffsetClamped(100));
        Assertions.assertEquals((int)2, (int)of.getUpperOffsetClamped(100));
    }

    @Test
    public void testOffsetFrameUnbounded2() {
        WindowFrame.Rows of = new WindowFrame.Rows(Integer.valueOf(-200), Integer.valueOf(200));
        Assertions.assertEquals((int)-100, (int)of.getLowerOffsetClamped(100));
        Assertions.assertEquals((int)100, (int)of.getUpperOffsetClamped(100));
    }
}

