/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import org.apache.druid.query.rowsandcols.ConcatRowsAndColumns;
import org.apache.druid.query.rowsandcols.LimitedRowsAndColumns;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumnsTestBase;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.junit.Assert;
import org.junit.Test;

public class ConcatRowsAndColumnsTest
extends RowsAndColumnsTestBase {
    public static Function<MapOfColumnsRowsAndColumns, ConcatRowsAndColumns> MAKER = input -> {
        int rowsPerChunk = Math.max(1, input.numRows() / 4);
        ArrayList<LimitedRowsAndColumns> theRac = new ArrayList<LimitedRowsAndColumns>();
        for (int startId = 0; startId < input.numRows(); startId += rowsPerChunk) {
            theRac.add(new LimitedRowsAndColumns((RowsAndColumns)input, startId, Math.min(input.numRows(), startId + rowsPerChunk)));
        }
        return new ConcatRowsAndColumns(theRac);
    };

    public ConcatRowsAndColumnsTest() {
        super(ConcatRowsAndColumns.class);
    }

    @Test
    public void testConstructorWithNullRacBuffer() {
        NullPointerException e = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> new ConcatRowsAndColumns(null));
        Assert.assertEquals((Object)"racBuffer cannot be null", (Object)e.getMessage());
    }

    @Test
    public void testFindColumn() {
        MapOfColumnsRowsAndColumns rac = MapOfColumnsRowsAndColumns.fromMap((Map)ImmutableMap.of((Object)"column1", (Object)new IntArrayColumn(new int[]{1, 2, 3, 4, 5, 6}), (Object)"column2", (Object)new IntArrayColumn(new int[]{6, 5, 4, 3, 2, 1})));
        ConcatRowsAndColumns apply = MAKER.apply(rac);
        Assert.assertEquals((long)1L, (long)apply.findColumn("column1").toAccessor().getInt(0));
        Assert.assertEquals((long)6L, (long)apply.findColumn("column2").toAccessor().getInt(0));
    }

    @Test
    public void testFindColumnWithEmptyRacBuffer() {
        ConcatRowsAndColumns concatRowsAndColumns = new ConcatRowsAndColumns(new ArrayList());
        Assert.assertNull((Object)concatRowsAndColumns.findColumn("columnName"));
    }

    @Test
    public void testGetColumns() {
        MapOfColumnsRowsAndColumns rac = MapOfColumnsRowsAndColumns.fromMap((Map)ImmutableMap.of((Object)"column1", (Object)new IntArrayColumn(new int[]{0, 0, 0, 1, 1, 2, 4, 4, 4}), (Object)"column2", (Object)new IntArrayColumn(new int[]{3, 54, 21, 1, 5, 54, 2, 3, 92})));
        ConcatRowsAndColumns apply = MAKER.apply(rac);
        Assert.assertEquals(Arrays.asList("column1", "column2"), new ArrayList(apply.getColumnNames()));
    }

    @Test
    public void testGetColumnsWithEmptyRacBuffer() {
        ConcatRowsAndColumns concatRowsAndColumns = new ConcatRowsAndColumns(new ArrayList());
        Assert.assertTrue((boolean)concatRowsAndColumns.getColumnNames().isEmpty());
    }
}

