/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.column;

import org.apache.druid.query.rowsandcols.column.BinarySearchableAccessor;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.column.LongArrayColumn;
import org.apache.druid.query.rowsandcols.util.FindResult;
import org.junit.Assert;
import org.junit.Test;

public class LongArrayColumnTest {
    @Test
    public void testLongArrayColumnWithLongValues() {
        LongArrayColumn column = new LongArrayColumn(new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L});
        ColumnAccessor accessor = column.toAccessor();
        for (int i = 0; i < 10; ++i) {
            Assert.assertFalse((boolean)accessor.isNull(i));
            Assert.assertEquals((long)i, (long)accessor.getLong(i));
            Assert.assertEquals((Object)i, (Object)accessor.getObject(i));
            Assert.assertEquals((double)i, (double)accessor.getDouble(i), (double)0.0);
            Assert.assertEquals((long)i, (long)accessor.getInt(i));
        }
    }

    @Test
    public void testFindLong() {
        LongArrayColumn column = new LongArrayColumn(new long[]{1L, 1L, 1L, 3L, 5L, 5L, 6L, 7L, 8L, 9L});
        BinarySearchableAccessor accessor = (BinarySearchableAccessor)column.toAccessor();
        FindResult findResult = accessor.findLong(0, accessor.numRows(), 1L);
        Assert.assertTrue((boolean)findResult.wasFound());
        Assert.assertEquals((long)0L, (long)findResult.getStartRow());
        Assert.assertEquals((long)3L, (long)findResult.getEndRow());
        findResult = accessor.findLong(0, accessor.numRows(), 6L);
        Assert.assertTrue((boolean)findResult.wasFound());
        Assert.assertEquals((long)6L, (long)findResult.getStartRow());
        Assert.assertEquals((long)7L, (long)findResult.getEndRow());
        Assert.assertFalse((boolean)accessor.findLong(0, accessor.numRows(), 2L).wasFound());
        Assert.assertFalse((boolean)accessor.findLong(0, 3, 9L).wasFound());
    }

    @Test
    public void testOtherTypeFinds() {
        LongArrayColumn column = new LongArrayColumn(new long[]{0L, 1L, 2L, 3L, 4L, 5L, Long.MAX_VALUE});
        BinarySearchableAccessor accessor = (BinarySearchableAccessor)column.toAccessor();
        FindResult findResult = accessor.findNull(0, accessor.numRows());
        Assert.assertFalse((boolean)findResult.wasFound());
        findResult = accessor.findDouble(0, accessor.numRows(), 3.0);
        Assert.assertTrue((boolean)findResult.wasFound());
        Assert.assertEquals((long)3L, (long)findResult.getStartRow());
        Assert.assertEquals((long)4L, (long)findResult.getEndRow());
        findResult = accessor.findFloat(0, accessor.numRows(), 1.0f);
        Assert.assertTrue((boolean)findResult.wasFound());
        Assert.assertEquals((long)1L, (long)findResult.getStartRow());
        Assert.assertEquals((long)2L, (long)findResult.getEndRow());
    }
}

