/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.concrete;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.ArenaMemoryAllocatorFactory;
import org.apache.druid.frame.allocation.MemoryAllocatorFactory;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriters;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumnsTestBase;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.concrete.RowBasedFrameRowsAndColumns;
import org.apache.druid.query.rowsandcols.semantic.ColumnSelectorFactoryMaker;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.RowSignature;

public class RowBasedFrameRowsAndColumnsTest
extends RowsAndColumnsTestBase {
    public static Function<MapOfColumnsRowsAndColumns, RowBasedFrameRowsAndColumns> MAKER = RowBasedFrameRowsAndColumnsTest::buildFrame;

    public RowBasedFrameRowsAndColumnsTest() {
        super(RowBasedFrameRowsAndColumns.class);
    }

    private static RowBasedFrameRowsAndColumns buildFrame(MapOfColumnsRowsAndColumns rac) {
        AtomicInteger rowId = new AtomicInteger(0);
        int numRows = rac.numRows();
        ColumnSelectorFactoryMaker csfm = ColumnSelectorFactoryMaker.fromRAC((RowsAndColumns)rac);
        ColumnSelectorFactory selectorFactory = csfm.make(rowId);
        RowSignature.Builder sigBob = RowSignature.builder();
        ArenaMemoryAllocatorFactory memFactory = new ArenaMemoryAllocatorFactory(0xC800000);
        for (String column : rac.getColumnNames()) {
            Column racColumn = rac.findColumn(column);
            if (racColumn == null) continue;
            sigBob.add(column, racColumn.toAccessor().getType());
        }
        RowSignature signature = sigBob.build();
        FrameWriter frameWriter = FrameWriters.makeFrameWriterFactory((FrameType)FrameType.latestRowBased(), (MemoryAllocatorFactory)memFactory, (RowSignature)signature, Collections.emptyList(), (boolean)false).newFrameWriter(selectorFactory);
        rowId.set(0);
        while (rowId.get() < numRows) {
            frameWriter.addSelection();
            rowId.incrementAndGet();
        }
        return new RowBasedFrameRowsAndColumns(Frame.wrap((byte[])frameWriter.toByteArray()), signature);
    }
}

