/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.union;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.DefaultQueryRunnerFactoryConglomerate;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChestTestHelper;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanQueryQueryToolChest;
import org.apache.druid.query.scan.ScanQueryQueryToolChestTest;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.union.UnionQuery;
import org.apache.druid.query.union.UnionQueryLogic;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class UnionQueryQueryToolChestTest {
    final UnionQueryLogic queryLogic = new UnionQueryLogic();
    private ScanQueryQueryToolChest scanToolChest = ScanQueryQueryToolChestTest.makeTestScanQueryToolChest();

    public UnionQueryQueryToolChestTest() {
        DefaultQueryRunnerFactoryConglomerate conglomerate = new DefaultQueryRunnerFactoryConglomerate(Collections.emptyMap(), (Map)ImmutableMap.builder().put(ScanQuery.class, (Object)this.scanToolChest).build(), Collections.emptyMap());
        this.queryLogic.initialize((QueryRunnerFactoryConglomerate)conglomerate);
    }

    @Test
    public void testResultArraySignatureWithTimestampResultField() {
        RowSignature sig = RowSignature.builder().add("a", ColumnType.STRING).add("b", ColumnType.STRING).build();
        TestScanQuery scan1 = new TestScanQuery("foo", sig).appendRow("a", "a").appendRow("a", "b");
        TestScanQuery scan2 = new TestScanQuery("bar", sig).appendRow("x", "x").appendRow("x", "y");
        ImmutableList queries = ImmutableList.of((Object)scan1.query, (Object)scan2.query);
        UnionQuery query = new UnionQuery((List)queries);
        Assert.assertEquals((Object)sig, (Object)query.getResultRowSignature());
    }

    @Test
    void testQueryRunner() {
        RowSignature sig = RowSignature.builder().add("a", ColumnType.STRING).add("b", ColumnType.STRING).build();
        TestScanQuery scan1 = new TestScanQuery("foo", sig).appendRow("a", "a").appendRow("a", "b");
        TestScanQuery scan2 = new TestScanQuery("bar", sig).appendRow("x", "x").appendRow("x", "y");
        UnionQuery query = new UnionQuery((List)ImmutableList.of((Object)scan1.query, (Object)scan2.query));
        query = (UnionQuery)UnionQueryQueryToolChestTest.serializedAsRows(query);
        QuerySegmentWalker walker = (QuerySegmentWalker)Mockito.mock(QuerySegmentWalker.class);
        Mockito.when((Object)walker.getQueryRunnerForIntervals((Query)ArgumentMatchers.argThat(x$0 -> scan1.matchQuery((ScanQuery)x$0)), (Iterable)ArgumentMatchers.any())).thenReturn((q, ctx) -> scan1.makeResultSequence());
        Mockito.when((Object)walker.getQueryRunnerForIntervals((Query)ArgumentMatchers.argThat(x$0 -> scan2.matchQuery((ScanQuery)x$0)), (Iterable)ArgumentMatchers.any())).thenReturn((q, ctx) -> scan2.makeResultSequence());
        QueryRunner unionRunner = this.queryLogic.entryPoint((Query)query, walker);
        Sequence results = unionRunner.run(QueryPlus.wrap((Query)query), null);
        QueryToolChestTestHelper.assertArrayResultsEquals(Sequences.concat((Sequence[])new Sequence[]{scan1.makeResultsAsArrays(), scan2.makeResultsAsArrays()}).toList(), (Sequence<Object[]>)results);
    }

    private static Query<?> serializedAsRows(Query<?> query) {
        return query.withOverriddenContext((Map)ImmutableMap.of((Object)"serialization", (Object)"rows"));
    }

    static class TestScanQuery {
        final ScanQuery query;
        final List<Object[]> results = new ArrayList<Object[]>();

        public TestScanQuery(String sourceName, RowSignature signature) {
            this.query = Druids.newScanQueryBuilder().dataSource(sourceName).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2000/3000")))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).columns(signature.getColumnNames()).columnTypes(signature.getColumnTypes()).build();
        }

        public TestScanQuery appendRow(Object ... row) {
            this.results.add(row);
            return this;
        }

        public Sequence<ScanResultValue> makeResultSequence() {
            ScanResultValue result = new ScanResultValue(QueryRunnerTestHelper.SEGMENT_ID.toString(), this.query.getColumns(), this.convertResultsToListOfLists());
            return Sequences.of((Object[])new ScanResultValue[]{result});
        }

        private List<List<Object>> convertResultsToListOfLists() {
            ArrayList<List<Object>> resultsRows = new ArrayList<List<Object>>();
            for (Object[] objects : this.results) {
                resultsRows.add(Arrays.asList(objects));
            }
            return resultsRows;
        }

        private boolean matchQuery(ScanQuery query) {
            return query != null && UnionQueryQueryToolChestTest.serializedAsRows(this.query).equals(UnionQueryQueryToolChestTest.serializedAsRows(query));
        }

        public Sequence<Object[]> makeResultsAsArrays() {
            ScanQueryQueryToolChest scanToolChest = ScanQueryQueryToolChestTest.makeTestScanQueryToolChest();
            return scanToolChest.resultsAsArrays(this.query, this.makeResultSequence());
        }
    }
}

