/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.DefaultBitmapResultFactory;
import org.apache.druid.segment.ColumnCache;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.BaseColumnHolder;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.StringUtf8DictionaryEncodedColumn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.semantic.DictionaryEncodedStringValueIndex;
import org.apache.druid.segment.index.semantic.StringValueSetIndexes;
import org.apache.druid.segment.serde.NoIndexesColumnIndexSupplier;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ColumnCacheTest {
    private static final String STRING_DICTIONARY_COLUMN_NAME = "string";
    private static final String NON_STRING_DICTIONARY_COLUMN_NAME = "not-string";
    private static final String NONEXISTENT_COLUMN_NAME = "nonexistent";
    BitmapFactory bitmapFactory;
    VirtualColumns virtualColumns;
    QueryableIndex index;
    Closer closer;
    ColumnCache columnCache;
    ColumnIndexSupplier indexSupplier;

    @Before
    public void setup() {
        this.closer = Closer.create();
        this.bitmapFactory = (BitmapFactory)EasyMock.createMock(BitmapFactory.class);
        this.virtualColumns = VirtualColumns.EMPTY;
        this.index = (QueryableIndex)EasyMock.createMock(QueryableIndex.class);
        this.columnCache = new ColumnCache(this.index, this.virtualColumns, this.closer);
        this.indexSupplier = (ColumnIndexSupplier)EasyMock.createMock(ColumnIndexSupplier.class);
        EasyMock.expect((Object)this.index.getBitmapFactoryForDimensions()).andReturn((Object)this.bitmapFactory).anyTimes();
        EasyMock.expect((Object)this.index.getColumnHolder(NONEXISTENT_COLUMN_NAME)).andReturn(null).anyTimes();
        BaseColumnHolder holder = (BaseColumnHolder)EasyMock.createMock(BaseColumnHolder.class);
        EasyMock.expect((Object)this.index.getColumnHolder(STRING_DICTIONARY_COLUMN_NAME)).andReturn((Object)holder).anyTimes();
        StringUtf8DictionaryEncodedColumn stringColumn = (StringUtf8DictionaryEncodedColumn)EasyMock.createMock(StringUtf8DictionaryEncodedColumn.class);
        EasyMock.expect((Object)holder.getCapabilities()).andReturn((Object)ColumnCapabilitiesImpl.createDefault().setType(ColumnType.STRING).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setDictionaryValuesSorted(true).setHasBitmapIndexes(true)).anyTimes();
        EasyMock.expect((Object)holder.getColumn()).andReturn((Object)stringColumn).anyTimes();
        EasyMock.expect((Object)holder.getIndexSupplier()).andReturn((Object)this.indexSupplier).anyTimes();
        StringValueSetIndexes someIndex = (StringValueSetIndexes)EasyMock.createMock(StringValueSetIndexes.class);
        EasyMock.expect((Object)((StringValueSetIndexes)this.indexSupplier.as(StringValueSetIndexes.class))).andReturn((Object)someIndex).anyTimes();
        DictionaryEncodedStringValueIndex valueIndex = (DictionaryEncodedStringValueIndex)EasyMock.createMock(DictionaryEncodedStringValueIndex.class);
        EasyMock.expect((Object)((DictionaryEncodedStringValueIndex)this.indexSupplier.as(DictionaryEncodedStringValueIndex.class))).andReturn((Object)valueIndex).anyTimes();
        BitmapColumnIndex columnIndex = (BitmapColumnIndex)EasyMock.createMock(BitmapColumnIndex.class);
        ImmutableBitmap someBitmap = (ImmutableBitmap)EasyMock.createMock(ImmutableBitmap.class);
        EasyMock.expect((Object)valueIndex.getBitmap(0)).andReturn((Object)someBitmap).anyTimes();
        EasyMock.expect((Object)someIndex.forValue("foo")).andReturn((Object)columnIndex).anyTimes();
        EasyMock.expect((Object)columnIndex.computeBitmapResult((BitmapResultFactory)EasyMock.anyObject(), EasyMock.eq((boolean)false))).andReturn((Object)someBitmap).anyTimes();
        BaseColumnHolder nonStringHolder = (BaseColumnHolder)EasyMock.createMock(BaseColumnHolder.class);
        EasyMock.expect((Object)this.index.getColumnHolder(NON_STRING_DICTIONARY_COLUMN_NAME)).andReturn((Object)nonStringHolder).anyTimes();
        EasyMock.expect((Object)nonStringHolder.getIndexSupplier()).andReturn((Object)new NoIndexesColumnIndexSupplier()).anyTimes();
        EasyMock.expect((Object)nonStringHolder.getCapabilities()).andReturn((Object)ColumnCapabilitiesImpl.createDefault().setType(ColumnType.ofComplex((String)"testBlob")).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setDictionaryValuesSorted(true).setHasBitmapIndexes(true)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.bitmapFactory, this.index, this.indexSupplier, holder, stringColumn, nonStringHolder, someIndex, columnIndex, valueIndex, someBitmap});
    }

    @After
    public void tearDown() throws Exception {
        this.closer.close();
    }

    @Test
    public void testStringDictionaryUseIndex() {
        ColumnIndexSupplier supplier = this.columnCache.getIndexSupplier(STRING_DICTIONARY_COLUMN_NAME);
        DictionaryEncodedStringValueIndex bitmapIndex = (DictionaryEncodedStringValueIndex)supplier.as(DictionaryEncodedStringValueIndex.class);
        Assert.assertNotNull((Object)bitmapIndex);
        StringValueSetIndexes valueIndex = (StringValueSetIndexes)supplier.as(StringValueSetIndexes.class);
        Assert.assertNotNull((Object)valueIndex);
        ImmutableBitmap valueBitmap = (ImmutableBitmap)valueIndex.forValue("foo").computeBitmapResult((BitmapResultFactory)new DefaultBitmapResultFactory(this.columnCache.getBitmapFactory()), false);
        Assert.assertNotNull((Object)valueBitmap);
        EasyMock.verify((Object[])new Object[]{this.bitmapFactory, this.index, this.indexSupplier});
    }

    @Test
    public void testNonStringDictionaryDoNotUseIndex() {
        ColumnIndexSupplier supplier = this.columnCache.getIndexSupplier(NON_STRING_DICTIONARY_COLUMN_NAME);
        DictionaryEncodedStringValueIndex bitmapIndex = (DictionaryEncodedStringValueIndex)supplier.as(DictionaryEncodedStringValueIndex.class);
        Assert.assertNull((Object)bitmapIndex);
        StringValueSetIndexes valueIndex = (StringValueSetIndexes)supplier.as(StringValueSetIndexes.class);
        Assert.assertNull((Object)valueIndex);
        EasyMock.verify((Object[])new Object[]{this.bitmapFactory, this.index, this.indexSupplier});
    }

    @Test
    public void testStringDictionaryGetColumnCapabilities() {
        ColumnCapabilities capabilities = this.columnCache.getColumnCapabilities(STRING_DICTIONARY_COLUMN_NAME);
        Assert.assertEquals((Object)ValueType.STRING, (Object)capabilities.getType());
        Assert.assertEquals((Object)ColumnCapabilities.Capable.FALSE, (Object)capabilities.hasMultipleValues());
        Assert.assertEquals((Object)ColumnCapabilities.Capable.TRUE, (Object)capabilities.isDictionaryEncoded());
    }

    @Test
    public void testNonStringDictionaryGetColumnCapabilities() {
        ColumnCapabilities capabilities = this.columnCache.getColumnCapabilities(NON_STRING_DICTIONARY_COLUMN_NAME);
        Assert.assertEquals((Object)ValueType.COMPLEX, (Object)capabilities.getType());
        Assert.assertEquals((Object)"testBlob", (Object)capabilities.getComplexTypeName());
        Assert.assertEquals((Object)ColumnCapabilities.Capable.FALSE, (Object)capabilities.hasMultipleValues());
        Assert.assertEquals((Object)ColumnCapabilities.Capable.TRUE, (Object)capabilities.isDictionaryEncoded());
    }

    @Test
    public void testNonexistentColumnGetColumnCapabilities() {
        ColumnCapabilities capabilities = this.columnCache.getColumnCapabilities(NONEXISTENT_COLUMN_NAME);
        Assert.assertNull((Object)capabilities);
    }
}

