/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.StringFormatExtractionFn;
import org.apache.druid.query.extraction.SubstringDimExtractionFn;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.DruidPredicateMatch;
import org.apache.druid.query.filter.StringPredicateDruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class ConstantDimensionSelectorTest
extends InitializedNullHandlingTest {
    private final DimensionSelector NULL_SELECTOR = DimensionSelector.constant(null);
    private final DimensionSelector CONST_SELECTOR = DimensionSelector.constant((String)"billy");
    private final DimensionSelector NULL_EXTRACTION_SELECTOR = DimensionSelector.constant(null, (ExtractionFn)new StringFormatExtractionFn("billy"));
    private final DimensionSelector CONST_EXTRACTION_SELECTOR = DimensionSelector.constant((String)"billybilly", (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(5)));

    @Test
    public void testGetRow() {
        IndexedInts row = this.NULL_SELECTOR.getRow();
        Assert.assertEquals((long)1L, (long)row.size());
        Assert.assertEquals((long)0L, (long)row.get(0));
    }

    @Test
    public void testGetValueCardinality() {
        Assert.assertEquals((long)1L, (long)this.NULL_SELECTOR.getValueCardinality());
        Assert.assertEquals((long)1L, (long)this.CONST_SELECTOR.getValueCardinality());
        Assert.assertEquals((long)1L, (long)this.NULL_EXTRACTION_SELECTOR.getValueCardinality());
        Assert.assertEquals((long)1L, (long)this.CONST_EXTRACTION_SELECTOR.getValueCardinality());
    }

    @Test
    public void testLookupName() {
        Assert.assertEquals(null, (Object)this.NULL_SELECTOR.lookupName(0));
        Assert.assertEquals((Object)"billy", (Object)this.CONST_SELECTOR.lookupName(0));
        Assert.assertEquals((Object)"billy", (Object)this.NULL_EXTRACTION_SELECTOR.lookupName(0));
        Assert.assertEquals((Object)"billy", (Object)this.CONST_EXTRACTION_SELECTOR.lookupName(0));
    }

    @Test
    public void testLookupId() {
        Assert.assertEquals((long)0L, (long)this.NULL_SELECTOR.idLookup().lookupId(null));
        Assert.assertEquals((long)-1L, (long)this.NULL_SELECTOR.idLookup().lookupId(""));
        Assert.assertEquals((long)-1L, (long)this.NULL_SELECTOR.idLookup().lookupId("billy"));
        Assert.assertEquals((long)-1L, (long)this.NULL_SELECTOR.idLookup().lookupId("bob"));
        Assert.assertEquals((long)-1L, (long)this.CONST_SELECTOR.idLookup().lookupId(null));
        Assert.assertEquals((long)-1L, (long)this.CONST_SELECTOR.idLookup().lookupId(""));
        Assert.assertEquals((long)0L, (long)this.CONST_SELECTOR.idLookup().lookupId("billy"));
        Assert.assertEquals((long)-1L, (long)this.CONST_SELECTOR.idLookup().lookupId("bob"));
        Assert.assertEquals((long)-1L, (long)this.NULL_EXTRACTION_SELECTOR.idLookup().lookupId(null));
        Assert.assertEquals((long)-1L, (long)this.NULL_EXTRACTION_SELECTOR.idLookup().lookupId(""));
        Assert.assertEquals((long)0L, (long)this.NULL_EXTRACTION_SELECTOR.idLookup().lookupId("billy"));
        Assert.assertEquals((long)-1L, (long)this.NULL_EXTRACTION_SELECTOR.idLookup().lookupId("bob"));
        Assert.assertEquals((long)-1L, (long)this.CONST_EXTRACTION_SELECTOR.idLookup().lookupId(null));
        Assert.assertEquals((long)-1L, (long)this.CONST_EXTRACTION_SELECTOR.idLookup().lookupId(""));
        Assert.assertEquals((long)0L, (long)this.CONST_EXTRACTION_SELECTOR.idLookup().lookupId("billy"));
        Assert.assertEquals((long)-1L, (long)this.CONST_EXTRACTION_SELECTOR.idLookup().lookupId("bob"));
    }

    @Test
    public void testValueMatcherPredicates() {
        StringPredicateDruidPredicateFactory nullUnkown = StringPredicateDruidPredicateFactory.of(value -> value == null ? DruidPredicateMatch.UNKNOWN : DruidPredicateMatch.TRUE);
        ValueMatcher matcher = this.NULL_SELECTOR.makeValueMatcher((DruidPredicateFactory)nullUnkown);
        Assert.assertFalse((boolean)matcher.matches(false));
        Assert.assertTrue((boolean)matcher.matches(true));
        StringPredicateDruidPredicateFactory notUnknown = StringPredicateDruidPredicateFactory.of((DruidObjectPredicate)DruidObjectPredicate.notNull());
        matcher = this.NULL_SELECTOR.makeValueMatcher((DruidPredicateFactory)notUnknown);
        Assert.assertFalse((boolean)matcher.matches(false));
        Assert.assertFalse((boolean)matcher.matches(true));
    }
}

