/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.StringFormatExtractionFn;
import org.apache.druid.query.extraction.SubstringDimExtractionFn;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.StringPredicateDruidPredicateFactory;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class ConstantMultiValueDimensionSelectorTest
extends InitializedNullHandlingTest {
    private final DimensionSelector NULL_SELECTOR = DimensionSelector.multiConstant(null);
    private final DimensionSelector EMPTY_SELECTOR = DimensionSelector.multiConstant(Collections.emptyList());
    private final DimensionSelector SINGLE_SELECTOR = DimensionSelector.multiConstant((List)ImmutableList.of((Object)"billy"));
    private final DimensionSelector CONST_SELECTOR = DimensionSelector.multiConstant((List)ImmutableList.of((Object)"billy", (Object)"douglas"));
    private final DimensionSelector NULL_EXTRACTION_SELECTOR = DimensionSelector.multiConstant(null, (ExtractionFn)new StringFormatExtractionFn("billy"));
    private final DimensionSelector CONST_EXTRACTION_SELECTOR = DimensionSelector.multiConstant((List)ImmutableList.of((Object)"billy", (Object)"douglas", (Object)"billy"), (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(4)));

    @Test
    public void testGetRow() {
        IndexedInts row = this.NULL_SELECTOR.getRow();
        Assert.assertEquals((long)1L, (long)row.size());
        Assert.assertEquals((long)0L, (long)row.get(0));
        row = this.EMPTY_SELECTOR.getRow();
        Assert.assertEquals((long)1L, (long)row.size());
        Assert.assertEquals((long)0L, (long)row.get(0));
        row = this.SINGLE_SELECTOR.getRow();
        Assert.assertEquals((long)1L, (long)row.size());
        Assert.assertEquals((long)0L, (long)row.get(0));
        row = this.CONST_SELECTOR.getRow();
        Assert.assertEquals((long)2L, (long)row.size());
        Assert.assertEquals((long)0L, (long)row.get(0));
        Assert.assertEquals((long)1L, (long)row.get(1));
        row = this.NULL_EXTRACTION_SELECTOR.getRow();
        Assert.assertEquals((long)1L, (long)row.size());
        Assert.assertEquals((long)0L, (long)row.get(0));
        row = this.CONST_EXTRACTION_SELECTOR.getRow();
        Assert.assertEquals((long)3L, (long)row.size());
        Assert.assertEquals((long)0L, (long)row.get(0));
        Assert.assertEquals((long)1L, (long)row.get(1));
        Assert.assertEquals((long)2L, (long)row.get(2));
    }

    @Test
    public void testLookupName() {
        Assert.assertNull((Object)this.NULL_SELECTOR.lookupName(0));
        Assert.assertNull((Object)this.EMPTY_SELECTOR.lookupName(0));
        Assert.assertEquals((Object)"billy", (Object)this.CONST_SELECTOR.lookupName(0));
        Assert.assertEquals((Object)"douglas", (Object)this.CONST_SELECTOR.lookupName(1));
        Assert.assertEquals((Object)"billy", (Object)this.NULL_EXTRACTION_SELECTOR.lookupName(0));
        Assert.assertEquals((Object)"bill", (Object)this.CONST_EXTRACTION_SELECTOR.lookupName(0));
        Assert.assertEquals((Object)"doug", (Object)this.CONST_EXTRACTION_SELECTOR.lookupName(1));
        Assert.assertEquals((Object)"bill", (Object)this.CONST_EXTRACTION_SELECTOR.lookupName(2));
    }

    @Test
    public void testGetObject() {
        Assert.assertNull((Object)this.NULL_SELECTOR.lookupName(0));
        Assert.assertNull((Object)this.EMPTY_SELECTOR.lookupName(0));
        Assert.assertEquals((Object)"billy", (Object)this.SINGLE_SELECTOR.getObject());
        Assert.assertEquals((Object)ImmutableList.of((Object)"billy", (Object)"douglas"), (Object)this.CONST_SELECTOR.getObject());
        Assert.assertEquals((Object)"billy", (Object)this.NULL_EXTRACTION_SELECTOR.getObject());
        Assert.assertEquals((Object)ImmutableList.of((Object)"bill", (Object)"doug", (Object)"bill"), (Object)this.CONST_EXTRACTION_SELECTOR.getObject());
    }

    @Test
    public void testCoverage() {
        Assert.assertEquals((long)-1L, (long)this.CONST_SELECTOR.getValueCardinality());
        Assert.assertNull((Object)this.CONST_SELECTOR.idLookup());
        Assert.assertEquals(Object.class, (Object)this.CONST_SELECTOR.classOfObject());
        Assert.assertTrue((boolean)this.CONST_SELECTOR.nameLookupPossibleInAdvance());
    }

    @Test
    public void testValueMatcher() {
        Assert.assertTrue((boolean)this.NULL_SELECTOR.makeValueMatcher((String)null).matches(false));
        Assert.assertFalse((boolean)this.NULL_SELECTOR.makeValueMatcher("douglas").matches(false));
        Assert.assertTrue((boolean)this.EMPTY_SELECTOR.makeValueMatcher((String)null).matches(false));
        Assert.assertFalse((boolean)this.EMPTY_SELECTOR.makeValueMatcher("douglas").matches(false));
        Assert.assertTrue((boolean)this.CONST_SELECTOR.makeValueMatcher("billy").matches(false));
        Assert.assertTrue((boolean)this.CONST_SELECTOR.makeValueMatcher("douglas").matches(false));
        Assert.assertFalse((boolean)this.CONST_SELECTOR.makeValueMatcher("debbie").matches(false));
        Assert.assertTrue((boolean)this.NULL_EXTRACTION_SELECTOR.makeValueMatcher("billy").matches(false));
        Assert.assertFalse((boolean)this.NULL_EXTRACTION_SELECTOR.makeValueMatcher((String)null).matches(false));
        Assert.assertTrue((boolean)this.CONST_EXTRACTION_SELECTOR.makeValueMatcher("bill").matches(false));
        Assert.assertTrue((boolean)this.CONST_EXTRACTION_SELECTOR.makeValueMatcher("doug").matches(false));
        Assert.assertFalse((boolean)this.CONST_EXTRACTION_SELECTOR.makeValueMatcher("billy").matches(false));
        Assert.assertTrue((boolean)this.NULL_SELECTOR.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.of((DruidObjectPredicate)DruidObjectPredicate.isNull())).matches(false));
        Assert.assertFalse((boolean)this.NULL_SELECTOR.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)"billy")).matches(false));
        Assert.assertTrue((boolean)this.EMPTY_SELECTOR.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo(null)).matches(false));
        Assert.assertFalse((boolean)this.EMPTY_SELECTOR.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)"douglas")).matches(false));
        Assert.assertTrue((boolean)this.CONST_SELECTOR.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)"billy")).matches(false));
        Assert.assertTrue((boolean)this.CONST_SELECTOR.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)"douglas")).matches(false));
        Assert.assertFalse((boolean)this.CONST_SELECTOR.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)"debbie")).matches(false));
        Assert.assertTrue((boolean)this.NULL_EXTRACTION_SELECTOR.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)"billy")).matches(false));
        Assert.assertFalse((boolean)this.NULL_EXTRACTION_SELECTOR.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo(null)).matches(false));
        Assert.assertTrue((boolean)this.CONST_EXTRACTION_SELECTOR.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)"bill")).matches(false));
        Assert.assertTrue((boolean)this.CONST_EXTRACTION_SELECTOR.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)"doug")).matches(false));
        Assert.assertFalse((boolean)this.CONST_EXTRACTION_SELECTOR.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)"billy")).matches(false));
    }
}

