/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.io.smoosh.Smoosh;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.SegmentLazyLoadFailCallback;
import org.apache.druid.segment.SimpleQueryableIndex;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.BaseColumnHolder;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnDescriptor;
import org.apache.druid.segment.data.BitmapSerde;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class IndexIONullColumnsCompatibilityTest
extends InitializedNullHandlingTest {
    private static final Interval INTERVAL = Intervals.of((String)"2022-01/P1D");
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File segmentDir;

    @Before
    public void setup() throws IOException {
        IndexMergerV9 indexMerger = TestHelper.getTestIndexMergerV9((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
        IncrementalIndex incrementalIndex = new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(INTERVAL.getStart().getMillis()).withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("count")}).withDimensionsSpec(new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("dim1", "unknownDim", "dim2")))).build()).setMaxRowCount(1000000).build();
        incrementalIndex.add((InputRow)new MapBasedInputRow(INTERVAL.getStart(), (List)ImmutableList.of((Object)"dim1", (Object)"dim2"), (Map)ImmutableMap.of((Object)"dim1", (Object)"val1", (Object)"dim2", (Object)"val2")));
        this.segmentDir = indexMerger.persist(incrementalIndex, this.temporaryFolder.newFolder(), IndexSpec.getDefault(), (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
    }

    @Test
    public void testV9LoaderThatReadsEmptyColumns() throws IOException {
        QueryableIndex queryableIndex = TestHelper.getTestIndexIO().loadIndex(this.segmentDir);
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim1", (Object)"unknownDim", (Object)"dim2"), (Object)Lists.newArrayList((Iterator)queryableIndex.getAvailableDimensions().iterator()));
    }

    @Test
    public void testV9LoaderThatIgnoresmptyColumns() throws IOException {
        QueryableIndex queryableIndex = new V9IndexLoaderExceptEmptyColumns(ColumnConfig.SELECTION_SIZE).load(this.segmentDir, TestHelper.makeJsonMapper(), false, SegmentLazyLoadFailCallback.NOOP);
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim1", (Object)"dim2"), (Object)Lists.newArrayList((Iterator)queryableIndex.getAvailableDimensions().iterator()));
    }

    private static class V9IndexLoaderExceptEmptyColumns
    implements IndexIO.IndexLoader {
        private final ColumnConfig columnConfig;

        private V9IndexLoaderExceptEmptyColumns(ColumnConfig columnConfig) {
            this.columnConfig = columnConfig;
        }

        public QueryableIndex load(File inDir, final ObjectMapper mapper, boolean lazy, SegmentLazyLoadFailCallback loadFailed) throws IOException {
            int theVersion = Ints.fromByteArray((byte[])Files.toByteArray((File)new File(inDir, "version.bin")));
            if (theVersion != 9) {
                throw new IAE("Expected version[9], got[%d]", new Object[]{theVersion});
            }
            final SmooshedFileMapper smooshedFiles = Smoosh.map((File)inDir);
            ByteBuffer indexBuffer = smooshedFiles.mapFile("index.drd");
            GenericIndexed cols = GenericIndexed.read((ByteBuffer)indexBuffer, (ObjectStrategy)GenericIndexed.STRING_STRATEGY, (SmooshedFileMapper)smooshedFiles);
            GenericIndexed dims = GenericIndexed.read((ByteBuffer)indexBuffer, (ObjectStrategy)GenericIndexed.STRING_STRATEGY, (SmooshedFileMapper)smooshedFiles);
            Interval dataInterval = Intervals.utc((long)indexBuffer.getLong(), (long)indexBuffer.getLong());
            Object segmentBitmapSerdeFactory = indexBuffer.hasRemaining() ? (BitmapSerdeFactory)mapper.readValue(IndexIO.SERIALIZER_UTILS.readString(indexBuffer), BitmapSerdeFactory.class) : new BitmapSerde.LegacyBitmapSerdeFactory();
            HashMap<String, Supplier> columns = new HashMap<String, Supplier>();
            for (String columnName : cols) {
                if (Strings.isNullOrEmpty((String)columnName)) continue;
                ByteBuffer colBuffer = smooshedFiles.mapFile(columnName);
                if (lazy) {
                    columns.put(columnName, Suppliers.memoize(() -> {
                        try {
                            return this.deserializeColumn(mapper, colBuffer, smooshedFiles);
                        }
                        catch (IOException | RuntimeException e) {
                            loadFailed.execute();
                            throw Throwables.propagate((Throwable)e);
                        }
                    }));
                    continue;
                }
                BaseColumnHolder columnHolder = this.deserializeColumn(mapper, colBuffer, smooshedFiles);
                columns.put(columnName, () -> columnHolder);
            }
            ByteBuffer timeBuffer = smooshedFiles.mapFile("__time");
            if (lazy) {
                columns.put("__time", Suppliers.memoize(() -> {
                    try {
                        return this.deserializeColumn(mapper, timeBuffer, smooshedFiles);
                    }
                    catch (IOException | RuntimeException e) {
                        loadFailed.execute();
                        throw Throwables.propagate((Throwable)e);
                    }
                }));
            } else {
                BaseColumnHolder columnHolder = this.deserializeColumn(mapper, timeBuffer, smooshedFiles);
                columns.put("__time", () -> columnHolder);
            }
            SimpleQueryableIndex index = new SimpleQueryableIndex(dataInterval, (Indexed)dims, segmentBitmapSerdeFactory.getBitmapFactory(), columns, smooshedFiles){

                public Metadata getMetadata() {
                    try {
                        ByteBuffer metadataBB = smooshedFiles.mapFile("metadata.drd");
                        if (metadataBB != null) {
                            return (Metadata)mapper.readValue(IndexIO.SERIALIZER_UTILS.readBytes(metadataBB, metadataBB.remaining()), Metadata.class);
                        }
                        return null;
                    }
                    catch (IOException ex) {
                        throw DruidException.defensive((Throwable)ex, (String)"Failed to read metadata", (Object[])new Object[0]);
                    }
                }
            };
            return index;
        }

        private BaseColumnHolder deserializeColumn(ObjectMapper mapper, ByteBuffer byteBuffer, SmooshedFileMapper smooshedFiles) throws IOException {
            ColumnDescriptor serde = (ColumnDescriptor)mapper.readValue(IndexIO.SERIALIZER_UTILS.readString(byteBuffer), ColumnDescriptor.class);
            return serde.read(byteBuffer, this.columnConfig, smooshedFiles, null);
        }
    }
}

