/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.monomorphicprocessing.HotLoopCallee;
import org.apache.druid.query.monomorphicprocessing.StringRuntimeShape;
import org.apache.druid.segment.BaseSingleValueDimensionSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.ListCursor;
import org.apache.druid.segment.UnnestColumnValueSelectorCursor;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class UnnestColumnValueSelectorCursorTest
extends InitializedNullHandlingTest {
    private static String OUTPUT_NAME = "unnested-column";

    @AfterClass
    public static void tearDownClass() {
    }

    @Test
    public void test_list_unnest_cursors() {
        ArrayList<Object> baseList = new ArrayList<Object>();
        for (int i = 0; i < 2; ++i) {
            ArrayList<String> newList = new ArrayList<String>();
            for (int j = 0; j < 2; ++j) {
                newList.add(String.valueOf(i * 2 + j));
            }
            baseList.add(newList);
        }
        ListCursor listCursor = new ListCursor(baseList);
        UnnestColumnValueSelectorCursor unnestCursor = new UnnestColumnValueSelectorCursor((Cursor)listCursor, listCursor.getColumnSelectorFactory(), (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_NAME, "\"dummy\"", ColumnType.STRING, ExprMacroTable.nil()));
        ColumnValueSelector unnestColumnValueSelector = unnestCursor.getColumnSelectorFactory().makeColumnValueSelector(OUTPUT_NAME);
        int j = 0;
        while (!unnestCursor.isDone()) {
            Object colSelectorVal = unnestColumnValueSelector.getObject();
            Assert.assertEquals((Object)String.valueOf(j), (Object)colSelectorVal.toString());
            ++j;
            unnestCursor.advance();
        }
        Assert.assertEquals((long)j, (long)4L);
    }

    @Test
    public void test_list_unnest_cursors_user_supplied_list() {
        List<Object> inputList = Arrays.asList(Arrays.asList("a", "b", "c"), Arrays.asList("e", "f", "g", "h", "i"), Collections.singletonList("j"));
        List<String> expectedResults = Arrays.asList("a", "b", "c", "e", "f", "g", "h", "i", "j");
        ListCursor listCursor = new ListCursor(inputList);
        UnnestColumnValueSelectorCursor unnestCursor = new UnnestColumnValueSelectorCursor((Cursor)listCursor, listCursor.getColumnSelectorFactory(), (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_NAME, "\"dummy\"", ColumnType.STRING, ExprMacroTable.nil()));
        ColumnValueSelector unnestColumnValueSelector = unnestCursor.getColumnSelectorFactory().makeColumnValueSelector(OUTPUT_NAME);
        int k = 0;
        while (!unnestCursor.isDone()) {
            Object valueSelectorVal = unnestColumnValueSelector.getObject();
            Assert.assertEquals((Object)expectedResults.get(k), (Object)valueSelectorVal.toString());
            ++k;
            unnestCursor.advance();
        }
        Assert.assertEquals((long)k, (long)9L);
    }

    @Test
    public void test_list_unnest_cursors_user_supplied_list_only_nulls() {
        List<Object> inputList = Arrays.asList(Collections.singletonList(null), Arrays.asList(null, null), Collections.singletonList(null), Collections.emptyList());
        ListCursor listCursor = new ListCursor(inputList);
        UnnestColumnValueSelectorCursor unnestCursor = new UnnestColumnValueSelectorCursor((Cursor)listCursor, listCursor.getColumnSelectorFactory(), (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_NAME, "\"dummy\"", ColumnType.STRING, ExprMacroTable.nil()));
        ColumnValueSelector unnestColumnValueSelector = unnestCursor.getColumnSelectorFactory().makeColumnValueSelector(OUTPUT_NAME);
        int k = 0;
        while (!unnestCursor.isDone()) {
            Object valueSelectorVal = unnestColumnValueSelector.getObject();
            Assert.assertNull((Object)valueSelectorVal);
            ++k;
            unnestCursor.advance();
        }
        Assert.assertEquals((long)k, (long)2L);
    }

    @Test
    public void test_list_unnest_cursors_user_supplied_list_only_nulls_mv_to_array() {
        List<Object> inputList = Arrays.asList(Collections.singletonList(null), Arrays.asList(null, null), Collections.singletonList(null), Collections.emptyList());
        ListCursor listCursor = new ListCursor(inputList);
        UnnestColumnValueSelectorCursor unnestCursor = new UnnestColumnValueSelectorCursor((Cursor)listCursor, listCursor.getColumnSelectorFactory(), (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_NAME, "mv_to_array(\"dummy\")", ColumnType.STRING, ExprMacroTable.nil()));
        ColumnValueSelector unnestColumnValueSelector = unnestCursor.getColumnSelectorFactory().makeColumnValueSelector(OUTPUT_NAME);
        int k = 0;
        while (!unnestCursor.isDone()) {
            Object valueSelectorVal = unnestColumnValueSelector.getObject();
            Assert.assertNull((Object)valueSelectorVal);
            ++k;
            unnestCursor.advance();
        }
        Assert.assertEquals((long)k, (long)2L);
    }

    @Test
    public void test_list_unnest_cursors_user_supplied_list_only_nulls_array() {
        List<Object> inputList = Arrays.asList(Collections.singletonList(null), Arrays.asList(null, null), Collections.singletonList(null), Collections.emptyList());
        ListCursor listCursor = new ListCursor(inputList);
        UnnestColumnValueSelectorCursor unnestCursor = new UnnestColumnValueSelectorCursor((Cursor)listCursor, listCursor.getColumnSelectorFactory(), (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_NAME, "\"dummy\"", ColumnType.STRING_ARRAY, ExprMacroTable.nil()));
        ColumnValueSelector unnestColumnValueSelector = unnestCursor.getColumnSelectorFactory().makeColumnValueSelector(OUTPUT_NAME);
        int k = 0;
        while (!unnestCursor.isDone()) {
            Object valueSelectorVal = unnestColumnValueSelector.getObject();
            Assert.assertNull((Object)valueSelectorVal);
            ++k;
            unnestCursor.advance();
        }
        Assert.assertEquals((long)k, (long)4L);
    }

    @Test
    public void test_list_unnest_cursors_user_supplied_list_mixed_with_nulls() {
        List<Object> inputList = Arrays.asList(Arrays.asList("a", "b"), Arrays.asList("b", "c"), "d", Collections.singletonList(null), Arrays.asList(null, null), Collections.emptyList(), null, null, null);
        List<String> expectedResults = Arrays.asList("a", "b", "b", "c", "d", null, null);
        ListCursor listCursor = new ListCursor(inputList);
        UnnestColumnValueSelectorCursor unnestCursor = new UnnestColumnValueSelectorCursor((Cursor)listCursor, listCursor.getColumnSelectorFactory(), (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_NAME, "\"dummy\"", ColumnType.STRING, ExprMacroTable.nil()));
        ColumnValueSelector unnestColumnValueSelector = unnestCursor.getColumnSelectorFactory().makeColumnValueSelector(OUTPUT_NAME);
        int k = 0;
        while (!unnestCursor.isDone()) {
            Object valueSelectorVal = unnestColumnValueSelector.getObject();
            if (valueSelectorVal == null) {
                Assert.assertNull((Object)expectedResults.get(k));
            } else {
                Assert.assertEquals((Object)expectedResults.get(k), (Object)valueSelectorVal.toString());
            }
            ++k;
            unnestCursor.advance();
        }
        Assert.assertEquals((long)k, (long)7L);
    }

    @Test
    public void test_list_unnest_cursors_user_supplied_list_mixed_with_nulls_array() {
        List<Object> inputList = Arrays.asList(Arrays.asList("a", "b"), Arrays.asList("b", "c"), "d", Collections.singletonList(null), Arrays.asList(null, null), Collections.emptyList(), null, null, null);
        List<String> expectedResults = Arrays.asList("a", "b", "b", "c", "d", null, null, null);
        ListCursor listCursor = new ListCursor(inputList);
        UnnestColumnValueSelectorCursor unnestCursor = new UnnestColumnValueSelectorCursor((Cursor)listCursor, listCursor.getColumnSelectorFactory(), (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_NAME, "\"dummy\"", ColumnType.STRING_ARRAY, ExprMacroTable.nil()));
        ColumnValueSelector unnestColumnValueSelector = unnestCursor.getColumnSelectorFactory().makeColumnValueSelector(OUTPUT_NAME);
        int k = 0;
        while (!unnestCursor.isDone()) {
            Object valueSelectorVal = unnestColumnValueSelector.getObject();
            if (valueSelectorVal == null) {
                Assert.assertNull((Object)expectedResults.get(k));
            } else {
                Assert.assertEquals((Object)expectedResults.get(k), (Object)valueSelectorVal.toString());
            }
            ++k;
            unnestCursor.advance();
        }
        Assert.assertEquals((long)k, (long)8L);
    }

    @Test
    public void test_list_unnest_cursors_user_supplied_strings_and_no_lists() {
        List<Object> inputList = Arrays.asList("a", "b", "c", "e", "f", "g", "h", "i", "j");
        List<String> expectedResults = Arrays.asList("a", "b", "c", "e", "f", "g", "h", "i", "j");
        ListCursor listCursor = new ListCursor(inputList);
        UnnestColumnValueSelectorCursor unnestCursor = new UnnestColumnValueSelectorCursor((Cursor)listCursor, listCursor.getColumnSelectorFactory(), (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_NAME, "\"dummy\"", ColumnType.STRING, ExprMacroTable.nil()));
        ColumnValueSelector unnestColumnValueSelector = unnestCursor.getColumnSelectorFactory().makeColumnValueSelector(OUTPUT_NAME);
        int k = 0;
        while (!unnestCursor.isDone()) {
            Object valueSelectorVal = unnestColumnValueSelector.getObject();
            Assert.assertEquals((Object)expectedResults.get(k), (Object)valueSelectorVal.toString());
            ++k;
            unnestCursor.advance();
        }
        Assert.assertEquals((long)k, (long)9L);
    }

    @Test
    public void test_list_unnest_cursors_user_supplied_strings_mixed_with_list() {
        List<Object> inputList = Arrays.asList("a", "b", "c", "e", "f", Arrays.asList("g", "h"), "i", "j");
        List<String> expectedResults = Arrays.asList("a", "b", "c", "e", "f", "g", "h", "i", "j");
        ListCursor listCursor = new ListCursor(inputList);
        UnnestColumnValueSelectorCursor unnestCursor = new UnnestColumnValueSelectorCursor((Cursor)listCursor, listCursor.getColumnSelectorFactory(), (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_NAME, "\"dummy\"", ColumnType.STRING, ExprMacroTable.nil()));
        ColumnValueSelector unnestColumnValueSelector = unnestCursor.getColumnSelectorFactory().makeColumnValueSelector(OUTPUT_NAME);
        int k = 0;
        while (!unnestCursor.isDone()) {
            Object valueSelectorVal = unnestColumnValueSelector.getObject();
            Assert.assertEquals((Object)expectedResults.get(k), (Object)valueSelectorVal.toString());
            ++k;
            unnestCursor.advance();
        }
        Assert.assertEquals((long)k, (long)9L);
    }

    @Test
    public void test_list_unnest_cursors_user_supplied_lists_three_levels() {
        List<Object> inputList = Arrays.asList(Arrays.asList("a", "b", "c"), Arrays.asList("e", "f", "g", "h", "i"), Arrays.asList("j", Arrays.asList("a", "b")));
        List<Object> expectedResults = Arrays.asList("a", "b", "c", "e", "f", "g", "h", "i", "j", Arrays.asList("a", "b"));
        ListCursor listCursor = new ListCursor(inputList);
        UnnestColumnValueSelectorCursor unnestCursor = new UnnestColumnValueSelectorCursor((Cursor)listCursor, listCursor.getColumnSelectorFactory(), (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_NAME, "\"dummy\"", null, ExprMacroTable.nil()));
        ColumnValueSelector unnestColumnValueSelector = unnestCursor.getColumnSelectorFactory().makeColumnValueSelector(OUTPUT_NAME);
        int k = 0;
        while (!unnestCursor.isDone()) {
            Object valueSelectorVal = unnestColumnValueSelector.getObject();
            Assert.assertEquals((Object)expectedResults.get(k).toString(), (Object)valueSelectorVal.toString());
            ++k;
            unnestCursor.advance();
        }
        Assert.assertEquals((long)k, (long)10L);
    }

    @Test
    public void test_list_unnest_of_unnest_cursors_user_supplied_list_three_levels() {
        List<Object> inputList = Arrays.asList(Arrays.asList("a", "b", "c"), Arrays.asList("e", "f", "g", "h", "i"), Arrays.asList("j", Arrays.asList("a", "b")));
        List<Object> expectedResults = Arrays.asList("a", "b", "c", "e", "f", "g", "h", "i", "j", "a", "b");
        ListCursor listCursor = new ListCursor(inputList);
        UnnestColumnValueSelectorCursor childCursor = new UnnestColumnValueSelectorCursor((Cursor)listCursor, listCursor.getColumnSelectorFactory(), (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_NAME, "\"dummy\"", null, ExprMacroTable.nil()));
        UnnestColumnValueSelectorCursor parentCursor = new UnnestColumnValueSelectorCursor((Cursor)childCursor, childCursor.getColumnSelectorFactory(), (VirtualColumn)new ExpressionVirtualColumn("tmp-out", "\"" + OUTPUT_NAME + "\"", null, ExprMacroTable.nil()));
        ColumnValueSelector unnestColumnValueSelector = parentCursor.getColumnSelectorFactory().makeColumnValueSelector("tmp-out");
        int k = 0;
        while (!parentCursor.isDone()) {
            Object valueSelectorVal = unnestColumnValueSelector.getObject();
            Assert.assertEquals((Object)expectedResults.get(k).toString(), (Object)valueSelectorVal.toString());
            ++k;
            parentCursor.advance();
        }
        Assert.assertEquals((long)k, (long)11L);
    }

    @Test
    public void test_list_unnest_cursors_user_supplied_list_with_nulls() {
        List<Object> inputList = Arrays.asList(Arrays.asList("a", "b", "c"), Arrays.asList("e", "f", "g", "h", "i", null), Collections.singletonList("j"));
        List<Object> expectedResults = Arrays.asList("a", "b", "c", "e", "f", "g", "h", "i", null, "j");
        ListCursor listCursor = new ListCursor(inputList);
        UnnestColumnValueSelectorCursor unnestCursor = new UnnestColumnValueSelectorCursor((Cursor)listCursor, listCursor.getColumnSelectorFactory(), (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_NAME, "\"dummy\"", ColumnType.STRING, ExprMacroTable.nil()));
        ColumnValueSelector unnestColumnValueSelector = unnestCursor.getColumnSelectorFactory().makeColumnValueSelector(OUTPUT_NAME);
        int k = 0;
        while (!unnestCursor.isDone()) {
            Object valueSelectorVal = unnestColumnValueSelector.getObject();
            if (valueSelectorVal == null) {
                Assert.assertEquals(null, (Object)expectedResults.get(k));
            } else {
                Assert.assertEquals((Object)expectedResults.get(k), (Object)valueSelectorVal.toString());
            }
            ++k;
            unnestCursor.advance();
        }
        Assert.assertEquals((long)expectedResults.size(), (long)k);
    }

    @Test
    public void test_list_unnest_cursors_user_supplied_list_with_dups() {
        List<Object> inputList = Arrays.asList(Arrays.asList("a", "a", "a"), Arrays.asList("e", "f", null, "h", "i", null), Collections.singletonList("j"));
        List<Object> expectedResults = Arrays.asList("a", "a", "a", "e", "f", null, "h", "i", null, "j");
        ListCursor listCursor = new ListCursor(inputList);
        UnnestColumnValueSelectorCursor unnestCursor = new UnnestColumnValueSelectorCursor((Cursor)listCursor, listCursor.getColumnSelectorFactory(), (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_NAME, "\"dummy\"", ColumnType.STRING, ExprMacroTable.nil()));
        ColumnValueSelector unnestColumnValueSelector = unnestCursor.getColumnSelectorFactory().makeColumnValueSelector(OUTPUT_NAME);
        int k = 0;
        while (!unnestCursor.isDone()) {
            Object valueSelectorVal = unnestColumnValueSelector.getObject();
            if (valueSelectorVal == null) {
                Assert.assertEquals(null, (Object)expectedResults.get(k));
            } else {
                Assert.assertEquals((Object)expectedResults.get(k), (Object)valueSelectorVal.toString());
            }
            ++k;
            unnestCursor.advance();
        }
        Assert.assertEquals((long)k, (long)10L);
    }

    @Test
    public void test_list_unnest_cursors_user_supplied_list_double() {
        List<Object> inputList = Arrays.asList(Arrays.asList(1, 2, 3), Arrays.asList(4, 5, 6, 7, 8), Collections.singletonList(9));
        List<Double> expectedResults = Arrays.asList(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0);
        ListCursor listCursor = new ListCursor(inputList);
        UnnestColumnValueSelectorCursor unnestCursor = new UnnestColumnValueSelectorCursor((Cursor)listCursor, listCursor.getColumnSelectorFactory(), (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_NAME, "\"dummy\"", ColumnType.STRING, ExprMacroTable.nil()));
        ColumnValueSelector unnestColumnValueSelector = unnestCursor.getColumnSelectorFactory().makeColumnValueSelector(OUTPUT_NAME);
        int k = 0;
        while (!unnestCursor.isDone()) {
            Double valueSelectorVal = unnestColumnValueSelector.getDouble();
            Assert.assertEquals((Object)expectedResults.get(k), (Object)valueSelectorVal);
            ++k;
            unnestCursor.advance();
        }
        Assert.assertEquals((long)k, (long)9L);
    }

    @Test
    public void test_list_unnest_cursors_user_supplied_list_float() {
        List<Object> inputList = Arrays.asList(Arrays.asList(1, 2, 3), Arrays.asList(4, 5, 6, 7, 8), Collections.singletonList(9));
        List<Float> expectedResults = Arrays.asList(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f), Float.valueOf(6.0f), Float.valueOf(7.0f), Float.valueOf(8.0f), Float.valueOf(9.0f));
        ListCursor listCursor = new ListCursor(inputList);
        UnnestColumnValueSelectorCursor unnestCursor = new UnnestColumnValueSelectorCursor((Cursor)listCursor, listCursor.getColumnSelectorFactory(), (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_NAME, "\"dummy\"", ColumnType.STRING, ExprMacroTable.nil()));
        ColumnValueSelector unnestColumnValueSelector = unnestCursor.getColumnSelectorFactory().makeColumnValueSelector(OUTPUT_NAME);
        int k = 0;
        while (!unnestCursor.isDone()) {
            Float valueSelectorVal = Float.valueOf(unnestColumnValueSelector.getFloat());
            Assert.assertEquals((Object)expectedResults.get(k), (Object)valueSelectorVal);
            ++k;
            unnestCursor.advance();
        }
        Assert.assertEquals((long)k, (long)9L);
    }

    @Test
    public void test_list_unnest_cursors_user_supplied_list_long() {
        List<Object> inputList = Arrays.asList(Arrays.asList(1, 2, 3), Arrays.asList(4, 5, 6, 7, 8), Collections.singletonList(9));
        List<Long> expectedResults = Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L);
        ListCursor listCursor = new ListCursor(inputList);
        UnnestColumnValueSelectorCursor unnestCursor = new UnnestColumnValueSelectorCursor((Cursor)listCursor, listCursor.getColumnSelectorFactory(), (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_NAME, "\"dummy\"", ColumnType.STRING, ExprMacroTable.nil()));
        ColumnValueSelector unnestColumnValueSelector = unnestCursor.getColumnSelectorFactory().makeColumnValueSelector(OUTPUT_NAME);
        int k = 0;
        while (!unnestCursor.isDone()) {
            Object obj = unnestColumnValueSelector.getObject();
            Assert.assertNotNull((Object)obj);
            Long valueSelectorVal = unnestColumnValueSelector.getLong();
            Assert.assertEquals((Object)expectedResults.get(k), (Object)valueSelectorVal);
            ++k;
            unnestCursor.advance();
        }
        Assert.assertEquals((long)k, (long)9L);
    }

    @Test
    public void test_list_unnest_cursors_user_supplied_list_three_level_arrays_and_methods() {
        List<Object> inputList = Arrays.asList(Arrays.asList("a", "b", "c"), Arrays.asList("e", "f", "g", "h", "i"), Arrays.asList("j", Arrays.asList("a", "b")));
        List<Object> expectedResults = Arrays.asList("a", "b", "c", "e", "f", "g", "h", "i", "j", Arrays.asList("a", "b"));
        ListCursor listCursor = new ListCursor(inputList);
        UnnestColumnValueSelectorCursor unnestCursor = new UnnestColumnValueSelectorCursor((Cursor)listCursor, listCursor.getColumnSelectorFactory(), (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_NAME, "\"dummy\"", null, ExprMacroTable.nil()));
        ColumnValueSelector unnestColumnValueSelector = unnestCursor.getColumnSelectorFactory().makeColumnValueSelector(OUTPUT_NAME);
        int k = 0;
        while (!unnestCursor.isDone()) {
            Object valueSelectorVal = unnestColumnValueSelector.getObject();
            Assert.assertEquals((Object)expectedResults.get(k).toString(), (Object)valueSelectorVal.toString());
            ++k;
            unnestCursor.advance();
        }
        Assert.assertEquals((long)k, (long)10L);
        unnestCursor.reset();
        Assert.assertFalse((boolean)unnestCursor.isDoneOrInterrupted());
    }

    @Test
    public void test_list_unnest_cursors_dimSelector() {
        List<Object> inputList = Arrays.asList(Arrays.asList("a", "b", "c"), Arrays.asList("e", "f", "g", "h", "i"), Collections.singletonList(null));
        List<Object> expectedResults = Arrays.asList("a", "b", "c", "e", "f", "g", "h", "i");
        ListCursor listCursor = new ListCursor(inputList);
        UnnestColumnValueSelectorCursor unnestCursor = new UnnestColumnValueSelectorCursor((Cursor)listCursor, listCursor.getColumnSelectorFactory(), (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_NAME, "\"dummy\"", ColumnType.STRING, ExprMacroTable.nil()));
        BaseSingleValueDimensionSelector unnestDimSelector = (BaseSingleValueDimensionSelector)unnestCursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)OUTPUT_NAME));
        StringRuntimeShape.of((HotLoopCallee)unnestDimSelector);
        int k = 0;
        while (!unnestCursor.isDone()) {
            if (k < 8) {
                Assert.assertEquals((Object)expectedResults.get(k).toString(), (Object)unnestDimSelector.getValue());
            } else {
                Assert.assertNull((Object)unnestDimSelector.getValue());
            }
            ++k;
            unnestCursor.advance();
        }
        Assert.assertEquals((long)k, (long)8L);
        unnestCursor.reset();
        Assert.assertNotNull((Object)unnestDimSelector);
    }

    @Test
    public void test_list_unnest_cursors_user_supplied_list_of_integers() {
        List<Object> inputList = Arrays.asList(Arrays.asList(1, 2, 3), Arrays.asList(4, 5, 6, 7, 8), Collections.singletonList(9));
        List<Integer> expectedResults = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9);
        ListCursor listCursor = new ListCursor(inputList);
        UnnestColumnValueSelectorCursor unnestCursor = new UnnestColumnValueSelectorCursor((Cursor)listCursor, listCursor.getColumnSelectorFactory(), (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_NAME, "\"dummy\"", ColumnType.STRING, ExprMacroTable.nil()));
        ColumnValueSelector unnestColumnValueSelector = unnestCursor.getColumnSelectorFactory().makeColumnValueSelector(OUTPUT_NAME);
        int k = 0;
        while (!unnestCursor.isDone()) {
            Object valueSelectorVal = unnestColumnValueSelector.getObject();
            Assert.assertEquals((Object)expectedResults.get(k).toString(), (Object)valueSelectorVal.toString());
            ++k;
            unnestCursor.advance();
        }
        Assert.assertEquals((long)k, (long)9L);
    }
}

