/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import java.util.List;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.data.ColumnarMultiInts;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.WritableSupplier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class CompressedVSizeColumnarMultiIntsSupplierTestBase {
    @Before
    public abstract void setUpSimple();

    @After
    public abstract void teardown() throws IOException;

    public abstract List<int[]> getValsUsed();

    public abstract WritableSupplier<ColumnarMultiInts> getColumnarMultiIntsSupplier();

    public abstract WritableSupplier<ColumnarMultiInts> fromByteBuffer(ByteBuffer var1);

    @Test
    public void testSanity() {
        this.assertSame(this.getValsUsed(), (ColumnarMultiInts)this.getColumnarMultiIntsSupplier().get());
    }

    @Test
    public void testSerde() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WritableSupplier<ColumnarMultiInts> columnarMultiIntsSupplier = this.getColumnarMultiIntsSupplier();
        columnarMultiIntsSupplier.writeTo(Channels.newChannel(baos), null);
        byte[] bytes = baos.toByteArray();
        Assert.assertEquals((long)columnarMultiIntsSupplier.getSerializedSize(), (long)bytes.length);
        WritableSupplier<ColumnarMultiInts> deserializedColumnarMultiInts = this.fromByteBuffer(ByteBuffer.wrap(bytes));
        this.assertSame(this.getValsUsed(), (ColumnarMultiInts)deserializedColumnarMultiInts.get());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetInvalidElementInRow() {
        ((ColumnarMultiInts)this.getColumnarMultiIntsSupplier().get()).get(3).get(15);
    }

    @Test
    public void testIterators() {
        WritableSupplier<ColumnarMultiInts> columnarMultiIntsSupplier = this.getColumnarMultiIntsSupplier();
        List<int[]> vals = this.getValsUsed();
        Iterator iterator = ((ColumnarMultiInts)columnarMultiIntsSupplier.get()).iterator();
        int row = 0;
        while (iterator.hasNext()) {
            int[] ints = vals.get(row);
            IndexedInts vSizeIndexedInts = (IndexedInts)iterator.next();
            Assert.assertEquals((long)ints.length, (long)vSizeIndexedInts.size());
            int size = vSizeIndexedInts.size();
            for (int i = 0; i < size; ++i) {
                Assert.assertEquals((long)ints[i], (long)vSizeIndexedInts.get(i));
            }
            ++row;
        }
    }

    private void assertSame(List<int[]> someInts, ColumnarMultiInts columnarMultiInts) {
        Assert.assertEquals((long)someInts.size(), (long)columnarMultiInts.size());
        for (int i = 0; i < columnarMultiInts.size(); ++i) {
            int[] ints = someInts.get(i);
            IndexedInts vSizeIndexedInts = columnarMultiInts.get(i);
            Assert.assertEquals((long)ints.length, (long)vSizeIndexedInts.size());
            for (int j = 0; j < ints.length; ++j) {
                Assert.assertEquals((long)ints[j], (long)vSizeIndexedInts.get(j));
            }
        }
    }

    public static <T extends Closeable> WritableSupplier<T> wrapSupplier(final WritableSupplier<T> supplier, final Closer closer) {
        return new WritableSupplier<T>(){

            public T get() {
                return closer.register((Closeable)supplier.get());
            }

            public long getSerializedSize() throws IOException {
                return supplier.getSerializedSize();
            }

            public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
                supplier.writeTo(channel, smoosher);
            }
        };
    }
}

