/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.java.util.common.ByteBufferUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.data.ColumnarMultiInts;
import org.apache.druid.segment.data.CompressedVSizeColumnarMultiIntsSupplier;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.VSizeColumnarInts;
import org.apache.druid.segment.data.WritableSupplier;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestColumnCompression {
    private final CompressionStrategy compressionType;
    private ColumnarMultiInts compressed;
    int bytes = 1;
    int valuesPerRowBound = 5;
    int filteredRowCount = 1000;
    private BitSet filter;
    private ByteBuffer buffer;

    public TestColumnCompression(CompressionStrategy strategy) {
        this.compressionType = strategy;
    }

    /*
     * Exception decompiling
     */
    @Parameterized.Parameters
    public static Iterable<Object[]> compressionStrategies() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Before
    public void setUp() throws Exception {
        int i;
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        ArrayList<int[]> rows = new ArrayList<int[]>();
        int bound = 1 << this.bytes;
        for (i = 0; i < 0x100000; ++i) {
            int count = ((Random)rand).nextInt(this.valuesPerRowBound) + 1;
            int[] row = new int[((Random)rand).nextInt(count)];
            for (int j = 0; j < row.length; ++j) {
                row[j] = ((Random)rand).nextInt(bound);
            }
            rows.add(row);
        }
        this.buffer = TestColumnCompression.serialize((WritableSupplier<ColumnarMultiInts>)CompressedVSizeColumnarMultiIntsSupplier.fromIterable((Iterable)Iterables.transform(rows, input -> VSizeColumnarInts.fromArray((int[])input, (int)20)), (int)(bound - 1), (ByteOrder)ByteOrder.nativeOrder(), (CompressionStrategy)this.compressionType, (Closer)Closer.create()));
        this.compressed = CompressedVSizeColumnarMultiIntsSupplier.fromByteBuffer((ByteBuffer)this.buffer, (ByteOrder)ByteOrder.nativeOrder(), null).get();
        this.filter = new BitSet();
        for (i = 0; i < this.filteredRowCount; ++i) {
            int rowToAccess = ((Random)rand).nextInt(rows.size());
            while (this.filter.get(rowToAccess)) {
                rowToAccess = (rowToAccess + 1) % rows.size();
            }
            this.filter.set(rowToAccess);
        }
    }

    @After
    public void tearDown() throws IOException {
        ByteBufferUtils.free((ByteBuffer)this.buffer);
        this.compressed.close();
    }

    private static ByteBuffer serialize(WritableSupplier<ColumnarMultiInts> writableSupplier) throws IOException {
        final ByteBuffer buffer = ByteBuffer.allocateDirect((int)writableSupplier.getSerializedSize());
        WritableByteChannel channel = new WritableByteChannel(){

            @Override
            public int write(ByteBuffer src) {
                int size = src.remaining();
                buffer.put(src);
                return size;
            }

            @Override
            public boolean isOpen() {
                return true;
            }

            @Override
            public void close() {
            }
        };
        writableSupplier.writeTo(channel, null);
        buffer.rewind();
        return buffer;
    }

    @Test
    public void testCompressed() {
        int i = this.filter.nextSetBit(0);
        while (i >= 0) {
            int rowSize;
            IndexedInts row = this.compressed.get(i);
            int n = rowSize = row != null ? row.size() : 0;
            for (int j = 0; j < rowSize; ++j) {
                row.get(j);
            }
            i = this.filter.nextSetBit(i + 1);
        }
    }
}

