/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeSet;
import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.error.DruidException;
import org.apache.druid.guice.BuiltInTypesModule;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.IsFalseDimFilter;
import org.apache.druid.query.filter.IsTrueDimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.filter.BaseFilterTest;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

public class EqualityFilterTests {

    public static class EqualityFilterNonParameterizedTests
    extends InitializedNullHandlingTest {
        @Test
        public void testSerde() throws JsonProcessingException {
            DefaultObjectMapper mapper = new DefaultObjectMapper();
            EqualityFilter filter = new EqualityFilter("x", ColumnType.STRING, (Object)"hello", null);
            String s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, EqualityFilter.class));
            filter = new EqualityFilter("x", ColumnType.LONG, (Object)1L, null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, EqualityFilter.class));
            filter = new EqualityFilter("x", ColumnType.LONG, (Object)1, null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, EqualityFilter.class));
            filter = new EqualityFilter("x", ColumnType.DOUBLE, (Object)111.111, null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, EqualityFilter.class));
            filter = new EqualityFilter("x", ColumnType.FLOAT, (Object)Float.valueOf(1234.0f), null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, EqualityFilter.class));
            filter = new EqualityFilter("x", ColumnType.STRING_ARRAY, (Object)new Object[]{"a", "b", null, "c"}, null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, EqualityFilter.class));
            filter = new EqualityFilter("x", ColumnType.STRING_ARRAY, Arrays.asList("a", "b", null, "c"), null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, EqualityFilter.class));
            filter = new EqualityFilter("x", ColumnType.LONG_ARRAY, (Object)new Object[]{1L, null, 2L, 3L}, null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, EqualityFilter.class));
            filter = new EqualityFilter("x", ColumnType.LONG_ARRAY, Arrays.asList(1L, null, 2L, 3L), null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, EqualityFilter.class));
            filter = new EqualityFilter("x", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.1, 2.1, null, 3.1}, null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, EqualityFilter.class));
            filter = new EqualityFilter("x", ColumnType.DOUBLE_ARRAY, Arrays.asList(1.1, 2.1, null, 3.1), null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, EqualityFilter.class));
            filter = new EqualityFilter("x", ColumnType.NESTED_DATA, (Object)ImmutableMap.of((Object)"x", (Object)ImmutableList.of((Object)1, (Object)2, (Object)3)), null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, EqualityFilter.class));
        }

        @Test
        public void testGetCacheKey() {
            EqualityFilter f1 = new EqualityFilter("x", ColumnType.STRING, (Object)"hello", null);
            EqualityFilter f1_2 = new EqualityFilter("x", ColumnType.STRING, (Object)"hello", null);
            EqualityFilter f2 = new EqualityFilter("x", ColumnType.STRING, (Object)"world", null);
            EqualityFilter f3 = new EqualityFilter("x", ColumnType.STRING, (Object)"hello", new FilterTuning(Boolean.valueOf(true), null, null));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f1_2.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2.getCacheKey()));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f3.getCacheKey());
            f1 = new EqualityFilter("x", ColumnType.LONG, (Object)1L, null);
            f1_2 = new EqualityFilter("x", ColumnType.LONG, (Object)1, null);
            f2 = new EqualityFilter("x", ColumnType.LONG, (Object)2L, null);
            f3 = new EqualityFilter("x", ColumnType.LONG, (Object)1L, new FilterTuning(Boolean.valueOf(true), null, null));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f1_2.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2.getCacheKey()));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f3.getCacheKey());
            f1 = new EqualityFilter("x", ColumnType.DOUBLE, (Object)1.1, null);
            f1_2 = new EqualityFilter("x", ColumnType.DOUBLE, (Object)1.1, null);
            f2 = new EqualityFilter("x", ColumnType.DOUBLE, (Object)2.2, null);
            f3 = new EqualityFilter("x", ColumnType.DOUBLE, (Object)1.1, new FilterTuning(Boolean.valueOf(true), null, null));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f1_2.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2.getCacheKey()));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f3.getCacheKey());
            f1 = new EqualityFilter("x", ColumnType.FLOAT, (Object)Float.valueOf(1.1f), null);
            f1_2 = new EqualityFilter("x", ColumnType.FLOAT, (Object)Float.valueOf(1.1f), null);
            f2 = new EqualityFilter("x", ColumnType.FLOAT, (Object)Float.valueOf(2.2f), null);
            f3 = new EqualityFilter("x", ColumnType.FLOAT, (Object)Float.valueOf(1.1f), new FilterTuning(Boolean.valueOf(true), null, null));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f1_2.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2.getCacheKey()));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f3.getCacheKey());
            f1 = new EqualityFilter("x", ColumnType.STRING_ARRAY, (Object)new Object[]{"a", "b", null, "c"}, null);
            f1_2 = new EqualityFilter("x", ColumnType.STRING_ARRAY, Arrays.asList("a", "b", null, "c"), null);
            f2 = new EqualityFilter("x", ColumnType.STRING_ARRAY, (Object)new Object[]{"a", "b", "c"}, null);
            f3 = new EqualityFilter("x", ColumnType.STRING_ARRAY, (Object)new Object[]{"a", "b", null, "c"}, new FilterTuning(Boolean.valueOf(true), null, null));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f1_2.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2.getCacheKey()));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f3.getCacheKey());
            f1 = new EqualityFilter("x", ColumnType.LONG_ARRAY, (Object)new Object[]{100L, 200L, null, 300L}, null);
            f1_2 = new EqualityFilter("x", ColumnType.LONG_ARRAY, Arrays.asList(100L, 200L, null, 300L), null);
            f2 = new EqualityFilter("x", ColumnType.LONG_ARRAY, (Object)new Object[]{100L, null, 200L, 300L}, null);
            f3 = new EqualityFilter("x", ColumnType.LONG_ARRAY, (Object)new Object[]{100L, 200L, null, 300L}, new FilterTuning(Boolean.valueOf(true), null, null));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f1_2.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2.getCacheKey()));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f3.getCacheKey());
            f1 = new EqualityFilter("x", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.001, null, 20.0002, 300.0003}, null);
            f1_2 = new EqualityFilter("x", ColumnType.DOUBLE_ARRAY, Arrays.asList(1.001, null, 20.0002, 300.0003), null);
            f2 = new EqualityFilter("x", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.001, 20.0002, 300.0003, null}, null);
            f3 = new EqualityFilter("x", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.001, null, 20.0002, 300.0003}, new FilterTuning(Boolean.valueOf(true), null, null));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f1_2.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2.getCacheKey()));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f3.getCacheKey());
            BuiltInTypesModule.registerHandlersAndSerde();
            f1 = new EqualityFilter("x", ColumnType.NESTED_DATA, (Object)ImmutableMap.of((Object)"x", (Object)ImmutableList.of((Object)1, (Object)2, (Object)3)), null);
            f1_2 = new EqualityFilter("x", ColumnType.NESTED_DATA, (Object)ImmutableMap.of((Object)"x", (Object)ImmutableList.of((Object)1, (Object)2, (Object)3)), null);
            f2 = new EqualityFilter("x", ColumnType.NESTED_DATA, (Object)ImmutableMap.of((Object)"x", (Object)ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4)), null);
            f3 = new EqualityFilter("x", ColumnType.NESTED_DATA, (Object)ImmutableMap.of((Object)"x", (Object)ImmutableList.of((Object)1, (Object)2, (Object)3)), new FilterTuning(Boolean.valueOf(true), null, null));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f1_2.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2.getCacheKey()));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f3.getCacheKey());
        }

        @Test
        public void testInvalidParameters() {
            Throwable t = Assert.assertThrows(DruidException.class, () -> new EqualityFilter(null, ColumnType.STRING, null, null));
            Assert.assertEquals((Object)"Invalid equality filter, column cannot be null", (Object)t.getMessage());
            t = Assert.assertThrows(DruidException.class, () -> new EqualityFilter("dim0", null, null, null));
            Assert.assertEquals((Object)"Invalid equality filter on column [dim0], matchValueType cannot be null", (Object)t.getMessage());
            t = Assert.assertThrows(DruidException.class, () -> new EqualityFilter("dim0", ColumnType.STRING, null, null));
            Assert.assertEquals((Object)"Invalid equality filter on column [dim0], matchValue cannot be null", (Object)t.getMessage());
        }

        @Test
        public void testGetDimensionRangeSet() {
            EqualityFilter filter = new EqualityFilter("x", ColumnType.STRING, (Object)"hello", null);
            TreeRangeSet set = TreeRangeSet.create();
            set.add(Range.singleton((Comparable)((Object)"hello")));
            Assert.assertEquals((Object)set, (Object)filter.getDimensionRangeSet("x"));
            Assert.assertNull((Object)filter.getDimensionRangeSet("y"));
            ExprEval eval = ExprEval.ofType((ExpressionType)ExpressionType.STRING_ARRAY, (Object)new Object[]{"abc", "def"});
            filter = new EqualityFilter("x", ColumnType.STRING_ARRAY, eval.value(), null);
            set = TreeRangeSet.create();
            set.add(Range.singleton((Comparable)((Object)Arrays.deepToString(eval.asArray()))));
            Assert.assertEquals((Object)set, (Object)filter.getDimensionRangeSet("x"));
            Assert.assertNull((Object)filter.getDimensionRangeSet("y"));
        }

        @Test
        public void test_equals() {
            EqualsVerifier.forClass(EqualityFilter.class).usingGetClass().withNonnullFields(new String[]{"column", "matchValueType", "matchValueEval", "matchValue", "predicateFactory", "optimizedFilterIncludeUnknown", "optimizedFilterNoIncludeUnknown"}).withPrefabValues(ColumnType.class, (Object)ColumnType.STRING, (Object)ColumnType.DOUBLE).withPrefabValues(ExprEval.class, (Object)ExprEval.ofString((String)"hello"), (Object)ExprEval.of((double)1.0)).withIgnoredFields(new String[]{"predicateFactory", "optimizedFilterIncludeUnknown", "optimizedFilterNoIncludeUnknown", "matchValue"}).verify();
        }
    }

    @RunWith(value=Parameterized.class)
    public static class EqualityFilterTest
    extends BaseFilterTest {
        public EqualityFilterTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<CursorFactory, Closeable>> finisher, boolean cnf, boolean optimize) {
            super(testName, DEFAULT_ROWS, indexBuilder, finisher, cnf, optimize);
        }

        @AfterClass
        public static void tearDown() throws Exception {
            BaseFilterTest.tearDown(EqualityFilterTest.class.getName());
        }

        @Test
        public void testSingleValueStringColumnWithoutNulls() {
            this.assertFilterMatches((DimFilter)new EqualityFilter("dim0", ColumnType.STRING, (Object)"", null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("dim0", ColumnType.STRING, (Object)"", null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("dim0", ColumnType.STRING, (Object)"0", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("dim0", ColumnType.STRING, (Object)"0", null)), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("dim0", ColumnType.STRING, (Object)"1", null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("dim0", ColumnType.STRING, (Object)"1", null)), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("dim0", ColumnType.LONG, (Object)0L, null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("dim0", ColumnType.LONG, (Object)0L, null)), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("dim0", ColumnType.LONG, (Object)1L, null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("dim0", ColumnType.LONG, (Object)1L, null)), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("dim0", ColumnType.DOUBLE, (Object)1, null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("dim0", ColumnType.DOUBLE, (Object)1, null)), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        }

        @Test
        public void testSingleValueVirtualStringColumnWithoutNulls() {
            this.assertFilterMatches((DimFilter)new EqualityFilter("vdim0", ColumnType.STRING, (Object)"", null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("vdim0", ColumnType.STRING, (Object)"0", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("vdim0", ColumnType.STRING, (Object)"1", null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("vdim0", ColumnType.LONG, (Object)0L, null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("vdim0", ColumnType.LONG, (Object)1L, null), (List<String>)ImmutableList.of((Object)"1"));
        }

        @Test
        public void testListFilteredVirtualColumn() {
            this.assertFilterMatchesSkipVectorize((DimFilter)new EqualityFilter("allow-dim0", ColumnType.STRING, (Object)"1", null), (List<String>)ImmutableList.of());
            this.assertFilterMatchesSkipVectorize((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("allow-dim0", ColumnType.STRING, (Object)"1", null)), (List<String>)ImmutableList.of((Object)"3", (Object)"4"));
            this.assertFilterMatchesSkipVectorize((DimFilter)new EqualityFilter("allow-dim0", ColumnType.STRING, (Object)"4", null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatchesSkipVectorize((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("allow-dim0", ColumnType.STRING, (Object)"4", null)), (List<String>)ImmutableList.of((Object)"3"));
            this.assertFilterMatchesSkipVectorize((DimFilter)new EqualityFilter("deny-dim0", ColumnType.STRING, (Object)"0", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatchesSkipVectorize((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("deny-dim0", ColumnType.STRING, (Object)"0", null)), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
            this.assertFilterMatchesSkipVectorize((DimFilter)new EqualityFilter("deny-dim0", ColumnType.STRING, (Object)"4", null), (List<String>)ImmutableList.of());
            this.assertFilterMatchesSkipVectorize((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("deny-dim0", ColumnType.STRING, (Object)"4", null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"5"));
            if (!this.isAutoSchema()) {
                this.assertFilterMatchesSkipVectorize((DimFilter)new EqualityFilter("allow-dim2", ColumnType.STRING, (Object)"b", null), (List<String>)ImmutableList.of());
                this.assertFilterMatchesSkipVectorize((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("allow-dim2", ColumnType.STRING, (Object)"b", null)), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
                this.assertFilterMatchesSkipVectorize((DimFilter)new EqualityFilter("allow-dim2", ColumnType.STRING, (Object)"a", null), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
                this.assertFilterMatchesSkipVectorize((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("allow-dim2", ColumnType.STRING, (Object)"a", null)), (List<String>)ImmutableList.of());
                this.assertFilterMatchesSkipVectorize((DimFilter)new EqualityFilter("deny-dim2", ColumnType.STRING, (Object)"b", null), (List<String>)ImmutableList.of((Object)"0"));
                this.assertFilterMatchesSkipVectorize((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("deny-dim2", ColumnType.STRING, (Object)"b", null)), (List<String>)ImmutableList.of((Object)"2", (Object)"4"));
                this.assertFilterMatchesSkipVectorize((DimFilter)new EqualityFilter("deny-dim2", ColumnType.STRING, (Object)"a", null), (List<String>)ImmutableList.of());
                this.assertFilterMatchesSkipVectorize((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("deny-dim2", ColumnType.STRING, (Object)"a", null)), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"4"));
            }
        }

        @Test
        public void testSingleValueStringColumnWithNulls() {
            this.assertFilterMatches((DimFilter)new EqualityFilter("dim1", ColumnType.STRING, (Object)"", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("dim1", ColumnType.STRING, (Object)"", null)), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("s0", ColumnType.STRING, (Object)"", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("s0", ColumnType.STRING, (Object)"", null)), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("dim1", ColumnType.STRING, (Object)"10", null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("dim1", ColumnType.STRING, (Object)"2", null), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("dim1", ColumnType.STRING, (Object)"1", null), (List<String>)ImmutableList.of((Object)"3"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("dim1", ColumnType.STRING, (Object)"abdef", null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("dim1", ColumnType.STRING, (Object)"abc", null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("dim1", ColumnType.STRING, (Object)"noexist", null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("s0", ColumnType.STRING, (Object)"a", null), (List<String>)ImmutableList.of((Object)"1", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("s0", ColumnType.STRING, (Object)"b", null), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("s0", ColumnType.STRING, (Object)"c", null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("s0", ColumnType.STRING, (Object)"noexist", null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("dim1", ColumnType.STRING, (Object)"10", null)), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("dim1", ColumnType.STRING, (Object)"noexist", null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("s0", ColumnType.STRING, (Object)"a", null)), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"4"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)IsTrueDimFilter.of((DimFilter)new EqualityFilter("s0", ColumnType.STRING, (Object)"a", null))), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4"));
            this.assertFilterMatches((DimFilter)IsTrueDimFilter.of((DimFilter)new EqualityFilter("s0", ColumnType.STRING, (Object)"a", null)), (List<String>)ImmutableList.of((Object)"1", (Object)"5"));
            this.assertFilterMatches((DimFilter)IsFalseDimFilter.of((DimFilter)new EqualityFilter("s0", ColumnType.STRING, (Object)"a", null)), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"4"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)IsFalseDimFilter.of((DimFilter)new EqualityFilter("s0", ColumnType.STRING, (Object)"a", null))), (List<String>)ImmutableList.of((Object)"1", (Object)"3", (Object)"5"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("s0", ColumnType.STRING, (Object)"noexist", null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5"));
        }

        @Test
        public void testSingleValueVirtualStringColumnWithNulls() {
            this.assertFilterMatches((DimFilter)new EqualityFilter("vdim1", ColumnType.STRING, (Object)"", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("vdim1", ColumnType.STRING, (Object)"", null)), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("vs0", ColumnType.STRING, (Object)"", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("vs0", ColumnType.STRING, (Object)"", null)), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("vdim1", ColumnType.STRING, (Object)"10", null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("vdim1", ColumnType.STRING, (Object)"2", null), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("vdim1", ColumnType.STRING, (Object)"1", null), (List<String>)ImmutableList.of((Object)"3"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("vdim1", ColumnType.STRING, (Object)"abdef", null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("vdim1", ColumnType.STRING, (Object)"abc", null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("vdim1", ColumnType.STRING, (Object)"noexist", null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("vs0", ColumnType.STRING, (Object)"a", null), (List<String>)ImmutableList.of((Object)"1", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("vs0", ColumnType.STRING, (Object)"b", null), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("vs0", ColumnType.STRING, (Object)"c", null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("vs0", ColumnType.STRING, (Object)"noexist", null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("vdim1", ColumnType.STRING, (Object)"10", null)), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("vdim1", ColumnType.STRING, (Object)"noexist", null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("vs0", ColumnType.STRING, (Object)"a", null)), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"4"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("vs0", ColumnType.STRING, (Object)"noexist", null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5"));
        }

        @Test
        public void testSingleValueVirtualStringColumnMissingColumnCoalesce() {
            this.assertFilterMatches((DimFilter)new EqualityFilter("fake-nvl", ColumnType.STRING, (Object)"0", null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("fake-nvl", ColumnType.STRING, (Object)"hello", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        }

        @Test
        public void testMultiValueStringColumn() {
            if (this.isAutoSchema()) {
                this.assertFilterMatches((DimFilter)new EqualityFilter("dim2", ColumnType.STRING, (Object)"", null), (List<String>)ImmutableList.of());
                this.assertFilterMatches((DimFilter)new EqualityFilter("dim2", ColumnType.STRING_ARRAY, (Object)ImmutableList.of((Object)""), null), (List<String>)ImmutableList.of((Object)"2"));
                this.assertFilterMatches((DimFilter)new EqualityFilter("dim2", ColumnType.STRING, (Object)"a", null), (List<String>)ImmutableList.of());
                this.assertFilterMatches((DimFilter)new EqualityFilter("dim2", ColumnType.STRING_ARRAY, (Object)ImmutableList.of((Object)"a"), null), (List<String>)ImmutableList.of((Object)"3"));
                this.assertFilterMatches((DimFilter)new EqualityFilter("dim2", ColumnType.STRING, (Object)"b", null), (List<String>)ImmutableList.of());
                this.assertFilterMatches((DimFilter)new EqualityFilter("dim2", ColumnType.STRING, (Object)"c", null), (List<String>)ImmutableList.of());
                this.assertFilterMatches((DimFilter)new EqualityFilter("dim2", ColumnType.STRING_ARRAY, (Object)ImmutableList.of((Object)"c"), null), (List<String>)ImmutableList.of((Object)"4"));
                this.assertFilterMatches((DimFilter)new EqualityFilter("dim2", ColumnType.STRING, (Object)"d", null), (List<String>)ImmutableList.of());
                this.assertFilterMatches((DimFilter)new EqualityFilter("dim2", ColumnType.STRING_ARRAY, (Object)new Object[]{"a", "b"}, null), (List<String>)ImmutableList.of((Object)"0"));
                this.assertFilterMatches((DimFilter)new EqualityFilter("dim2", ColumnType.STRING_ARRAY, (Object)ImmutableList.of((Object)"a", (Object)"b"), null), (List<String>)ImmutableList.of((Object)"0"));
                this.assertFilterMatches((DimFilter)new EqualityFilter("dim2", ColumnType.STRING_ARRAY, (Object)new Object[]{"a"}, null), (List<String>)ImmutableList.of((Object)"3"));
                this.assertFilterMatches((DimFilter)new EqualityFilter("dim2", ColumnType.STRING_ARRAY, (Object)new Object[]{"b"}, null), (List<String>)ImmutableList.of());
                this.assertFilterMatches((DimFilter)new EqualityFilter("dim2", ColumnType.STRING_ARRAY, (Object)new Object[]{"c"}, null), (List<String>)ImmutableList.of((Object)"4"));
                this.assertFilterMatches((DimFilter)new EqualityFilter("dim2", ColumnType.STRING_ARRAY, (Object)new Object[]{"d"}, null), (List<String>)ImmutableList.of());
            } else {
                this.assertFilterMatches((DimFilter)new EqualityFilter("dim2", ColumnType.STRING, (Object)"", null), (List<String>)ImmutableList.of((Object)"2"));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("dim2", ColumnType.STRING, (Object)"", null)), (List<String>)ImmutableList.of((Object)"0", (Object)"3", (Object)"4"));
                this.assertFilterMatches((DimFilter)new EqualityFilter("dim2", ColumnType.STRING, (Object)"a", null), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("dim2", ColumnType.STRING, (Object)"a", null)), (List<String>)ImmutableList.of((Object)"2", (Object)"4"));
                this.assertFilterMatches((DimFilter)new EqualityFilter("dim2", ColumnType.STRING, (Object)"b", null), (List<String>)ImmutableList.of((Object)"0"));
                this.assertFilterMatches((DimFilter)new EqualityFilter("dim2", ColumnType.STRING, (Object)"c", null), (List<String>)ImmutableList.of((Object)"4"));
                this.assertFilterMatches((DimFilter)new EqualityFilter("dim2", ColumnType.STRING, (Object)"d", null), (List<String>)ImmutableList.of());
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("dim2", ColumnType.STRING, (Object)"d", null)), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4"));
            }
            this.assertFilterMatchesSkipVectorize((DimFilter)new EqualityFilter("vdim2-offset", ColumnType.STRING, (Object)"b", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatchesSkipVectorize((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("vdim2-offset", ColumnType.STRING, (Object)"b", null)), (List<String>)ImmutableList.of());
        }

        @Test
        public void testMissingColumnSpecifiedInDimensionList() {
            this.assertFilterMatches((DimFilter)new EqualityFilter("dim3", ColumnType.STRING, (Object)"", null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("dim3", ColumnType.STRING, (Object)"a", null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("dim3", ColumnType.STRING, (Object)"b", null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("dim3", ColumnType.STRING, (Object)"c", null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("dim3", ColumnType.STRING, (Object)"c", null)), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("vdim3-concat", ColumnType.STRING, (Object)"1", null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("vdim3-concat", ColumnType.STRING, (Object)"1", null)), (List<String>)ImmutableList.of());
        }

        @Test
        public void testMissingColumnNotSpecifiedInDimensionList() {
            this.assertFilterMatches((DimFilter)new EqualityFilter("dim4", ColumnType.STRING, (Object)"", null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("dim4", ColumnType.STRING, (Object)"a", null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("dim4", ColumnType.STRING, (Object)"b", null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("dim4", ColumnType.STRING, (Object)"c", null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("dim4", ColumnType.STRING, (Object)"c", null)), (List<String>)ImmutableList.of());
        }

        @Test
        public void testExpressionVirtualColumn() {
            this.assertFilterMatches((DimFilter)new EqualityFilter("expr", ColumnType.STRING, (Object)"1.1", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("expr", ColumnType.STRING, (Object)"1.1", null)), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("expr", ColumnType.STRING, (Object)"1.2", null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("expr", ColumnType.FLOAT, (Object)Float.valueOf(1.1f), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("expr", ColumnType.FLOAT, (Object)Float.valueOf(1.2f), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("expr", ColumnType.DOUBLE, (Object)1.1, null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("expr", ColumnType.DOUBLE, (Object)1.2, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("expr", ColumnType.DOUBLE, (Object)"1.1", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("expr", ColumnType.DOUBLE, (Object)"1.2", null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("expr", ColumnType.DOUBLE, (Object)"1.2", null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        }

        @Test
        public void testNumericColumnNullsAndDefaults() {
            this.assertFilterMatches((DimFilter)new EqualityFilter("f0", ColumnType.FLOAT, (Object)Float.valueOf(0.0f), null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("f0", ColumnType.FLOAT, (Object)Float.valueOf(0.0f), null)), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("d0", ColumnType.DOUBLE, (Object)0.0, null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("d0", ColumnType.DOUBLE, (Object)0.0, null)), (List<String>)ImmutableList.of((Object)"1", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("l0", ColumnType.LONG, (Object)0L, null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("l0", ColumnType.LONG, (Object)0L, null)), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("f0", ColumnType.STRING, (Object)"0", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("d0", ColumnType.STRING, (Object)"0", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("l0", ColumnType.STRING, (Object)"0", null), (List<String>)ImmutableList.of((Object)"0"));
        }

        @Test
        public void testVirtualNumericColumnNullsAndDefaults() {
            this.assertFilterMatches((DimFilter)new EqualityFilter("vf0", ColumnType.FLOAT, (Object)Float.valueOf(0.0f), null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("vf0", ColumnType.FLOAT, (Object)Float.valueOf(0.0f), null)), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("vd0", ColumnType.DOUBLE, (Object)0.0, null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("vd0", ColumnType.DOUBLE, (Object)0.0, null)), (List<String>)ImmutableList.of((Object)"1", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("vl0", ColumnType.LONG, (Object)0L, null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("vl0", ColumnType.LONG, (Object)0L, null)), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("vf0", ColumnType.STRING, (Object)"0", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("vd0", ColumnType.STRING, (Object)"0", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("vl0", ColumnType.STRING, (Object)"0", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("vf0-add-sub", ColumnType.FLOAT, (Object)Float.valueOf(0.0f), null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("vf0-add-sub", ColumnType.FLOAT, (Object)Float.valueOf(0.0f), null)), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("vd0-add-sub", ColumnType.DOUBLE, (Object)0.0, null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("vd0-add-sub", ColumnType.DOUBLE, (Object)0.0, null)), (List<String>)ImmutableList.of((Object)"1", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("vl0-add-sub", ColumnType.LONG, (Object)0L, null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("vl0-add-sub", ColumnType.LONG, (Object)0L, null)), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("vf0-add-sub", ColumnType.STRING, (Object)"0", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("vd0-add-sub", ColumnType.STRING, (Object)"0", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("vl0-add-sub", ColumnType.STRING, (Object)"0", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("double-vf0-add-sub", ColumnType.FLOAT, (Object)Float.valueOf(0.0f), null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("double-vf0-add-sub", ColumnType.FLOAT, (Object)Float.valueOf(0.0f), null)), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("double-vd0-add-sub", ColumnType.DOUBLE, (Object)0.0, null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("double-vd0-add-sub", ColumnType.DOUBLE, (Object)0.0, null)), (List<String>)ImmutableList.of((Object)"1", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("double-vl0-add-sub", ColumnType.LONG, (Object)0L, null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("double-vl0-add-sub", ColumnType.LONG, (Object)0L, null)), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("double-vf0-add-sub", ColumnType.STRING, (Object)"0", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("double-vd0-add-sub", ColumnType.STRING, (Object)"0", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("double-vl0-add-sub", ColumnType.STRING, (Object)"0", null), (List<String>)ImmutableList.of((Object)"0"));
        }

        @Test
        public void testNumeric() {
            this.assertFilterMatches((DimFilter)new EqualityFilter("d0", ColumnType.DOUBLE, (Object)10.1, null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("d0", ColumnType.DOUBLE, (Object)120.0245, null), (List<String>)ImmutableList.of((Object)"3"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("d0", ColumnType.DOUBLE, (Object)765.432, null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("d0", ColumnType.DOUBLE, (Object)765.431, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("d0", ColumnType.LONG, (Object)0L, null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("d0", ColumnType.LONG, (Object)60L, null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("l0", ColumnType.LONG, (Object)100L, null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("l0", ColumnType.LONG, (Object)40L, null), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("l0", ColumnType.LONG, (Object)9001L, null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("l0", ColumnType.LONG, (Object)9000L, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("l0", ColumnType.DOUBLE, (Object)100.1, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("l0", ColumnType.DOUBLE, (Object)100.0, null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("l0", ColumnType.DOUBLE, (Object)40.1, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("l0", ColumnType.DOUBLE, (Object)40.0, null), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("l0", ColumnType.DOUBLE, (Object)9001.1, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("l0", ColumnType.DOUBLE, (Object)9001.0, null), (List<String>)ImmutableList.of((Object)"4"));
            if (!this.isAutoSchema()) {
                this.assertFilterMatches((DimFilter)new EqualityFilter("f0", ColumnType.FLOAT, (Object)Float.valueOf(10.1f), null), (List<String>)ImmutableList.of((Object)"1"));
                this.assertFilterMatches((DimFilter)new EqualityFilter("f0", ColumnType.FLOAT, (Object)Float.valueOf(110.0f), null), (List<String>)ImmutableList.of((Object)"3"));
                this.assertFilterMatches((DimFilter)new EqualityFilter("f0", ColumnType.FLOAT, (Object)Float.valueOf(123.45f), null), (List<String>)ImmutableList.of((Object)"5"));
                this.assertFilterMatches((DimFilter)new EqualityFilter("f0", ColumnType.FLOAT, (Object)Float.valueOf(123.46f), null), (List<String>)ImmutableList.of());
            } else {
                this.assertFilterMatches((DimFilter)new EqualityFilter("f0", ColumnType.DOUBLE, (Object)10.1f, null), (List<String>)ImmutableList.of((Object)"1"));
                this.assertFilterMatches((DimFilter)new EqualityFilter("f0", ColumnType.DOUBLE, (Object)110.0, null), (List<String>)ImmutableList.of((Object)"3"));
                this.assertFilterMatches((DimFilter)new EqualityFilter("f0", ColumnType.DOUBLE, (Object)123.45f, null), (List<String>)ImmutableList.of((Object)"5"));
                this.assertFilterMatches((DimFilter)new EqualityFilter("f0", ColumnType.DOUBLE, (Object)123.46f, null), (List<String>)ImmutableList.of());
            }
        }

        @Test
        public void testArrays() {
            Assume.assumeTrue((boolean)this.canTestArrayColumns());
            this.assertFilterMatches((DimFilter)new EqualityFilter("arrayString", ColumnType.STRING_ARRAY, (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), null), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("arrayString", ColumnType.STRING_ARRAY, (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), null)), (List<String>)ImmutableList.of((Object)"1", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("arrayString", ColumnType.STRING_ARRAY, (Object)new Object[]{"a", "b", "c"}, null), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("arrayString", ColumnType.STRING_ARRAY, (Object)ImmutableList.of(), null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("arrayString", ColumnType.STRING_ARRAY, (Object)new Object[]{null}, null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("arrayString", ColumnType.STRING_ARRAY, (Object)new Object[]{null, null}, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("arrayString", ColumnType.STRING_ARRAY, (Object)new Object[]{null, null}, null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("arrayLong", ColumnType.LONG_ARRAY, (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("arrayLong", ColumnType.LONG_ARRAY, (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), null)), (List<String>)ImmutableList.of((Object)"1", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("arrayLong", ColumnType.LONG_ARRAY, (Object)new Object[]{1L, 2L, 3L}, null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("arrayLong", ColumnType.LONG_ARRAY, (Object)ImmutableList.of(), null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("arrayLong", ColumnType.LONG_ARRAY, (Object)new Object[]{null}, null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("arrayLong", ColumnType.LONG_ARRAY, (Object)new Object[]{null, null}, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("arrayLong", ColumnType.LONG_ARRAY, (Object)new Object[]{null, null}, null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.0, 2.0, 3.0}, null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.1, 2.2, 3.3}, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{null}, null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("arrayDouble", ColumnType.DOUBLE_ARRAY, (Object)ImmutableList.of((Object)1.1, (Object)2.2, (Object)3.3), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("arrayDouble", ColumnType.DOUBLE_ARRAY, (Object)ImmutableList.of((Object)1.1, (Object)2.2, (Object)3.3), null)), (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"4"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("arrayDouble", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.1, 2.2, 3.3}, null), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("arrayDouble", ColumnType.DOUBLE_ARRAY, (Object)ImmutableList.of(), null), (List<String>)ImmutableList.of((Object)"3"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("arrayDouble", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{null}, null), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("arrayDouble", ColumnType.DOUBLE_ARRAY, (Object)ImmutableList.of((Object)1.1, (Object)2.2, (Object)3.4), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("arrayDouble", ColumnType.DOUBLE_ARRAY, (Object)ImmutableList.of((Object)1.1, (Object)2.2, (Object)3.4), null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4"));
        }

        @Test
        public void testVariant() {
            Assume.assumeTrue((boolean)this.isAutoSchema());
            this.assertFilterMatches((DimFilter)new EqualityFilter("variant", ColumnType.STRING_ARRAY, (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("variant", ColumnType.STRING_ARRAY, (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("variant", ColumnType.STRING, (Object)"abc", null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("variant", ColumnType.STRING_ARRAY, (Object)ImmutableList.of((Object)"abc"), null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("variant", ColumnType.LONG, (Object)100L, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("variant", ColumnType.LONG_ARRAY, (Object)ImmutableList.of((Object)100L), null), (List<String>)ImmutableList.of((Object)"1", (Object)"2"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("variant", ColumnType.STRING, (Object)"100", null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("variant", ColumnType.STRING_ARRAY, (Object)new Object[]{"100"}, null), (List<String>)ImmutableList.of((Object)"1", (Object)"2"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("variant", ColumnType.LONG_ARRAY, Arrays.asList(100, 200, 300), null), (List<String>)ImmutableList.of((Object)"5"));
        }

        @Test
        public void testNestedColumnEquality() {
            Assume.assumeTrue((boolean)this.canTestArrayColumns());
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.s0", ColumnType.STRING, (Object)"", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("nested.s0", ColumnType.STRING, (Object)"", null)), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.s0", ColumnType.STRING, (Object)"a", null), (List<String>)ImmutableList.of((Object)"1", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.s0", ColumnType.STRING, (Object)"b", null), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.s0", ColumnType.STRING, (Object)"c", null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.s0", ColumnType.STRING, (Object)"noexist", null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("nested.s0", ColumnType.STRING, (Object)"a", null)), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"4"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)IsTrueDimFilter.of((DimFilter)new EqualityFilter("nested.s0", ColumnType.STRING, (Object)"a", null))), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4"));
            this.assertFilterMatches((DimFilter)IsTrueDimFilter.of((DimFilter)new EqualityFilter("nested.s0", ColumnType.STRING, (Object)"a", null)), (List<String>)ImmutableList.of((Object)"1", (Object)"5"));
            this.assertFilterMatches((DimFilter)IsFalseDimFilter.of((DimFilter)new EqualityFilter("nested.s0", ColumnType.STRING, (Object)"a", null)), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"4"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)IsFalseDimFilter.of((DimFilter)new EqualityFilter("nested.s0", ColumnType.STRING, (Object)"a", null))), (List<String>)ImmutableList.of((Object)"1", (Object)"3", (Object)"5"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("nested.s0", ColumnType.STRING, (Object)"noexist", null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.d0", ColumnType.DOUBLE, (Object)0.0, null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("nested.d0", ColumnType.DOUBLE, (Object)0.0, null)), (List<String>)ImmutableList.of((Object)"1", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.l0", ColumnType.LONG, (Object)0L, null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("nested.l0", ColumnType.LONG, (Object)0L, null)), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.l0", ColumnType.STRING, (Object)"0", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.l0", ColumnType.STRING, (Object)"0", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.d0", ColumnType.DOUBLE, (Object)10.1, null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.d0", ColumnType.DOUBLE, (Object)120.0245, null), (List<String>)ImmutableList.of((Object)"3"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.d0", ColumnType.DOUBLE, (Object)765.432, null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.d0", ColumnType.DOUBLE, (Object)765.431, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.d0", ColumnType.LONG, (Object)0L, null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("d0", ColumnType.LONG, (Object)60L, null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.l0", ColumnType.LONG, (Object)100L, null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.l0", ColumnType.LONG, (Object)40L, null), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.l0", ColumnType.LONG, (Object)9001L, null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.l0", ColumnType.LONG, (Object)9000L, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.l0", ColumnType.DOUBLE, (Object)100.1, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.l0", ColumnType.DOUBLE, (Object)100.0, null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.l0", ColumnType.DOUBLE, (Object)40.1, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.l0", ColumnType.DOUBLE, (Object)40.0, null), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.l0", ColumnType.DOUBLE, (Object)9001.1, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.l0", ColumnType.DOUBLE, (Object)9001.0, null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.arrayString", ColumnType.STRING_ARRAY, (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), null), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("nested.arrayString", ColumnType.STRING_ARRAY, (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), null)), (List<String>)ImmutableList.of((Object)"1", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.arrayString", ColumnType.STRING_ARRAY, (Object)new Object[]{"a", "b", "c"}, null), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.arrayString", ColumnType.STRING_ARRAY, (Object)ImmutableList.of(), null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.arrayString", ColumnType.STRING_ARRAY, (Object)new Object[]{null}, null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.arrayString", ColumnType.STRING_ARRAY, (Object)new Object[]{null, null}, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("nested.arrayString", ColumnType.STRING_ARRAY, (Object)new Object[]{null, null}, null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.arrayLong", ColumnType.LONG_ARRAY, (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("nested.arrayLong", ColumnType.LONG_ARRAY, (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), null)), (List<String>)ImmutableList.of((Object)"1", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.arrayLong", ColumnType.LONG_ARRAY, (Object)new Object[]{1L, 2L, 3L}, null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.arrayLong", ColumnType.LONG_ARRAY, (Object)ImmutableList.of(), null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.arrayLong", ColumnType.LONG_ARRAY, (Object)new Object[]{null}, null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.arrayLong", ColumnType.LONG_ARRAY, (Object)new Object[]{null, null}, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("nested.arrayLong", ColumnType.LONG_ARRAY, (Object)new Object[]{null, null}, null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.0, 2.0, 3.0}, null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.1, 2.2, 3.3}, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{null}, null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.arrayDouble", ColumnType.DOUBLE_ARRAY, (Object)ImmutableList.of((Object)1.1, (Object)2.2, (Object)3.3), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("nested.arrayDouble", ColumnType.DOUBLE_ARRAY, (Object)ImmutableList.of((Object)1.1, (Object)2.2, (Object)3.3), null)), (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"4"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.arrayDouble", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.1, 2.2, 3.3}, null), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.arrayDouble", ColumnType.DOUBLE_ARRAY, (Object)ImmutableList.of(), null), (List<String>)ImmutableList.of((Object)"3"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.arrayDouble", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{null}, null), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new EqualityFilter("nested.arrayDouble", ColumnType.DOUBLE_ARRAY, (Object)ImmutableList.of((Object)1.1, (Object)2.2, (Object)3.4), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("nested.arrayDouble", ColumnType.DOUBLE_ARRAY, (Object)ImmutableList.of((Object)1.1, (Object)2.2, (Object)3.4), null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4"));
        }

        @Test
        public void testArraysAsMvds() {
            Assume.assumeTrue((boolean)this.canTestArrayColumns());
            this.assertFilterMatchesSkipVectorizeUnlessFallback((DimFilter)new EqualityFilter("arrayStringAsMvd", ColumnType.STRING, (Object)"b", null), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
            this.assertFilterMatchesSkipVectorizeUnlessFallback((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("arrayStringAsMvd", ColumnType.STRING, (Object)"b", null)), (List<String>)ImmutableList.of((Object)"1", (Object)"4"));
            this.assertFilterMatchesSkipVectorizeUnlessFallback((DimFilter)new EqualityFilter("arrayLongAsMvd", ColumnType.STRING, (Object)"2", null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
            this.assertFilterMatchesSkipVectorizeUnlessFallback((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("arrayLongAsMvd", ColumnType.STRING, (Object)"2", null)), (List<String>)ImmutableList.of((Object)"1", (Object)"5"));
            this.assertFilterMatchesSkipVectorizeUnlessFallback((DimFilter)new EqualityFilter("arrayDoubleAsMvd", ColumnType.STRING, (Object)"3.3", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
            this.assertFilterMatchesSkipVectorizeUnlessFallback((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("arrayDoubleAsMvd", ColumnType.STRING, (Object)"3.3", null)), (List<String>)ImmutableList.of((Object)"3", (Object)"4"));
            this.assertFilterMatchesSkipVectorizeUnlessFallback((DimFilter)new EqualityFilter("arrayConstantAsMvd", ColumnType.STRING, (Object)"3", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        }
    }
}

