/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.ExpressionDimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.filter.BaseFilterTest;
import org.apache.druid.segment.filter.ExpressionFilter;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ExpressionFilterTest
extends BaseFilterTest {
    private static final String TIMESTAMP_COLUMN = "timestamp";
    private static final InputRowParser<Map<String, Object>> PARSER = new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("timestamp", "iso", DateTimes.of((String)"2000")), new DimensionsSpec((List)ImmutableList.of((Object)new StringDimensionSchema("dim0"), (Object)new LongDimensionSchema("dim1"), (Object)new FloatDimensionSchema("dim2"), (Object)new StringDimensionSchema("dim3"), (Object)new StringDimensionSchema("dim4"), (Object)new StringDimensionSchema("dim5")))));
    private static final RowSignature ROW_SIGNATURE = RowSignature.builder().add("dim0", ColumnType.STRING).add("dim1", ColumnType.LONG).add("dim2", ColumnType.FLOAT).add("dim3", ColumnType.STRING).add("dim4", ColumnType.STRING).add("dim5", ColumnType.STRING).build();
    private static final List<InputRow> ROWS = ImmutableList.of((Object)ExpressionFilterTest.makeSchemaRow(PARSER, ROW_SIGNATURE, "0", 0L, Float.valueOf(0.0f), "", ImmutableList.of((Object)"1", (Object)"2"), "a"), (Object)ExpressionFilterTest.makeSchemaRow(PARSER, ROW_SIGNATURE, "1", 1L, Float.valueOf(1.0f), "10", ImmutableList.of(), "b"), (Object)ExpressionFilterTest.makeSchemaRow(PARSER, ROW_SIGNATURE, "2", 2L, Float.valueOf(2.0f), "2", ImmutableList.of((Object)""), null), (Object)ExpressionFilterTest.makeSchemaRow(PARSER, ROW_SIGNATURE, "3", 3L, Float.valueOf(3.0f), "1", ImmutableList.of((Object)"3"), "c"), (Object)ExpressionFilterTest.makeSchemaRow(PARSER, ROW_SIGNATURE, "4", 4L, Float.valueOf(4.0f), "1", ImmutableList.of((Object)"4", (Object)"5"), ""), (Object)ExpressionFilterTest.makeSchemaRow(PARSER, ROW_SIGNATURE, "5", 5L, Float.valueOf(5.0f), "5", ImmutableList.of((Object)"4", (Object)"5"), "d"), (Object)ExpressionFilterTest.makeSchemaRow(PARSER, ROW_SIGNATURE, "6", 6L, Float.valueOf(6.0f), "1", null, "e"), (Object)ExpressionFilterTest.makeSchemaRow(PARSER, ROW_SIGNATURE, "7", 7L, Float.valueOf(7.0f), "a", null, "f"), (Object)ExpressionFilterTest.makeSchemaRow(PARSER, ROW_SIGNATURE, "8", 8L, Float.valueOf(8.0f), 8L, null, "g"), (Object)ExpressionFilterTest.makeSchemaRow(PARSER, ROW_SIGNATURE, "9", 9L, Float.valueOf(9.0f), 1.234, 1.234, null));

    public ExpressionFilterTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<CursorFactory, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, ROWS, indexBuilder.schema(new IncrementalIndexSchema.Builder().withDimensionsSpec(PARSER.getParseSpec().getDimensionsSpec()).build()), finisher, cnf, optimize);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(ExpressionFilterTest.class.getName());
    }

    @Test
    public void testOneSingleValuedStringColumn() {
        if (this.testName.contains("incrementalAutoTypes")) {
            return;
        }
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim3 == ''"), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim3 == '1'"), (List<String>)ImmutableList.of((Object)"3", (Object)"4", (Object)"6"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim3 == 'a'"), (List<String>)ImmutableList.of((Object)"7"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim3 == 1"), (List<String>)ImmutableList.of((Object)"3", (Object)"4", (Object)"6"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim3 == 1.0"), (List<String>)ImmutableList.of((Object)"3", (Object)"4", (Object)"6"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim3 == 1.234"), (List<String>)ImmutableList.of((Object)"9"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim3 < '2'"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"3", (Object)"4", (Object)"6", (Object)"9"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim3 < 2"), (List<String>)ImmutableList.of((Object)"3", (Object)"4", (Object)"6", (Object)"9"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim3 < 2.0"), (List<String>)ImmutableList.of((Object)"3", (Object)"4", (Object)"6", (Object)"9"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("like(dim3, '1%')"), (List<String>)ImmutableList.of((Object)"1", (Object)"3", (Object)"4", (Object)"6", (Object)"9"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("array_contains(dim3, '1')"), (List<String>)ImmutableList.of((Object)"3", (Object)"4", (Object)"6"));
    }

    @Test
    public void testComplement() {
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim5 == 'a'"), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)ExpressionFilterTest.edf("dim5 == 'a'")), (List<String>)ImmutableList.of((Object)"1", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim5 == ''"), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)ExpressionFilterTest.edf("dim5 == ''")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"3", (Object)"5", (Object)"6", (Object)"7", (Object)"8"));
    }

    @Test
    public void testOneMultiValuedStringColumn() {
        if (this.isAutoSchema()) {
            return;
        }
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("dim4 == ''"), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("dim4 == null"), (List<String>)ImmutableList.of());
        if (this.hasTypeInformation()) {
            this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("isnull(dim4)"), (List<String>)ImmutableList.of((Object)"1", (Object)"6", (Object)"7", (Object)"8"));
            this.assertFilterMatchesSkipVectorize((DimFilter)NotDimFilter.of((DimFilter)ExpressionFilterTest.edf("isnull(dim4)")), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"9"));
            this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("cast(dim4, 'LONG')"), (List<String>)ImmutableList.of((Object)"0", (Object)"3", (Object)"4", (Object)"5", (Object)"9"));
            this.assertFilterMatchesSkipVectorize((DimFilter)NotDimFilter.of((DimFilter)ExpressionFilterTest.edf("cast(dim4, 'LONG')")), (List<String>)ImmutableList.of());
            this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("cast(dim4, 'STRING')"), (List<String>)ImmutableList.of());
            this.assertFilterMatchesSkipVectorize((DimFilter)NotDimFilter.of((DimFilter)ExpressionFilterTest.edf("cast(dim4, 'STRING')")), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"9"));
            this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("cast(dim4, 'DOUBLE')"), (List<String>)ImmutableList.of((Object)"0", (Object)"3", (Object)"4", (Object)"5", (Object)"9"));
            this.assertFilterMatchesSkipVectorize((DimFilter)NotDimFilter.of((DimFilter)ExpressionFilterTest.edf("cast(dim4, 'DOUBLE')")), (List<String>)ImmutableList.of());
        }
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("dim4 == '1'"), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("dim4 == '3'"), (List<String>)ImmutableList.of((Object)"3"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("dim4 == '4'"), (List<String>)ImmutableList.of((Object)"4", (Object)"5"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("concat(dim4, dim4) == '33'"), (List<String>)ImmutableList.of((Object)"3"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("like(dim4, '4%')"), (List<String>)ImmutableList.of((Object)"4", (Object)"5"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("array_contains(dim4, '5')"), (List<String>)ImmutableList.of((Object)"4", (Object)"5"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("array_to_string(dim4, ':') == '4:5'"), (List<String>)ImmutableList.of((Object)"4", (Object)"5"));
    }

    @Test
    public void testSingleAndMultiValuedStringColumn() {
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("array_contains(dim4, dim3)"), (List<String>)ImmutableList.of((Object)"5", (Object)"9"));
    }

    @Test
    public void testMvOverlap() {
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("mv_overlap(dim4, '1')"), List.of("0"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("mv_overlap(dim4, '4')"), List.of("4", "5"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("mv_overlap(dim4, array(1, 2, 3, 4))"), List.of("0", "3", "4", "5"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("mv_overlap(dim4, dim3)"), List.of("5", "9"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("mv_overlap(dim4, null)"), List.of("1", "6", "7", "8"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("mv_overlap(dim4, [])"), List.of());
    }

    @Test
    public void testOneLongColumn() {
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim1 == ''"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim1 == '1'"), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim1 == 2"), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim1 < '2'"), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim1 < 2"), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim1 < 2.0"), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("like(dim1, '1%')"), (List<String>)ImmutableList.of((Object)"1"));
    }

    @Test
    public void testOneFloatColumn() {
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim2 == ''"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim2 == '1'"), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim2 == 2"), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim2 < '2'"), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim2 < 2"), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim2 < 2.0"), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("like(dim2, '1%')"), (List<String>)ImmutableList.of((Object)"1"));
    }

    @Test
    public void testConstantExpression() {
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("1 + 1"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("'true'"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("0 + 0"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("'false'"), (List<String>)ImmutableList.of());
    }

    @Test
    public void testCompareColumns() {
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim0 == dim3"), (List<String>)ImmutableList.of((Object)"2", (Object)"5", (Object)"8"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim1 == dim3"), (List<String>)ImmutableList.of((Object)"2", (Object)"5", (Object)"8"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim2 == dim3"), (List<String>)ImmutableList.of((Object)"2", (Object)"5", (Object)"8"));
        if (this.isAutoSchema()) {
            return;
        }
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("dim0 == dim4"), (List<String>)ImmutableList.of((Object)"3", (Object)"4", (Object)"5"));
    }

    @Test
    public void testNullNotUnknown() {
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("isfalse(dim5)"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("!isfalse(dim5)"), (List<String>)ImmutableList.of((Object)"2", (Object)"9"));
        this.assertFilterMatchesSkipVectorize((DimFilter)NotDimFilter.of((DimFilter)ExpressionFilterTest.edf("isfalse(dim5)")), (List<String>)ImmutableList.of((Object)"2", (Object)"9"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("isfalse(notexist)"), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("!isfalse(notexist)"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatchesSkipVectorize((DimFilter)NotDimFilter.of((DimFilter)ExpressionFilterTest.edf("isfalse(notexist)")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
    }

    @Test
    public void testMissingColumn() {
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing == null"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)ExpressionFilterTest.edf("missing == null")), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing == otherMissing"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)ExpressionFilterTest.edf("missing == otherMissing")), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing == '1'"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing == 2"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing < '2'"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing < 2"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing < 2.0"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing > '2'"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing > 2"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing > 2.0"), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("like(missing, '1%')"), (List<String>)ImmutableList.of());
    }

    @Test
    public void testGetRequiredColumn() {
        Assert.assertEquals((Object)ExpressionFilterTest.edf("like(dim1, '1%')").getRequiredColumns(), (Object)Sets.newHashSet((Object[])new String[]{"dim1"}));
        Assert.assertEquals((Object)ExpressionFilterTest.edf("dim2 == '1'").getRequiredColumns(), (Object)Sets.newHashSet((Object[])new String[]{"dim2"}));
        Assert.assertEquals((Object)ExpressionFilterTest.edf("dim3 < '2'").getRequiredColumns(), (Object)Sets.newHashSet((Object[])new String[]{"dim3"}));
        Assert.assertEquals((Object)ExpressionFilterTest.edf("dim4 == ''").getRequiredColumns(), (Object)Sets.newHashSet((Object[])new String[]{"dim4"}));
        Assert.assertEquals((Object)ExpressionFilterTest.edf("1 + 1").getRequiredColumns(), new HashSet());
        Assert.assertEquals((Object)ExpressionFilterTest.edf("dim0 == dim3").getRequiredColumns(), (Object)Sets.newHashSet((Object[])new String[]{"dim0", "dim3"}));
        Assert.assertEquals((Object)ExpressionFilterTest.edf("missing == ''").getRequiredColumns(), (Object)Sets.newHashSet((Object[])new String[]{"missing"}));
    }

    @Test
    public void testEqualsContract() {
        EqualsVerifier.forClass(ExpressionFilter.class).withIgnoredFields(new String[]{"bindingDetails"}).usingGetClass().verify();
    }

    @Test
    public void testRequiredColumnRewrite() {
        Filter filter = ExpressionFilterTest.edf("dim1 == '1'").toFilter();
        Assert.assertFalse((boolean)filter.supportsRequiredColumnRewrite());
        Throwable t = Assert.assertThrows(UnsupportedOperationException.class, () -> filter.rewriteRequiredColumns((Map)ImmutableMap.of((Object)"invalidName", (Object)"dim1")));
        Assert.assertEquals((Object)"Required column rewrite is not supported by this filter.", (Object)t.getMessage());
    }

    protected static ExpressionDimFilter edf(String expression) {
        return new ExpressionDimFilter(expression, null, TestExprMacroTable.INSTANCE);
    }
}

