/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.collect.ImmutableList;
import java.util.List;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.DefaultBitmapResultFactory;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterBundle;
import org.apache.druid.query.filter.LikeDimFilter;
import org.apache.druid.query.filter.NullFilter;
import org.apache.druid.query.filter.TypedInFilter;
import org.apache.druid.segment.ColumnCache;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.filter.NotFilter;
import org.apache.druid.segment.filter.OrFilter;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class FilterBundleTest
extends InitializedNullHandlingTest {
    private Closer closer;
    protected BitmapFactory bitmapFactory;
    protected ColumnIndexSelector indexSelector;
    @Rule
    public TemporaryFolder tmpDir = new TemporaryFolder();

    @Before
    public void setUp() {
        QueryableIndex index = TestIndex.getMMappedWikipediaIndex();
        this.closer = Closer.create();
        this.bitmapFactory = index.getBitmapFactoryForDimensions();
        this.indexSelector = new ColumnCache(index, VirtualColumns.EMPTY, this.closer);
    }

    @After
    public void tearDown() throws Exception {
        this.closer.close();
        this.indexSelector = null;
    }

    @Test
    @Parameters(value={"true", "false"})
    public void test_or_country_isRobot(boolean cursorAutoArrangeFilters) {
        FilterBundle filterBundle = this.makeFilterBundle((Filter)new OrFilter((List)ImmutableList.of((Object)new EqualityFilter("countryName", ColumnType.STRING, (Object)"United States", null), (Object)new EqualityFilter("isRobot", ColumnType.STRING, (Object)"true", null))), cursorAutoArrangeFilters);
        Assert.assertEquals((Object)"index: OR (selectionSize = 39244)\n  index: countryName = United States (selectionSize = 528)\n  index: isRobot = true (selectionSize = 15420)\n", (Object)filterBundle.getInfo().describe());
    }

    @Test
    @Parameters(value={"true", "false"})
    public void test_and_country_isRobot(boolean cursorAutoArrangeFilters) {
        FilterBundle filterBundle = this.makeFilterBundle((Filter)new AndFilter((List)ImmutableList.of((Object)new EqualityFilter("countryName", ColumnType.STRING, (Object)"United States", null), (Object)new EqualityFilter("isRobot", ColumnType.STRING, (Object)"true", null))), cursorAutoArrangeFilters);
        Assert.assertEquals((Object)"index: AND (selectionSize = 0)\n  index: countryName = United States (selectionSize = 528)\n  index: isRobot = true (selectionSize = 15420)\n", (Object)filterBundle.getInfo().describe());
    }

    @Test
    @Parameters(value={"true", "false"})
    public void test_or_countryIsNull_pageLike(boolean cursorAutoArrangeFilters) {
        FilterBundle filterBundle = this.makeFilterBundle((Filter)new OrFilter((List)ImmutableList.of((Object)new NullFilter("countryName", null), (Object)new LikeDimFilter("page", "%u%", null, null).toFilter())), cursorAutoArrangeFilters);
        Assert.assertEquals((Object)"matcher: OR\n  matcher: countryName IS NULL\n    with partial index: countryName IS NULL (selectionSize = 35445)\n  matcher: page LIKE '%u%'\n", (Object)filterBundle.getInfo().describe());
    }

    @Test
    @Parameters(value={"true", "false"})
    public void test_and_countryIsNull_pageLike(boolean cursorAutoArrangeFilters) {
        FilterBundle filterBundle = this.makeFilterBundle((Filter)new AndFilter((List)ImmutableList.of((Object)new NullFilter("countryName", null), (Object)new LikeDimFilter("page", "%u%", null, null).toFilter())), cursorAutoArrangeFilters);
        Assert.assertEquals((Object)"index: AND (selectionSize = 14165)\n  index: countryName IS NULL (selectionSize = 35445)\n  index: page LIKE '%u%' (selectionSize = 15328)\n", (Object)filterBundle.getInfo().describe());
    }

    @Test
    @Parameters(value={"true", "false"})
    public void test_and_country_pageLike(boolean cursorAutoArrangeFilters) {
        FilterBundle filterBundle = this.makeFilterBundle((Filter)new AndFilter((List)ImmutableList.of((Object)new EqualityFilter("countryName", ColumnType.STRING, (Object)"United States", null), (Object)new LikeDimFilter("page", "%u%", null, null).toFilter())), cursorAutoArrangeFilters);
        Assert.assertEquals((Object)"index: countryName = United States (selectionSize = 528)\nmatcher: page LIKE '%u%'\n", (Object)filterBundle.getInfo().describe());
    }

    @Test
    @Parameters(value={"true"})
    public void test_pageLike_and_country_pageLike_with_cursorAutoArrangeFilters(boolean cursorAutoArrangeFilters) {
        FilterBundle filterBundle = this.makeFilterBundle((Filter)new AndFilter((List)ImmutableList.of((Object)new LikeDimFilter("page", "%u%", null, null).toFilter(), (Object)new EqualityFilter("countryName", ColumnType.STRING, (Object)"United States", null))), cursorAutoArrangeFilters);
        Assert.assertEquals((Object)"index: countryName = United States (selectionSize = 528)\nmatcher: page LIKE '%u%'\n", (Object)filterBundle.getInfo().describe());
    }

    @Test
    @Parameters(value={"true", "false"})
    public void test_or_countryNotNull_pageLike(boolean cursorAutoArrangeFilters) {
        FilterBundle filterBundle = this.makeFilterBundle((Filter)new OrFilter((List)ImmutableList.of((Object)new NotFilter((Filter)new NullFilter("countryName", null)), (Object)new LikeDimFilter("page", "%u%", null, null).toFilter())), cursorAutoArrangeFilters);
        Assert.assertEquals((Object)"index: OR (selectionSize = 39244)\n  index: ~(countryName IS NULL) (selectionSize = 3799)\n  index: page LIKE '%u%' (selectionSize = 15328)\n", (Object)filterBundle.getInfo().describe());
    }

    @Test
    @Parameters(value={"true"})
    public void test_or_pageLike_countryNotNull_pageLike_with_cursorAutoArrangeFilters(boolean cursorAutoArrangeFilters) {
        FilterBundle filterBundle = this.makeFilterBundle((Filter)new OrFilter((List)ImmutableList.of((Object)new LikeDimFilter("page", "%u%", null, null).toFilter(), (Object)new NotFilter((Filter)new NullFilter("countryName", null)))), cursorAutoArrangeFilters);
        Assert.assertEquals((Object)"index: OR (selectionSize = 39244)\n  index: ~(countryName IS NULL) (selectionSize = 3799)\n  index: page LIKE '%u%' (selectionSize = 15328)\n", (Object)filterBundle.getInfo().describe());
    }

    @Test
    @Parameters(value={"true", "false"})
    public void test_and_countryNotNull_pageLike(boolean cursorAutoArrangeFilters) {
        FilterBundle filterBundle = this.makeFilterBundle((Filter)new AndFilter((List)ImmutableList.of((Object)new NotFilter((Filter)new NullFilter("countryName", null)), (Object)new LikeDimFilter("page", "%u%", null, null).toFilter())), cursorAutoArrangeFilters);
        Assert.assertEquals((Object)"index: ~(countryName IS NULL) (selectionSize = 3799)\nmatcher: page LIKE '%u%'\n", (Object)filterBundle.getInfo().describe());
    }

    @Test
    @Parameters(value={"true"})
    public void test_and_cursorAutoArrangeFilters(boolean cursorAutoArrangeFilters) {
        FilterBundle filterBundle = this.makeFilterBundle((Filter)new AndFilter((List)ImmutableList.of((Object)new OrFilter((List)ImmutableList.of((Object)new LikeDimFilter("page", "O%", null, null).toFilter(), (Object)new EqualityFilter("countryName", ColumnType.STRING, (Object)"United States", null))), (Object)new EqualityFilter("isRobot", ColumnType.STRING, (Object)"false", null), (Object)new NotFilter((Filter)new NullFilter("countryName", null)))), cursorAutoArrangeFilters);
        Assert.assertEquals((Object)"index: AND (selectionSize = 562)\n  index: ~(countryName IS NULL) (selectionSize = 3799)\n  index: isRobot = false (selectionSize = 23824)\n  index: OR (selectionSize = 3799)\n    index: countryName = United States (selectionSize = 528)\n    index: page LIKE 'O%' (selectionSize = 351)\n", (Object)filterBundle.getInfo().describe());
    }

    @Test
    @Parameters(value={"true"})
    public void test_or_cursorAutoArrangeFilters(boolean cursorAutoArrangeFilters) {
        FilterBundle filterBundle = this.makeFilterBundle((Filter)new OrFilter((List)ImmutableList.of((Object)new AndFilter((List)ImmutableList.of((Object)new EqualityFilter("countryName", ColumnType.STRING, (Object)"United Kingdom", null), (Object)new LikeDimFilter("page", "%b%", null, null).toFilter())), (Object)new AndFilter((List)ImmutableList.of((Object)new EqualityFilter("countryName", ColumnType.STRING, (Object)"United States", null), (Object)new LikeDimFilter("page", "O%", null, null).toFilter())), (Object)new TypedInFilter("isRobot", ColumnType.STRING, (List)ImmutableList.of((Object)"false", (Object)"true"), null, null), (Object)new EqualityFilter("channel", ColumnType.STRING, (Object)"#en.wikipedia", null), (Object)new NullFilter("countryName", null))), cursorAutoArrangeFilters);
        Assert.assertEquals((Object)"matcher: OR\n  matcher: OR\n    with partial index: OR (selectionSize = 39244)\n      index: countryName IS NULL (selectionSize = 35445)\n      index: channel = #en.wikipedia (selectionSize = 11549)\n      index: isRobot IN (false, true) (STRING) (selectionSize = 39244)\n  matcher: AND\n    with partial index: countryName = United States (selectionSize = 528)\n    matcher: page LIKE 'O%'\n  matcher: AND\n    with partial index: countryName = United Kingdom (selectionSize = 234)\n    matcher: page LIKE '%b%'\n", (Object)filterBundle.getInfo().describe());
    }

    @Test
    @Parameters(value={"true", "false"})
    public void test_or_countryIsAndPageLike(boolean cursorAutoArrangeFilters) {
        FilterBundle filterBundle = this.makeFilterBundle((Filter)new OrFilter((List)ImmutableList.of((Object)new AndFilter((List)ImmutableList.of((Object)new EqualityFilter("countryName", ColumnType.STRING, (Object)"United States", null), (Object)new LikeDimFilter("page", "%a%", null, null).toFilter())), (Object)new AndFilter((List)ImmutableList.of((Object)new EqualityFilter("countryName", ColumnType.STRING, (Object)"United Kingdom", null), (Object)new LikeDimFilter("page", "%b%", null, null).toFilter())), (Object)new AndFilter((List)ImmutableList.of((Object)new NullFilter("countryName", null), (Object)new LikeDimFilter("page", "%c%", null, null).toFilter())))), cursorAutoArrangeFilters);
        Assert.assertEquals((Object)"matcher: OR\n  matcher: AND\n    with partial index: AND (selectionSize = 11851)\n      index: countryName IS NULL (selectionSize = 35445)\n      index: page LIKE '%c%' (selectionSize = 12864)\n  matcher: AND\n    with partial index: countryName = United States (selectionSize = 528)\n    matcher: page LIKE '%a%'\n  matcher: AND\n    with partial index: countryName = United Kingdom (selectionSize = 234)\n    matcher: page LIKE '%b%'\n", (Object)filterBundle.getInfo().describe());
    }

    @Test
    @Parameters(value={"true", "false"})
    public void test_or_countryIsNull_and_country_pageLike(boolean cursorAutoArrangeFilters) {
        FilterBundle filterBundle = this.makeFilterBundle((Filter)new OrFilter((List)ImmutableList.of((Object)new NullFilter("countryName", null), (Object)new AndFilter((List)ImmutableList.of((Object)new EqualityFilter("countryName", ColumnType.STRING, (Object)"United States", null), (Object)new LikeDimFilter("page", "%a%", null, null).toFilter())))), cursorAutoArrangeFilters);
        Assert.assertEquals((Object)"matcher: OR\n  matcher: countryName IS NULL\n    with partial index: countryName IS NULL (selectionSize = 35445)\n  matcher: AND\n    with partial index: countryName = United States (selectionSize = 528)\n    matcher: page LIKE '%a%'\n", (Object)filterBundle.getInfo().describe());
    }

    @Test
    @Parameters(value={"true", "false"})
    public void test_or_countryIsNull_and_isRobotInFalseTrue_pageLike(boolean cursorAutoArrangeFilters) {
        FilterBundle filterBundle = this.makeFilterBundle((Filter)new OrFilter((List)ImmutableList.of((Object)new NullFilter("countryName", null), (Object)new AndFilter((List)ImmutableList.of((Object)new TypedInFilter("isRobot", ColumnType.STRING, (List)ImmutableList.of((Object)"false", (Object)"true"), null, null), (Object)new LikeDimFilter("page", "%u%", null, null).toFilter())))), cursorAutoArrangeFilters);
        Assert.assertEquals((Object)"matcher: OR\n  matcher: countryName IS NULL\n    with partial index: countryName IS NULL (selectionSize = 35445)\n  matcher: AND\n    with partial index: isRobot IN (false, true) (STRING) (selectionSize = 39244)\n    matcher: page LIKE '%u%'\n", (Object)filterBundle.getInfo().describe());
    }

    protected FilterBundle makeFilterBundle(Filter filter, boolean cursorAutoArrangeFilters) {
        return new FilterBundle.Builder(filter, this.indexSelector, cursorAutoArrangeFilters).build((BitmapResultFactory)new DefaultBitmapResultFactory(this.bitmapFactory), this.indexSelector.getNumRows(), this.indexSelector.getNumRows(), false);
    }
}

