/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.generator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.hash.Hashing;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.AggregateProjectionSpec;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.guice.BuiltInTypesModule;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesSerde;
import org.apache.druid.segment.BaseProgressIndicator;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.ProgressIndicator;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.generator.DataGenerator;
import org.apache.druid.segment.generator.GeneratorSchemaInfo;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.segment.transform.Transformer;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;

public class SegmentGenerator
implements Closeable {
    private static final Logger log = new Logger(SegmentGenerator.class);
    private static final int MAX_ROWS_IN_MEMORY = 200000;
    private static final String CACHE_DIR_PROPERTY = "druid.benchmark.cacheDir";
    private static final String CACHE_DIR_ENV_VAR = "DRUID_BENCHMARK_CACHE_DIR";
    private final File cacheDir;
    private final boolean cleanupCacheDir;

    public SegmentGenerator() {
        this(null);
    }

    public SegmentGenerator(@Nullable File cacheDir) {
        if (cacheDir != null) {
            this.cacheDir = cacheDir;
            this.cleanupCacheDir = false;
        } else {
            String userConfiguredCacheDir = System.getProperty(CACHE_DIR_PROPERTY, System.getenv(CACHE_DIR_ENV_VAR));
            if (userConfiguredCacheDir != null) {
                this.cacheDir = new File(userConfiguredCacheDir);
                this.cleanupCacheDir = false;
            } else {
                log.warn("No cache directory provided; benchmark data caching is disabled. Set the 'druid.benchmark.cacheDir' property or 'DRUID_BENCHMARK_CACHE_DIR' environment variable to use caching.", new Object[0]);
                this.cacheDir = FileUtils.createTempDir();
                this.cleanupCacheDir = true;
            }
        }
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public QueryableIndex generate(DataSegment dataSegment, GeneratorSchemaInfo schemaInfo, Granularity granularity, int numRows) {
        return this.generate(dataSegment, schemaInfo, schemaInfo.getDimensionsSpec(), TransformSpec.NONE, IndexSpec.getDefault(), granularity, Collections.emptyList(), numRows);
    }

    public QueryableIndex generate(DataSegment dataSegment, GeneratorSchemaInfo schemaInfo, IndexSpec indexSpec, Granularity granularity, int numRows) {
        return this.generate(dataSegment, schemaInfo, schemaInfo.getDimensionsSpec(), TransformSpec.NONE, indexSpec, granularity, Collections.emptyList(), numRows);
    }

    public QueryableIndex generate(DataSegment dataSegment, GeneratorSchemaInfo schemaInfo, DimensionsSpec dimensionsSpec, TransformSpec transformSpec, IndexSpec indexSpec, Granularity queryGranularity, int numRows) {
        return this.generate(dataSegment, schemaInfo, dimensionsSpec, transformSpec, indexSpec, queryGranularity, Collections.emptyList(), numRows);
    }

    public QueryableIndex generate(DataSegment dataSegment, GeneratorSchemaInfo schemaInfo, DimensionsSpec dimensionsSpec, TransformSpec transformSpec, IndexSpec indexSpec, Granularity queryGranularity, List<AggregateProjectionSpec> projectionSpecs, int numRows) {
        return this.generate(dataSegment, schemaInfo, dimensionsSpec, transformSpec, indexSpec, queryGranularity, projectionSpecs, numRows, TestHelper.JSON_MAPPER);
    }

    public QueryableIndex generate(DataSegment dataSegment, GeneratorSchemaInfo schemaInfo, DimensionsSpec dimensionsSpec, TransformSpec transformSpec, IndexSpec indexSpec, Granularity queryGranularity, List<AggregateProjectionSpec> projectionSpecs, int numRows, ObjectMapper jsonMapper) {
        QueryableIndex retVal;
        ComplexMetrics.registerSerde((String)"hyperUnique", (ComplexMetricSerde)new HyperUniquesSerde());
        BuiltInTypesModule.registerHandlersAndSerde();
        String dataHash = Hashing.sha256().newHasher().putString((CharSequence)dataSegment.getId().toString(), StandardCharsets.UTF_8).putString((CharSequence)schemaInfo.toString(), StandardCharsets.UTF_8).putString((CharSequence)dimensionsSpec.toString(), StandardCharsets.UTF_8).putString((CharSequence)queryGranularity.toString(), StandardCharsets.UTF_8).putString((CharSequence)indexSpec.toString(), StandardCharsets.UTF_8).putString((CharSequence)transformSpec.toString(), StandardCharsets.UTF_8).putString((CharSequence)projectionSpecs.toString(), StandardCharsets.UTF_8).putInt(numRows).hash().toString();
        File outDir = new File(this.getSegmentDir(dataSegment.getId(), dataHash), "merged");
        if (outDir.exists()) {
            try {
                log.info("Found segment with hash[%s] cached in directory[%s].", new Object[]{dataHash, outDir});
                return TestHelper.getTestIndexIO(jsonMapper, ColumnConfig.DEFAULT).loadIndex(outDir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        log.info("Writing segment with hash[%s] to directory[%s].", new Object[]{dataHash, outDir});
        DataGenerator dataGenerator = new DataGenerator(schemaInfo.getColumnSchemas(), (long)dataSegment.getId().hashCode(), schemaInfo.getDataInterval(), numRows);
        IncrementalIndexSchema indexSchema = new IncrementalIndexSchema.Builder().withDimensionsSpec(dimensionsSpec).withMetrics(schemaInfo.getAggsArray()).withRollup(schemaInfo.isWithRollup()).withQueryGranularity(queryGranularity).withProjections(projectionSpecs).build();
        ArrayList<InputRow> rows = new ArrayList<InputRow>();
        ArrayList<QueryableIndex> indexes = new ArrayList<QueryableIndex>();
        Transformer transformer = transformSpec.toTransformer();
        InputRowSchema rowSchema = new InputRowSchema(new TimestampSpec(null, null, null), dimensionsSpec, null);
        for (int i = 0; i < numRows; ++i) {
            Map raw = dataGenerator.nextRaw();
            InputRow inputRow = MapInputRowParser.parse((InputRowSchema)rowSchema, (Map)raw);
            InputRow transformedRow = transformer.transform(inputRow);
            rows.add(transformedRow);
            if ((i + 1) % 20000 == 0) {
                log.info("%,d/%,d rows generated for[%s].", new Object[]{i + 1, numRows, dataSegment});
            }
            if (rows.size() % 200000 != 0) continue;
            indexes.add(this.makeIndex(dataSegment.getId(), dataHash, indexes.size(), rows, indexSchema, indexSpec, jsonMapper));
            rows.clear();
        }
        log.info("%,d/%,d rows generated for[%s].", new Object[]{numRows, numRows, dataSegment});
        if (rows.size() > 0) {
            indexes.add(this.makeIndex(dataSegment.getId(), dataHash, indexes.size(), rows, indexSchema, indexSpec, jsonMapper));
            rows.clear();
        }
        if (indexes.isEmpty()) {
            throw new ISE("No rows to index?", new Object[0]);
        }
        try {
            retVal = TestHelper.getTestIndexIO(jsonMapper, ColumnConfig.DEFAULT).loadIndex(TestHelper.getTestIndexMergerV9(jsonMapper, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).mergeQueryableIndex(indexes, false, (AggregatorFactory[])schemaInfo.getAggs().stream().map(AggregatorFactory::getCombiningFactory).toArray(AggregatorFactory[]::new), null, outDir, indexSpec, indexSpec, (ProgressIndicator)new BaseProgressIndicator(), null, -1));
            for (QueryableIndex index : indexes) {
                index.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        log.info("Finished writing segment[%s] to[%s]", new Object[]{dataSegment, outDir});
        return retVal;
    }

    public IncrementalIndex generateIncrementalIndex(DataSegment dataSegment, GeneratorSchemaInfo schemaInfo, DimensionsSpec dimensionsSpec, TransformSpec transformSpec, AggregatorFactory[] aggregatorFactories, IndexSpec indexSpec, Granularity queryGranularity, List<AggregateProjectionSpec> projectionSpecs, int numRows, ObjectMapper jsonMapper) {
        ComplexMetrics.registerSerde((String)"hyperUnique", (ComplexMetricSerde)new HyperUniquesSerde());
        BuiltInTypesModule.registerHandlersAndSerde();
        String dataHash = Hashing.sha256().newHasher().putString((CharSequence)dataSegment.getId().toString(), StandardCharsets.UTF_8).putString((CharSequence)schemaInfo.toString(), StandardCharsets.UTF_8).putString((CharSequence)dimensionsSpec.toString(), StandardCharsets.UTF_8).putString((CharSequence)queryGranularity.toString(), StandardCharsets.UTF_8).putString((CharSequence)indexSpec.toString(), StandardCharsets.UTF_8).putInt(numRows).hash().toString();
        log.info("Writing segment with hash[%s] to incremental index.", new Object[]{dataHash});
        DataGenerator dataGenerator = new DataGenerator(schemaInfo.getColumnSchemas(), (long)dataSegment.getId().hashCode(), schemaInfo.getDataInterval(), numRows);
        IncrementalIndexSchema indexSchema = new IncrementalIndexSchema.Builder().withDimensionsSpec(dimensionsSpec).withMetrics(aggregatorFactories).withRollup(schemaInfo.isWithRollup()).withQueryGranularity(queryGranularity).withProjections(projectionSpecs).build();
        ArrayList<InputRow> rows = new ArrayList<InputRow>();
        Transformer transformer = transformSpec.toTransformer();
        InputRowSchema rowSchema = new InputRowSchema(new TimestampSpec(null, null, null), dimensionsSpec, null);
        for (int i = 0; i < numRows; ++i) {
            Map raw = dataGenerator.nextRaw();
            InputRow inputRow = MapInputRowParser.parse((InputRowSchema)rowSchema, (Map)raw);
            InputRow transformedRow = transformer.transform(inputRow);
            rows.add(transformedRow);
            if ((i + 1) % 20000 != 0) continue;
            log.info("%,d/%,d rows generated for[%s].", new Object[]{i + 1, numRows, dataSegment});
        }
        log.info("%,d/%,d rows generated for[%s].", new Object[]{numRows, numRows, dataSegment});
        return IndexBuilder.create(jsonMapper).schema(indexSchema).tmpDir(new File(this.getSegmentDir(dataSegment.getId(), dataHash), "")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).rows(rows).buildIncrementalIndex();
    }

    public IncrementalIndex generateIncrementalIndex(DataSegment dataSegment, GeneratorSchemaInfo schemaInfo, Granularity granularity, int numRows) {
        ComplexMetrics.registerSerde((String)"hyperUnique", (ComplexMetricSerde)new HyperUniquesSerde());
        String dataHash = Hashing.sha256().newHasher().putString((CharSequence)dataSegment.getId().toString(), StandardCharsets.UTF_8).putString((CharSequence)schemaInfo.toString(), StandardCharsets.UTF_8).putString((CharSequence)granularity.toString(), StandardCharsets.UTF_8).putInt(numRows).hash().toString();
        DataGenerator dataGenerator = new DataGenerator(schemaInfo.getColumnSchemas(), (long)dataSegment.getId().hashCode(), schemaInfo.getDataInterval(), numRows);
        IncrementalIndexSchema indexSchema = new IncrementalIndexSchema.Builder().withDimensionsSpec(schemaInfo.getDimensionsSpec()).withMetrics(schemaInfo.getAggsArray()).withRollup(schemaInfo.isWithRollup()).withQueryGranularity(granularity).build();
        ArrayList<InputRow> rows = new ArrayList<InputRow>();
        for (int i = 0; i < numRows; ++i) {
            InputRow row = dataGenerator.nextRow();
            rows.add(row);
            if ((i + 1) % 20000 != 0) continue;
            log.info("%,d/%,d rows generated for[%s].", new Object[]{i + 1, numRows, dataSegment});
        }
        log.info("%,d/%,d rows generated for[%s].", new Object[]{numRows, numRows, dataSegment});
        return this.makeIncrementalIndex(dataSegment.getId(), dataHash, 0, rows, indexSchema);
    }

    @Override
    public void close() throws IOException {
        if (this.cleanupCacheDir) {
            FileUtils.deleteDirectory((File)this.cacheDir);
        }
    }

    private QueryableIndex makeIndex(SegmentId identifier, String dataHash, int indexNumber, List<InputRow> rows, IncrementalIndexSchema indexSchema, IndexSpec indexSpec, ObjectMapper jsonMapper) {
        return IndexBuilder.create(jsonMapper).schema(indexSchema).indexSpec(indexSpec).tmpDir(new File(this.getSegmentDir(identifier, dataHash), String.valueOf(indexNumber))).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).rows(rows).buildMMappedIndex();
    }

    private IncrementalIndex makeIncrementalIndex(SegmentId identifier, String dataHash, int indexNumber, List<InputRow> rows, IncrementalIndexSchema indexSchema) {
        return IndexBuilder.create().schema(indexSchema).tmpDir(new File(this.getSegmentDir(identifier, dataHash), String.valueOf(indexNumber))).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).rows(rows).buildIncrementalIndex();
    }

    private File getSegmentDir(SegmentId identifier, String dataHash) {
        return new File(this.cacheDir, StringUtils.format((String)"%s_%s", (Object[])new Object[]{identifier, dataHash}));
    }
}

