/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.AggregateProjectionSpec;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexAddResult;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class OnheapIncrementalIndexTest {
    private static final ObjectMapper MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testSpecSerde() throws JsonProcessingException {
        OnheapIncrementalIndex.Spec spec = new OnheapIncrementalIndex.Spec(Boolean.valueOf(true));
        Assert.assertEquals((Object)spec, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)spec), OnheapIncrementalIndex.Spec.class));
    }

    @Test
    public void testProjectionHappyPath() {
        DimensionsSpec dimensionsSpec = DimensionsSpec.builder().setDimensions(List.of(new StringDimensionSchema("string"), new LongDimensionSchema("long"))).build();
        DoubleSumAggregatorFactory aggregatorFactory = new DoubleSumAggregatorFactory("double", "double");
        AggregateProjectionSpec projectionSpec = AggregateProjectionSpec.builder((String)"proj").groupingColumns(new DimensionSchema[]{new StringDimensionSchema("string")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum_long", "long"), new DoubleSumAggregatorFactory("double", "double")}).build();
        IncrementalIndex index = IndexBuilder.create().schema(IncrementalIndexSchema.builder().withDimensionsSpec(dimensionsSpec).withRollup(true).withMetrics(new AggregatorFactory[]{aggregatorFactory}).withProjections(List.of(projectionSpec)).build()).buildIncrementalIndex();
        Assert.assertNotNull((Object)index.getProjection("proj"));
    }

    @Test
    public void testProjectionDuplicatedName() {
        DimensionsSpec dimensionsSpec = DimensionsSpec.EMPTY;
        DoubleSumAggregatorFactory aggregatorFactory = new DoubleSumAggregatorFactory("double", "double");
        AggregateProjectionSpec.Builder bob = new AggregateProjectionSpec.Builder().aggregators(new AggregatorFactory[]{aggregatorFactory});
        DruidException e = (DruidException)Assert.assertThrows(DruidException.class, () -> OnheapIncrementalIndexTest.lambda$testProjectionDuplicatedName$0(dimensionsSpec, (AggregatorFactory)aggregatorFactory, bob));
        Assert.assertEquals((Object)DruidException.Category.DEFENSIVE, (Object)e.getCategory());
        Assert.assertEquals((Object)"duplicate projection[proj]", (Object)e.getMessage());
    }

    @Test
    public void testSpecEqualsAndHashCode() {
        EqualsVerifier.forClass(OnheapIncrementalIndex.Spec.class).usingGetClass().verify();
    }

    @Test
    public void testBadProjectionMismatchedDimensionTypes() {
        Throwable t = Assert.assertThrows(DruidException.class, () -> IndexBuilder.create().schema(IncrementalIndexSchema.builder().withDimensionsSpec(DimensionsSpec.builder().setDimensions(List.of(new StringDimensionSchema("string"), new LongDimensionSchema("long"))).build()).withProjections(List.of(AggregateProjectionSpec.builder((String)"mismatched dims").groupingColumns(new DimensionSchema[]{new LongDimensionSchema("string")}).build())).build()).buildIncrementalIndex());
        Assert.assertEquals((Object)"projection[mismatched dims] contains dimension[string] with different type[LONG] than type[STRING] in base table", (Object)t.getMessage());
    }

    @Test
    public void testBadProjectionDimensionNoVirtualColumnOrBaseTable() {
        Throwable t = Assert.assertThrows(DruidException.class, () -> IndexBuilder.create().schema(IncrementalIndexSchema.builder().withDimensionsSpec(DimensionsSpec.builder().setDimensions(List.of(new StringDimensionSchema("string"), new LongDimensionSchema("long"))).build()).withProjections(List.of(AggregateProjectionSpec.builder((String)"sad grouping column").virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "cast(long, 'double')", ColumnType.DOUBLE, TestExprMacroTable.INSTANCE)}).groupingColumns(new DimensionSchema[]{new DoubleDimensionSchema("v0"), new StringDimensionSchema("missing")}).build())).build()).buildIncrementalIndex());
        Assert.assertEquals((Object)"projection[sad grouping column] contains dimension[missing] that is not present on the base table or a virtual column", (Object)t.getMessage());
    }

    @Test
    public void testBadProjectionVirtualColumnNoDimension() {
        Throwable t = Assert.assertThrows(DruidException.class, () -> IndexBuilder.create().schema(IncrementalIndexSchema.builder().withDimensionsSpec(DimensionsSpec.builder().setDimensions(List.of(new StringDimensionSchema("string"), new LongDimensionSchema("long"))).build()).withProjections(List.of(AggregateProjectionSpec.builder((String)"sad virtual column").virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "double", ColumnType.DOUBLE, TestExprMacroTable.INSTANCE)}).groupingColumns(new DimensionSchema[]{new LongDimensionSchema("long")}).build())).build()).buildIncrementalIndex());
        Assert.assertEquals((Object)"projection[sad virtual column] contains virtual column[v0] that references an input[double] which is not a dimension in the base table", (Object)t.getMessage());
    }

    @Test
    public void testBadProjectionRollupMismatchedAggType() {
        Throwable t = Assert.assertThrows(DruidException.class, () -> IndexBuilder.create().schema(IncrementalIndexSchema.builder().withDimensionsSpec(DimensionsSpec.builder().setDimensions(List.of(new StringDimensionSchema("string"), new LongDimensionSchema("long"))).build()).withRollup(true).withMetrics(new AggregatorFactory[]{new DoubleSumAggregatorFactory("sum_double", "sum_double")}).withProjections(List.of(AggregateProjectionSpec.builder((String)"mismatched agg").groupingColumns(new DimensionSchema[]{new StringDimensionSchema("string")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum_double", "sum_double")}).build())).build()).buildIncrementalIndex());
        Assert.assertEquals((Object)"projection[mismatched agg] contains aggregator[sum_double] that is not the 'combining' aggregator of base table aggregator[sum_double]", (Object)t.getMessage());
    }

    @Test
    public void testBadProjectionRollupBadAggInput() {
        Throwable t = Assert.assertThrows(DruidException.class, () -> IndexBuilder.create().schema(IncrementalIndexSchema.builder().withDimensionsSpec(DimensionsSpec.builder().setDimensions(List.of(new StringDimensionSchema("string"), new LongDimensionSchema("long"))).build()).withRollup(true).withMetrics(new AggregatorFactory[]{new DoubleSumAggregatorFactory("double", "double")}).withProjections(List.of(AggregateProjectionSpec.builder((String)"renamed agg").groupingColumns(new DimensionSchema[]{new StringDimensionSchema("string")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum_long", "long"), new DoubleSumAggregatorFactory("sum_double", "double")}).build())).build()).buildIncrementalIndex());
        Assert.assertEquals((Object)"projection[renamed agg] contains aggregator[sum_double] that references aggregator[double] in base table but this is not supported, projection aggregators which reference base table aggregates must be 'combining' aggregators with the same name as the base table column", (Object)t.getMessage());
    }

    @Test
    public void testBadProjectionVirtualColumnAggInput() {
        Throwable t = Assert.assertThrows(DruidException.class, () -> IndexBuilder.create().schema(IncrementalIndexSchema.builder().withDimensionsSpec(DimensionsSpec.builder().setDimensions(List.of(new StringDimensionSchema("string"), new LongDimensionSchema("long"))).build()).withProjections(List.of(AggregateProjectionSpec.builder((String)"sad agg virtual column").virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "long + 100", ColumnType.LONG, TestExprMacroTable.INSTANCE)}).groupingColumns(new DimensionSchema[]{new LongDimensionSchema("long")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("v0_sum", "v0")}).build())).build()).buildIncrementalIndex());
        Assert.assertEquals((Object)"projection[sad agg virtual column] contains aggregator[v0_sum] that is has required field[v0] which is a virtual column, this is not yet supported", (Object)t.getMessage());
    }

    @Test
    public void testTimestampOutOfRange() {
        DimensionsSpec dimensionsSpec = DimensionsSpec.builder().setDimensions(List.of(new StringDimensionSchema("string"), new LongDimensionSchema("long"))).build();
        DoubleSumAggregatorFactory aggregatorFactory = new DoubleSumAggregatorFactory("double", "double");
        AggregateProjectionSpec projectionSpec = AggregateProjectionSpec.builder((String)"proj").groupingColumns(new DimensionSchema[]{new StringDimensionSchema("string")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum_long", "long"), new DoubleSumAggregatorFactory("double", "double")}).build();
        DateTime minTimestamp = DateTimes.nowUtc();
        DateTime outOfRangeTimestamp = DateTimes.nowUtc().minusDays(1);
        DateTime outOfRangeProjectionTimestamp = Granularities.YEAR.bucketStart(outOfRangeTimestamp);
        IncrementalIndex index = IndexBuilder.create().schema(IncrementalIndexSchema.builder().withDimensionsSpec(dimensionsSpec).withRollup(true).withMetrics(new AggregatorFactory[]{aggregatorFactory}).withProjections(List.of(projectionSpec)).withMinTimestamp(minTimestamp.getMillis()).build()).buildIncrementalIndex();
        IncrementalIndexAddResult addResult = index.add((InputRow)new MapBasedInputRow(minTimestamp, List.of("string", "long"), Map.of("string", "hello", "long", 10L)));
        Assert.assertTrue((boolean)addResult.isRowAdded());
        LinkedHashMap<String, Object> rowMap = new LinkedHashMap<String, Object>();
        rowMap.put("string", "hello");
        rowMap.put("long", 10L);
        Throwable t = Assert.assertThrows(DruidException.class, () -> index.add((InputRow)new MapBasedInputRow(outOfRangeTimestamp.getMillis(), List.of("string", "long"), rowMap)));
        Assert.assertEquals((Object)("Cannot add row[{timestamp=" + outOfRangeTimestamp + ", event={string=hello, long=10}, dimensions=[string, long]}] because it is below the minTimestamp[" + minTimestamp + "]"), (Object)t.getMessage());
        AggregateProjectionSpec projectionSpecYear = AggregateProjectionSpec.builder((String)"proj").virtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.YEAR, (String)"g")}).groupingColumns(new DimensionSchema[]{new StringDimensionSchema("string"), new LongDimensionSchema("g")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum_long", "long"), new DoubleSumAggregatorFactory("double", "double")}).build();
        IncrementalIndex index2 = IndexBuilder.create().schema(IncrementalIndexSchema.builder().withDimensionsSpec(dimensionsSpec).withRollup(true).withMetrics(new AggregatorFactory[]{aggregatorFactory}).withProjections(List.of(projectionSpecYear)).withMinTimestamp(minTimestamp.getMillis()).build()).buildIncrementalIndex();
        t = Assert.assertThrows(DruidException.class, () -> index2.add((InputRow)new MapBasedInputRow(minTimestamp, List.of("string", "long"), rowMap)));
        Assert.assertEquals((Object)("Cannot add row[{timestamp=" + minTimestamp + ", event={string=hello, long=10}, dimensions=[string, long]}] to projection[proj] because projection effective timestamp[" + outOfRangeProjectionTimestamp + "] is below the minTimestamp[" + minTimestamp + "]"), (Object)t.getMessage());
    }

    private static /* synthetic */ void lambda$testProjectionDuplicatedName$0(DimensionsSpec dimensionsSpec, AggregatorFactory aggregatorFactory, AggregateProjectionSpec.Builder bob) throws Throwable {
        IndexBuilder.create().schema(IncrementalIndexSchema.builder().withDimensionsSpec(dimensionsSpec).withRollup(true).withMetrics(new AggregatorFactory[]{aggregatorFactory}).withProjections(List.of(bob.name("proj").build(), bob.name("proj").build())).build()).buildIncrementalIndex();
    }
}

