/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.error.DruidException;
import org.apache.druid.guice.BuiltInTypesModule;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.NestedDataTestUtils;
import org.apache.druid.query.aggregation.AggregationTestHelper;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.DoubleColumnSelector;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.LongColumnSelector;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.nested.NestedPathFinder;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.segment.vector.BaseDoubleVectorValueSelector;
import org.apache.druid.segment.vector.BaseLongVectorValueSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorCursor;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.segment.virtual.NestedFieldVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class NestedFieldColumnSelectorsTest
extends InitializedNullHandlingTest {
    private static final String NESTED_LONG_FIELD = "long";
    private static final String NESTED_DOUBLE_FIELD = "double";
    private static final String NESTED_MIXED_NUMERIC_FIELD = "mixed_numeric";
    private static final String NESTED_MIXED_FIELD = "mixed";
    private static final String NESTED_SPARSE_LONG_FIELD = "sparse_long";
    private static final String NESTED_SPARSE_DOUBLE_FIELD = "sparse_double";
    private static final String NESTED_SPARSE_MIXED_NUMERIC_FIELD = "sparse_mixed_numeric";
    private static final String NESTED_SPARSE_MIXED_FIELD = "sparse_mixed";
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    private final AggregationTestHelper helper;
    private final Closer closer;

    public NestedFieldColumnSelectorsTest() {
        BuiltInTypesModule.registerHandlersAndSerde();
        List mods = BuiltInTypesModule.getJacksonModulesList();
        this.helper = AggregationTestHelper.createScanQueryAggregationTestHelper(mods, this.tempFolder);
        this.closer = Closer.create();
    }

    @After
    public void teardown() throws IOException {
        this.closer.close();
    }

    @Test
    public void testExpectedTypes() throws Exception {
        ColumnSelectorFactory columnSelectorFactory = this.getNumericColumnSelectorFactory(this.makeNestedNumericVirtualColumns());
        ColumnValueSelector longValueSelector = columnSelectorFactory.makeColumnValueSelector(NESTED_LONG_FIELD);
        Assert.assertNotNull((Object)longValueSelector);
        Assert.assertTrue((boolean)(longValueSelector instanceof LongColumnSelector));
        ColumnValueSelector doubleValueSelector = columnSelectorFactory.makeColumnValueSelector(NESTED_DOUBLE_FIELD);
        Assert.assertNotNull((Object)doubleValueSelector);
        Assert.assertTrue((boolean)(doubleValueSelector instanceof DoubleColumnSelector));
        ColumnValueSelector mixedNumericValueSelector = columnSelectorFactory.makeColumnValueSelector(NESTED_MIXED_NUMERIC_FIELD);
        Assert.assertNotNull((Object)mixedNumericValueSelector);
        Assert.assertTrue((boolean)(mixedNumericValueSelector instanceof ColumnValueSelector));
        ColumnValueSelector mixedValueSelector = columnSelectorFactory.makeColumnValueSelector(NESTED_MIXED_FIELD);
        Assert.assertNotNull((Object)mixedValueSelector);
        Assert.assertTrue((boolean)(mixedValueSelector instanceof ColumnValueSelector));
        ColumnValueSelector sparseLongValueSelector = columnSelectorFactory.makeColumnValueSelector(NESTED_SPARSE_LONG_FIELD);
        Assert.assertNotNull((Object)sparseLongValueSelector);
        Assert.assertTrue((boolean)(sparseLongValueSelector instanceof LongColumnSelector));
        ColumnValueSelector sparseDoubleValueSelector = columnSelectorFactory.makeColumnValueSelector(NESTED_SPARSE_DOUBLE_FIELD);
        Assert.assertNotNull((Object)sparseDoubleValueSelector);
        Assert.assertTrue((boolean)(sparseDoubleValueSelector instanceof DoubleColumnSelector));
        ColumnValueSelector sparseMixedNumericValueSelector = columnSelectorFactory.makeColumnValueSelector(NESTED_SPARSE_MIXED_NUMERIC_FIELD);
        Assert.assertNotNull((Object)sparseMixedNumericValueSelector);
        Assert.assertTrue((boolean)(sparseMixedNumericValueSelector instanceof ColumnValueSelector));
        ColumnValueSelector sparseMixedValueSelector = columnSelectorFactory.makeColumnValueSelector(NESTED_SPARSE_MIXED_FIELD);
        Assert.assertNotNull((Object)sparseMixedValueSelector);
        Assert.assertTrue((boolean)(sparseMixedValueSelector instanceof ColumnValueSelector));
    }

    @Test
    public void testExpectedTypesVectorSelectors() throws Exception {
        VectorColumnSelectorFactory factory = this.getVectorColumnSelectorFactory(this.makeNestedNumericVirtualColumns());
        VectorValueSelector longValueSelector = factory.makeValueSelector(NESTED_LONG_FIELD);
        Assert.assertNotNull((Object)longValueSelector);
        Assert.assertTrue((boolean)(longValueSelector instanceof BaseLongVectorValueSelector));
        VectorValueSelector doubleValueSelector = factory.makeValueSelector(NESTED_DOUBLE_FIELD);
        Assert.assertNotNull((Object)doubleValueSelector);
        Assert.assertTrue((boolean)(doubleValueSelector instanceof BaseDoubleVectorValueSelector));
        Assert.assertThrows(DruidException.class, () -> factory.makeValueSelector(NESTED_MIXED_FIELD));
        VectorValueSelector mixedNumericValueSelector = factory.makeValueSelector(NESTED_MIXED_NUMERIC_FIELD);
        Assert.assertTrue((boolean)(mixedNumericValueSelector instanceof BaseDoubleVectorValueSelector));
        SingleValueDimensionVectorSelector longDimensionSelector = factory.makeSingleValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)NESTED_LONG_FIELD));
        Assert.assertNotNull((Object)longDimensionSelector);
        SingleValueDimensionVectorSelector doubleDimensionSelector = factory.makeSingleValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)NESTED_DOUBLE_FIELD));
        Assert.assertNotNull((Object)doubleDimensionSelector);
        SingleValueDimensionVectorSelector mixedNumericDimensionValueSelector = factory.makeSingleValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)NESTED_MIXED_NUMERIC_FIELD));
        Assert.assertNotNull((Object)mixedNumericDimensionValueSelector);
        SingleValueDimensionVectorSelector mixedValueSelector = factory.makeSingleValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)NESTED_MIXED_FIELD));
        Assert.assertNotNull((Object)mixedValueSelector);
        VectorObjectSelector longObjectSelector = factory.makeObjectSelector(NESTED_LONG_FIELD);
        Assert.assertNotNull((Object)longObjectSelector);
        VectorObjectSelector doubleObjectSelector = factory.makeObjectSelector(NESTED_DOUBLE_FIELD);
        Assert.assertNotNull((Object)doubleObjectSelector);
        VectorObjectSelector mixedNumericObjectSelector = factory.makeObjectSelector(NESTED_MIXED_NUMERIC_FIELD);
        Assert.assertNotNull((Object)mixedNumericObjectSelector);
        VectorObjectSelector mixedObjectSelector = factory.makeObjectSelector(NESTED_MIXED_FIELD);
        Assert.assertNotNull((Object)mixedObjectSelector);
    }

    private VirtualColumns makeNestedNumericVirtualColumns() {
        List longParts = NestedPathFinder.parseJqPath((String)".long");
        List doubleParts = NestedPathFinder.parseJqPath((String)".double");
        List mixedNumericParts = NestedPathFinder.parseJqPath((String)".mixed_numeric");
        List mixedParts = NestedPathFinder.parseJqPath((String)".mixed");
        List sparseLongParts = NestedPathFinder.parseJqPath((String)".sparse_long");
        List sparseDoubleParts = NestedPathFinder.parseJqPath((String)".sparse_double");
        List sparseMixedNumericParts = NestedPathFinder.parseJqPath((String)".sparse_mixed_numeric");
        List sparseMixedParts = NestedPathFinder.parseJqPath((String)".sparse_mixed");
        NestedFieldVirtualColumn longVirtualColumn = new NestedFieldVirtualColumn("nest", NESTED_LONG_FIELD, ColumnType.LONG, longParts, Boolean.valueOf(false), null, null);
        NestedFieldVirtualColumn doubleVirtualColumn = new NestedFieldVirtualColumn("nest", NESTED_DOUBLE_FIELD, ColumnType.DOUBLE, doubleParts, Boolean.valueOf(false), null, null);
        NestedFieldVirtualColumn mixedNumericVirtualColumn = new NestedFieldVirtualColumn("nest", NESTED_MIXED_NUMERIC_FIELD, null, mixedNumericParts, Boolean.valueOf(false), null, null);
        NestedFieldVirtualColumn mixedVirtualColumn = new NestedFieldVirtualColumn("nest", NESTED_MIXED_FIELD, null, mixedParts, Boolean.valueOf(false), null, null);
        NestedFieldVirtualColumn sparseLongVirtualColumn = new NestedFieldVirtualColumn("nest", NESTED_SPARSE_LONG_FIELD, ColumnType.LONG, sparseLongParts, Boolean.valueOf(false), null, null);
        NestedFieldVirtualColumn sparseDoubleVirtualColumn = new NestedFieldVirtualColumn("nest", NESTED_SPARSE_DOUBLE_FIELD, ColumnType.DOUBLE, sparseDoubleParts, Boolean.valueOf(false), null, null);
        NestedFieldVirtualColumn sparseMixedNumericVirtualColumn = new NestedFieldVirtualColumn("nest", NESTED_SPARSE_MIXED_NUMERIC_FIELD, null, sparseMixedNumericParts, Boolean.valueOf(false), null, null);
        NestedFieldVirtualColumn sparseMixedVirtualColumn = new NestedFieldVirtualColumn("nest", NESTED_SPARSE_MIXED_FIELD, null, sparseMixedParts, Boolean.valueOf(false), null, null);
        return VirtualColumns.create((List)ImmutableList.of((Object)longVirtualColumn, (Object)doubleVirtualColumn, (Object)mixedNumericVirtualColumn, (Object)mixedVirtualColumn, (Object)sparseLongVirtualColumn, (Object)sparseDoubleVirtualColumn, (Object)sparseMixedNumericVirtualColumn, (Object)sparseMixedVirtualColumn));
    }

    private ColumnSelectorFactory getNumericColumnSelectorFactory(VirtualColumns virtualColumns) throws Exception {
        List<Segment> segments = NestedDataTestUtils.createSegments(this.tempFolder, this.closer, "nested-numeric-test-data.json", (InputFormat)TestIndex.DEFAULT_JSON_INPUT_FORMAT, NestedDataTestUtils.TIMESTAMP_SPEC, NestedDataTestUtils.AUTO_DISCOVERY, TransformSpec.NONE, NestedDataTestUtils.COUNT, Granularities.NONE, true, IndexSpec.getDefault());
        Assert.assertEquals((long)1L, (long)segments.size());
        Segment segment = segments.get(0);
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setVirtualColumns(virtualColumns).build();
        CursorHolder cursorHolder = (CursorHolder)this.closer.register((Closeable)Objects.requireNonNull((CursorFactory)segment.as(CursorFactory.class)).makeCursorHolder(buildSpec));
        Cursor cursor = cursorHolder.asCursor();
        return cursor.getColumnSelectorFactory();
    }

    private VectorColumnSelectorFactory getVectorColumnSelectorFactory(VirtualColumns virtualColumns) throws Exception {
        List<Segment> segments = NestedDataTestUtils.createSegments(this.tempFolder, this.closer, "nested-numeric-test-data.json", (InputFormat)TestIndex.DEFAULT_JSON_INPUT_FORMAT, NestedDataTestUtils.TIMESTAMP_SPEC, NestedDataTestUtils.AUTO_DISCOVERY, TransformSpec.NONE, NestedDataTestUtils.COUNT, Granularities.NONE, true, IndexSpec.getDefault());
        Assert.assertEquals((long)1L, (long)segments.size());
        Segment segment = segments.get(0);
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setVirtualColumns(virtualColumns).build();
        VectorCursor cursor = ((CursorHolder)this.closer.register((Closeable)Objects.requireNonNull((CursorFactory)segment.as(CursorFactory.class)).makeCursorHolder(buildSpec))).asVectorCursor();
        return cursor.getColumnSelectorFactory();
    }
}

