/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.projections;

import java.util.List;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.filter.IsBooleanFilter;
import org.apache.druid.segment.filter.OrFilter;
import org.apache.druid.segment.projections.ProjectionFilterMatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProjectionFilterMatchTest {
    @Test
    void testRewriteFilter() {
        EqualityFilter xeqfoo = new EqualityFilter("x", ColumnType.STRING, (Object)"foo", null);
        EqualityFilter xeqfoo2 = new EqualityFilter("x", ColumnType.STRING, (Object)"foo", null);
        EqualityFilter xeqbar = new EqualityFilter("x", ColumnType.STRING, (Object)"bar", null);
        EqualityFilter yeqbar = new EqualityFilter("y", ColumnType.STRING, (Object)"bar", null);
        EqualityFilter zeq123 = new EqualityFilter("z", ColumnType.LONG, (Object)123L, null);
        EqualityFilter queryFilter = xeqfoo2;
        Assertions.assertInstanceOf(ProjectionFilterMatch.class, (Object)ProjectionFilterMatch.rewriteFilter((Filter)xeqfoo, (Filter)queryFilter));
        queryFilter = yeqbar;
        Assertions.assertNull((Object)ProjectionFilterMatch.rewriteFilter((Filter)xeqfoo, (Filter)queryFilter));
        queryFilter = new AndFilter(List.of(xeqfoo, yeqbar));
        Assertions.assertEquals((Object)yeqbar, (Object)ProjectionFilterMatch.rewriteFilter((Filter)xeqfoo, (Filter)queryFilter));
        queryFilter = new AndFilter(List.of(new OrFilter(List.of(xeqfoo, xeqbar)), yeqbar));
        Assertions.assertNull((Object)ProjectionFilterMatch.rewriteFilter((Filter)xeqfoo, (Filter)queryFilter));
        queryFilter = new AndFilter(List.of(new IsBooleanFilter((Filter)xeqfoo, true), yeqbar));
        Assertions.assertEquals((Object)yeqbar, (Object)ProjectionFilterMatch.rewriteFilter((Filter)xeqfoo, (Filter)queryFilter));
        queryFilter = new AndFilter(List.of(new IsBooleanFilter((Filter)xeqfoo, false), yeqbar));
        Assertions.assertNull((Object)ProjectionFilterMatch.rewriteFilter((Filter)xeqfoo, (Filter)queryFilter));
        queryFilter = new AndFilter(List.of(new AndFilter(List.of(xeqfoo, yeqbar)), zeq123));
        Assertions.assertEquals((Object)new AndFilter(List.of(yeqbar, zeq123)), (Object)ProjectionFilterMatch.rewriteFilter((Filter)xeqfoo, (Filter)queryFilter));
        queryFilter = new AndFilter(List.of(new EqualityFilter("a", ColumnType.STRING, (Object)"foo", null), new EqualityFilter("b", ColumnType.STRING, (Object)"bar", null), new EqualityFilter("c", ColumnType.STRING, (Object)"baz", null)));
        Assertions.assertEquals((Object)new EqualityFilter("b", ColumnType.STRING, (Object)"bar", null), (Object)ProjectionFilterMatch.rewriteFilter((Filter)new AndFilter(List.of(new EqualityFilter("a", ColumnType.STRING, (Object)"foo", null), new EqualityFilter("c", ColumnType.STRING, (Object)"baz", null))), (Filter)queryFilter));
    }

    @Test
    void testRewriteFilter_andFilterNotMatch() {
        EqualityFilter xeqfoo = new EqualityFilter("x", ColumnType.STRING, (Object)"foo", null);
        EqualityFilter metricLike = new EqualityFilter("metric", ColumnType.STRING, (Object)"metric1", null);
        OrFilter envOrUser = new OrFilter(List.of(new EqualityFilter("env", ColumnType.STRING, (Object)"dev", null), new EqualityFilter("user", ColumnType.STRING, (Object)"user-a", null)));
        OrFilter envOrUser2 = new OrFilter(List.of(new EqualityFilter("prod", ColumnType.STRING, (Object)"dev", null), new EqualityFilter("another-user", ColumnType.STRING, (Object)"user-a", null)));
        AndFilter queryFilter = new AndFilter(List.of(xeqfoo, envOrUser, metricLike));
        AndFilter projectionFilter = new AndFilter(List.of(envOrUser2, metricLike));
        Assertions.assertNull((Object)ProjectionFilterMatch.rewriteFilter((Filter)projectionFilter, (Filter)queryFilter));
    }

    @Test
    void testRewriteFilter_andFilterMatch() {
        EqualityFilter xeqfoo = new EqualityFilter("x", ColumnType.STRING, (Object)"foo", null);
        EqualityFilter metricLike = new EqualityFilter("metric", ColumnType.STRING, (Object)"metric1", null);
        OrFilter envOrUser = new OrFilter(List.of(new EqualityFilter("env", ColumnType.STRING, (Object)"dev", null), new EqualityFilter("user", ColumnType.STRING, (Object)"user-a", null)));
        AndFilter queryFilter = new AndFilter(List.of(xeqfoo, envOrUser, metricLike));
        AndFilter projectionFilter = new AndFilter(List.of(envOrUser, metricLike));
        Assertions.assertEquals((Object)xeqfoo, (Object)ProjectionFilterMatch.rewriteFilter((Filter)projectionFilter, (Filter)queryFilter));
    }
}

