/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.projections;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.data.input.impl.AggregateProjectionSpec;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.LikeDimFilter;
import org.apache.druid.segment.AggregateProjectionMetadata;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.projections.ProjectionMatch;
import org.apache.druid.segment.projections.Projections;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ProjectionsTest {
    ProjectionsTest() {
    }

    @Test
    void testSchemaMatchSimple() {
        RowSignature baseTable = RowSignature.builder().addTimeColumn().add("a", ColumnType.LONG).add("b", ColumnType.STRING).add("c", ColumnType.LONG).build();
        AggregateProjectionMetadata spec = new AggregateProjectionMetadata(AggregateProjectionSpec.builder((String)"some_projection").groupingColumns(new DimensionSchema[]{new LongDimensionSchema("a"), new StringDimensionSchema("b")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("c_sum", "c")}).build().toMetadataSchema(), 12345);
        CursorBuildSpec cursorBuildSpec = CursorBuildSpec.builder().setPhysicalColumns(Set.of("c")).setPreferredOrdering(List.of()).setAggregators(List.of(new LongSumAggregatorFactory("c", "c"))).build();
        ProjectionMatch projectionMatch = Projections.matchAggregateProjection((AggregateProjectionMetadata.Schema)spec.getSchema(), (CursorBuildSpec)cursorBuildSpec, (Interval)Intervals.ETERNITY, (Projections.PhysicalColumnChecker)new RowSignatureChecker(baseTable));
        ProjectionMatch expected = new ProjectionMatch(CursorBuildSpec.builder().setAggregators(List.of(new LongSumAggregatorFactory("c", "c"))).setPhysicalColumns(Set.of("c_sum")).setPreferredOrdering(List.of()).build(), Map.of("c", "c_sum"));
        Assertions.assertEquals((Object)expected, (Object)projectionMatch);
    }

    @Test
    void testSchemaMatchDifferentTimeZone_hourlyMatches() {
        ExpressionVirtualColumn ptHourlyFloor = new ExpressionVirtualColumn("__ptHourly", "timestamp_floor(__time, 'PT1H', null, 'America/Los_Angeles')", ColumnType.LONG, TestExprMacroTable.INSTANCE);
        ExpressionVirtualColumn hourlyFloor = new ExpressionVirtualColumn("__hourly", "timestamp_floor(__time, 'PT1H', null, null)", ColumnType.LONG, TestExprMacroTable.INSTANCE);
        RowSignature baseTable = RowSignature.builder().addTimeColumn().add("a", ColumnType.LONG).add("b", ColumnType.STRING).add("c", ColumnType.LONG).build();
        AggregateProjectionMetadata spec = new AggregateProjectionMetadata(AggregateProjectionSpec.builder((String)"some_projection").virtualColumns(new VirtualColumn[]{hourlyFloor}).groupingColumns(new DimensionSchema[]{new LongDimensionSchema("__hourly"), new LongDimensionSchema("a")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("c_sum", "c")}).build().toMetadataSchema(), 12345);
        CursorBuildSpec cursorBuildSpec = CursorBuildSpec.builder().setVirtualColumns(VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{ptHourlyFloor})).setPhysicalColumns(Set.of("__time", "c")).setPreferredOrdering(List.of()).setAggregators(List.of(new LongSumAggregatorFactory("c", "c"))).build();
        ProjectionMatch projectionMatch = Projections.matchAggregateProjection((AggregateProjectionMetadata.Schema)spec.getSchema(), (CursorBuildSpec)cursorBuildSpec, (Interval)Intervals.ETERNITY, (Projections.PhysicalColumnChecker)new RowSignatureChecker(baseTable));
        ProjectionMatch expected = new ProjectionMatch(CursorBuildSpec.builder().setAggregators(List.of(new LongSumAggregatorFactory("c", "c"))).setVirtualColumns(VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{ptHourlyFloor})).setPhysicalColumns(Set.of("__time", "c_sum")).setPreferredOrdering(List.of()).build(), Map.of("c", "c_sum"));
        Assertions.assertEquals((Object)expected, (Object)projectionMatch);
    }

    @Test
    void testSchemaMatchDifferentTimeZone_dailyDoesNotMatch() {
        ExpressionVirtualColumn ptDailyFloor = new ExpressionVirtualColumn("__ptDaily", "timestamp_floor(__time, 'P1D', null, 'America/Los_Angeles')", ColumnType.LONG, TestExprMacroTable.INSTANCE);
        ExpressionVirtualColumn dailyFloor = new ExpressionVirtualColumn("__daily", "timestamp_floor(__time, 'P1D', null, null)", ColumnType.LONG, TestExprMacroTable.INSTANCE);
        RowSignature baseTable = RowSignature.builder().addTimeColumn().add("a", ColumnType.LONG).add("b", ColumnType.STRING).add("c", ColumnType.LONG).build();
        AggregateProjectionMetadata spec = new AggregateProjectionMetadata(AggregateProjectionSpec.builder((String)"some_projection").virtualColumns(new VirtualColumn[]{dailyFloor}).groupingColumns(new DimensionSchema[]{new LongDimensionSchema("__daily"), new LongDimensionSchema("a")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("c_sum", "c")}).build().toMetadataSchema(), 12345);
        CursorBuildSpec cursorBuildSpec = CursorBuildSpec.builder().setVirtualColumns(VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{ptDailyFloor})).setPhysicalColumns(Set.of("__time", "c")).setPreferredOrdering(List.of()).setAggregators(List.of(new LongSumAggregatorFactory("c", "c"))).build();
        ProjectionMatch projectionMatch = Projections.matchAggregateProjection((AggregateProjectionMetadata.Schema)spec.getSchema(), (CursorBuildSpec)cursorBuildSpec, (Interval)Intervals.ETERNITY, (Projections.PhysicalColumnChecker)new RowSignatureChecker(baseTable));
        Assertions.assertNull((Object)projectionMatch);
    }

    @Test
    void testSchemaMatchFilter() {
        RowSignature baseTable = RowSignature.builder().addTimeColumn().add("a", ColumnType.LONG).add("b", ColumnType.STRING).add("c", ColumnType.LONG).build();
        AggregateProjectionMetadata spec = new AggregateProjectionMetadata(AggregateProjectionSpec.builder((String)"some_projection").filter((DimFilter)new EqualityFilter("b", ColumnType.STRING, (Object)"foo", null)).groupingColumns(new DimensionSchema[]{new LongDimensionSchema("a")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("c_sum", "c")}).build().toMetadataSchema(), 12345);
        CursorBuildSpec cursorBuildSpecNoFilter = CursorBuildSpec.builder().setPhysicalColumns(Set.of("c")).setPreferredOrdering(List.of()).setAggregators(List.of(new LongSumAggregatorFactory("c", "c"))).build();
        Assertions.assertNull((Object)Projections.matchAggregateProjection((AggregateProjectionMetadata.Schema)spec.getSchema(), (CursorBuildSpec)cursorBuildSpecNoFilter, (Interval)Intervals.ETERNITY, (Projections.PhysicalColumnChecker)new RowSignatureChecker(baseTable)));
        CursorBuildSpec cursorBuildSpecWithFilter = CursorBuildSpec.builder().setPhysicalColumns(Set.of("b", "c")).setPreferredOrdering(List.of()).setFilter((Filter)new EqualityFilter("b", ColumnType.STRING, (Object)"foo", null)).setAggregators(List.of(new LongSumAggregatorFactory("c", "c"))).build();
        ProjectionMatch projectionMatch = Projections.matchAggregateProjection((AggregateProjectionMetadata.Schema)spec.getSchema(), (CursorBuildSpec)cursorBuildSpecWithFilter, (Interval)Intervals.ETERNITY, (Projections.PhysicalColumnChecker)new RowSignatureChecker(baseTable));
        ProjectionMatch expected = new ProjectionMatch(CursorBuildSpec.builder().setAggregators(List.of(new LongSumAggregatorFactory("c", "c"))).setPhysicalColumns(Set.of("c_sum")).setPreferredOrdering(List.of()).build(), Map.of("c", "c_sum"));
        Assertions.assertEquals((Object)expected, (Object)projectionMatch);
    }

    @Test
    void testSchemaMatchFilterIncludedInProjection() {
        RowSignature baseTable = RowSignature.builder().addTimeColumn().add("a", ColumnType.LONG).add("b", ColumnType.STRING).add("c", ColumnType.LONG).build();
        AggregateProjectionMetadata spec = new AggregateProjectionMetadata(AggregateProjectionSpec.builder((String)"some_projection").filter((DimFilter)new LikeDimFilter("b", "foo%", null, null)).groupingColumns(new DimensionSchema[]{new LongDimensionSchema("a"), new StringDimensionSchema("b")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("c_sum", "c")}).build().toMetadataSchema(), 12345);
        CursorBuildSpec cursorBuildSpecNoFilter = CursorBuildSpec.builder().setPreferredOrdering(List.of()).setPhysicalColumns(Set.of("a", "b", "c")).setGroupingColumns(List.of("a", "b")).setAggregators(List.of(new LongSumAggregatorFactory("c", "c"))).build();
        Assertions.assertNull((Object)Projections.matchAggregateProjection((AggregateProjectionMetadata.Schema)spec.getSchema(), (CursorBuildSpec)cursorBuildSpecNoFilter, (Interval)Intervals.ETERNITY, (Projections.PhysicalColumnChecker)new RowSignatureChecker(baseTable)));
        CursorBuildSpec cursorBuildSpecWithFilter = CursorBuildSpec.builder().setPhysicalColumns(Set.of("a", "b", "c")).setGroupingColumns(List.of("a", "b")).setPreferredOrdering(List.of()).setFilter(new LikeDimFilter("b", "foo%", null, null).toFilter()).setAggregators(List.of(new LongSumAggregatorFactory("c", "c"))).build();
        ProjectionMatch projectionMatch = Projections.matchAggregateProjection((AggregateProjectionMetadata.Schema)spec.getSchema(), (CursorBuildSpec)cursorBuildSpecWithFilter, (Interval)Intervals.ETERNITY, (Projections.PhysicalColumnChecker)new RowSignatureChecker(baseTable));
        ProjectionMatch expected = new ProjectionMatch(CursorBuildSpec.builder().setGroupingColumns(List.of("a", "b")).setAggregators(List.of(new LongSumAggregatorFactory("c", "c"))).setPhysicalColumns(Set.of("a", "b", "c_sum")).setPreferredOrdering(List.of()).build(), Map.of("c", "c_sum"));
        Assertions.assertEquals((Object)expected, (Object)projectionMatch);
    }

    @Test
    public void testSchemaMatchIntervalEternity() {
        DateTime time = Granularities.DAY.bucketStart(DateTimes.nowUtc());
        RowSignature baseTable = RowSignature.builder().addTimeColumn().add("a", ColumnType.STRING).build();
        AggregateProjectionMetadata spec = new AggregateProjectionMetadata(AggregateProjectionSpec.builder((String)"some_projection").groupingColumns(new DimensionSchema[]{new StringDimensionSchema("a")}).build().toMetadataSchema(), 12345);
        CursorBuildSpec cursorBuildSpec = CursorBuildSpec.builder().setPhysicalColumns(Set.of("a")).setGroupingColumns(List.of("a")).build();
        ProjectionMatch projectionMatch = Projections.matchAggregateProjection((AggregateProjectionMetadata.Schema)spec.getSchema(), (CursorBuildSpec)cursorBuildSpec, (Interval)Intervals.ETERNITY, (Projections.PhysicalColumnChecker)new RowSignatureChecker(baseTable));
        ProjectionMatch expected = new ProjectionMatch(CursorBuildSpec.builder().setPhysicalColumns(Set.of("a")).setGroupingColumns(List.of("a")).setAggregators(List.of()).build(), Map.of());
        Assertions.assertEquals((Object)expected, (Object)projectionMatch);
        projectionMatch = Projections.matchAggregateProjection((AggregateProjectionMetadata.Schema)spec.getSchema(), (CursorBuildSpec)cursorBuildSpec, (Interval)new Interval((ReadableInstant)time, (ReadableInstant)time.plusHours(1)), (Projections.PhysicalColumnChecker)new RowSignatureChecker(baseTable));
        Assertions.assertEquals((Object)expected, (Object)projectionMatch);
    }

    @Test
    public void testSchemaMatchIntervalProjectionGranularityEternity() {
        DateTime time = Granularities.DAY.bucketStart(DateTimes.nowUtc());
        RowSignature baseTable = RowSignature.builder().addTimeColumn().add("a", ColumnType.STRING).build();
        AggregateProjectionMetadata spec = new AggregateProjectionMetadata(AggregateProjectionSpec.builder((String)"some_projection").groupingColumns(new DimensionSchema[]{new LongDimensionSchema("__virtualGranularity"), new StringDimensionSchema("a")}).virtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__virtualGranularity")}).build().toMetadataSchema(), 12345);
        CursorBuildSpec cursorBuildSpec = CursorBuildSpec.builder().setPhysicalColumns(Set.of("__time", "a")).setGroupingColumns(List.of("v0", "a")).setVirtualColumns(VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"v0")})).build();
        ProjectionMatch expectedWithGranularity = new ProjectionMatch(CursorBuildSpec.builder().setPhysicalColumns(Set.of("__time", "a")).setGroupingColumns(List.of("v0", "a")).setAggregators(List.of()).build(), Map.of("v0", "__time"));
        ProjectionMatch projectionMatch = Projections.matchAggregateProjection((AggregateProjectionMetadata.Schema)spec.getSchema(), (CursorBuildSpec)cursorBuildSpec, (Interval)Intervals.ETERNITY, (Projections.PhysicalColumnChecker)new RowSignatureChecker(baseTable));
        Assertions.assertEquals((Object)expectedWithGranularity, (Object)projectionMatch);
        projectionMatch = Projections.matchAggregateProjection((AggregateProjectionMetadata.Schema)spec.getSchema(), (CursorBuildSpec)cursorBuildSpec, (Interval)new Interval((ReadableInstant)time, (ReadableInstant)time.plusHours(1)), (Projections.PhysicalColumnChecker)new RowSignatureChecker(baseTable));
        Assertions.assertEquals((Object)expectedWithGranularity, (Object)projectionMatch);
    }

    @Test
    public void testSchemaMatchIntervalProjectionGranularity() {
        DateTime time = Granularities.DAY.bucketStart(DateTimes.nowUtc());
        RowSignature baseTable = RowSignature.builder().addTimeColumn().add("a", ColumnType.STRING).build();
        AggregateProjectionMetadata spec = new AggregateProjectionMetadata(AggregateProjectionSpec.builder((String)"some_projection").groupingColumns(new DimensionSchema[]{new LongDimensionSchema("__virtualGranularity"), new StringDimensionSchema("a")}).virtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__virtualGranularity")}).build().toMetadataSchema(), 12345);
        Interval day = new Interval((ReadableInstant)time, (ReadableInstant)time.plusDays(1));
        Interval hour = new Interval((ReadableInstant)time, (ReadableInstant)time.plusHours(1));
        Interval partial = new Interval((ReadableInstant)time, (ReadableInstant)time.plusMinutes(42));
        CursorBuildSpec cursorBuildSpecHourInterval = CursorBuildSpec.builder().setInterval(hour).setPhysicalColumns(Set.of("a")).setGroupingColumns(List.of("a")).build();
        ProjectionMatch expected = new ProjectionMatch(CursorBuildSpec.builder().setInterval(hour).setPhysicalColumns(Set.of("a")).setGroupingColumns(List.of("a")).setAggregators(List.of()).build(), Map.of());
        ProjectionMatch projectionMatch = Projections.matchAggregateProjection((AggregateProjectionMetadata.Schema)spec.getSchema(), (CursorBuildSpec)cursorBuildSpecHourInterval, (Interval)day, (Projections.PhysicalColumnChecker)new RowSignatureChecker(baseTable));
        Assertions.assertEquals((Object)expected, (Object)projectionMatch);
        CursorBuildSpec cursorBuildSpecPartialInterval = CursorBuildSpec.builder().setInterval(partial).setPhysicalColumns(Set.of("a")).setGroupingColumns(List.of("a")).build();
        projectionMatch = Projections.matchAggregateProjection((AggregateProjectionMetadata.Schema)spec.getSchema(), (CursorBuildSpec)cursorBuildSpecPartialInterval, (Interval)day, (Projections.PhysicalColumnChecker)new RowSignatureChecker(baseTable));
        Assertions.assertNull((Object)projectionMatch);
        Interval wonky = new Interval((ReadableInstant)time, (ReadableInstant)time.plusHours(1).plusMinutes(12));
        CursorBuildSpec cursorBuildSpecUnalignedButContaining = CursorBuildSpec.builder().setInterval(wonky).setPhysicalColumns(Set.of("a")).setGroupingColumns(List.of("a")).build();
        expected = new ProjectionMatch(CursorBuildSpec.builder().setInterval(wonky).setPhysicalColumns(Set.of("a")).setGroupingColumns(List.of("a")).setAggregators(List.of()).build(), Map.of());
        projectionMatch = Projections.matchAggregateProjection((AggregateProjectionMetadata.Schema)spec.getSchema(), (CursorBuildSpec)cursorBuildSpecUnalignedButContaining, (Interval)hour, (Projections.PhysicalColumnChecker)new RowSignatureChecker(baseTable));
        Assertions.assertEquals((Object)expected, (Object)projectionMatch);
    }

    private static class RowSignatureChecker
    implements Projections.PhysicalColumnChecker {
        private final RowSignature rowSignature;

        private RowSignatureChecker(RowSignature rowSignature) {
            this.rowSignature = rowSignature;
        }

        public boolean check(String projectionName, String columnName) {
            return this.rowSignature.contains(columnName);
        }
    }
}

