/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import org.apache.druid.query.aggregation.SerializablePairLongStringComplexMetricSerde;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesSerde;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ComplexMetricsTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testRegister() {
        ComplexMetrics.registerSerde((String)"hyperUnique", (ComplexMetricSerde)new HyperUniquesSerde());
        ComplexMetricSerde serde = ComplexMetrics.getSerdeForType((String)"hyperUnique");
        Assert.assertNotNull((Object)serde);
        Assert.assertTrue((boolean)(serde instanceof HyperUniquesSerde));
    }

    @Test
    public void testRegisterDuplicate() {
        ComplexMetrics.registerSerde((String)"hyperUnique", (ComplexMetricSerde)new HyperUniquesSerde());
        ComplexMetricSerde serde = ComplexMetrics.getSerdeForType((String)"hyperUnique");
        Assert.assertNotNull((Object)serde);
        Assert.assertTrue((boolean)(serde instanceof HyperUniquesSerde));
        ComplexMetrics.registerSerde((String)"hyperUnique", (ComplexMetricSerde)new HyperUniquesSerde());
        serde = ComplexMetrics.getSerdeForType((String)"hyperUnique");
        Assert.assertNotNull((Object)serde);
        Assert.assertTrue((boolean)(serde instanceof HyperUniquesSerde));
    }

    @Test
    public void testConflicting() {
        ComplexMetrics.registerSerde((String)"hyperUnique", (ComplexMetricSerde)new HyperUniquesSerde());
        ComplexMetricSerde serde = ComplexMetrics.getSerdeForType((String)"hyperUnique");
        Assert.assertNotNull((Object)serde);
        Assert.assertTrue((boolean)(serde instanceof HyperUniquesSerde));
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Incompatible serializer for type[hyperUnique] already exists. Expected [org.apache.druid.query.aggregation.SerializablePairLongStringComplexMetricSerde], found [org.apache.druid.query.aggregation.hyperloglog.HyperUniquesSerde");
        ComplexMetrics.registerSerde((String)"hyperUnique", (ComplexMetricSerde)new SerializablePairLongStringComplexMetricSerde());
        serde = ComplexMetrics.getSerdeForType((String)"hyperUnique");
        Assert.assertNotNull((Object)serde);
        Assert.assertTrue((boolean)(serde instanceof HyperUniquesSerde));
    }
}

