/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde.cell;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.serde.cell.ByteBufferProvider;
import org.apache.druid.segment.serde.cell.BytesWriter;
import org.apache.druid.segment.serde.cell.BytesWriterBuilder;
import org.apache.druid.segment.serde.cell.CellWriter;

public class CellWriterToBytesWriter
implements BytesWriter {
    private final CellWriter cellWriter;

    public CellWriterToBytesWriter(CellWriter cellWriter) {
        this.cellWriter = cellWriter;
    }

    @Override
    public void write(byte[] cellBytes) throws IOException {
        this.cellWriter.write(cellBytes);
    }

    @Override
    public void write(ByteBuffer cellByteBuffer) throws IOException {
        this.cellWriter.write(cellByteBuffer);
    }

    @Override
    public void transferTo(WritableByteChannel channel) throws IOException {
        this.cellWriter.writeTo(channel, null);
    }

    @Override
    public void close() throws IOException {
        this.cellWriter.close();
    }

    @Override
    public long getSerializedSize() {
        return this.cellWriter.getSerializedSize();
    }

    public static class Builder
    implements BytesWriterBuilder {
        private final CellWriter.Builder builder;

        public Builder(CellWriter.Builder builder) {
            this.builder = builder;
        }

        @Override
        public BytesWriterBuilder setCompressionStrategy(CompressionStrategy compressionStrategy) {
            this.builder.setCompressionStrategy(compressionStrategy);
            return this;
        }

        @Override
        public BytesWriterBuilder setByteBufferProvider(ByteBufferProvider byteBufferProvider) {
            this.builder.setByteBufferProvider(byteBufferProvider);
            return this;
        }

        @Override
        public BytesWriter build() throws IOException {
            return new CellWriterToBytesWriter(this.builder.build());
        }
    }
}

