/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde.cell;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.druid.segment.serde.cell.TestCaseResult;

public class TestCasesConfig<T> {
    private final MethodCallCapturer<T> methodCallCapturer;
    private final Class<T> testCasesInterface;
    private final Class<? extends T> testClassImpl;
    private final Map<TestMethodHandle, TestCaseResult> testCasesToRun = new LinkedHashMap<TestMethodHandle, TestCaseResult>();

    public TestCasesConfig(Class<T> testCasesInterface, Class<? extends T> testClassImpl) {
        this.methodCallCapturer = new MethodCallCapturer<T>(testCasesInterface);
        this.testCasesInterface = testCasesInterface;
        this.testClassImpl = testClassImpl;
    }

    public TestCasesConfig<T> setTestCaseValue(TestMethodHandle testMethodHandle, TestCaseResult expectedResult) {
        this.testCasesToRun.put(testMethodHandle, expectedResult);
        return this;
    }

    public TestCasesConfig<T> setTestCaseValue(MethodAccess<T, Exception> methodAccess, TestCaseResult expectedResult) {
        TestMethodHandle testMethodHandle = this.capture(methodAccess);
        this.testCasesToRun.put(testMethodHandle, expectedResult);
        return this;
    }

    public TestCasesConfig<T> setTestCaseValue(MethodAccess<T, Exception> methodAccess, int sizeBytes) {
        TestMethodHandle testMethodHandle = this.capture(methodAccess);
        this.testCasesToRun.put(testMethodHandle, TestCaseResult.of(sizeBytes));
        return this;
    }

    public TestCasesConfig<T> setTestCaseValue(MethodAccess<T, Exception> methodAccess, byte[] bytes) {
        TestMethodHandle testMethodHandle = this.capture(methodAccess);
        this.testCasesToRun.put(testMethodHandle, TestCaseResult.of(bytes));
        return this;
    }

    public TestCasesConfig<T> enableTestCase(MethodAccess<T, Exception> methodAccess) {
        TestMethodHandle testMethodHandle = this.capture(methodAccess);
        this.testCasesToRun.put(testMethodHandle, TestCaseResult.of(-1));
        return this;
    }

    public TestCaseResult currentTestValue() {
        TestMethodHandle currentTestMethodHandle = this.getCurrentTestMethod();
        return this.testCasesToRun.get(currentTestMethodHandle);
    }

    public boolean isCurrentTestEnabled() {
        TestMethodHandle currentTestMethodHandle = this.getCurrentTestMethod();
        return this.testCasesToRun.containsKey(currentTestMethodHandle);
    }

    private TestMethodHandle capture(MethodAccess<T, Exception> access) {
        try {
            Method method = this.methodCallCapturer.captureMethod(access);
            TestMethodHandle testMethodHandle = new TestMethodHandle(method.getName());
            return testMethodHandle;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private TestMethodHandle getCurrentTestMethod() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String thisMethodName = stackTrace[3].getMethodName();
        return new TestMethodHandle(thisMethodName);
    }

    private static class MethodCallCapturer<T>
    implements InvocationHandler {
        private volatile Method lastMethod = null;
        private final T wrapper;

        public MethodCallCapturer(Class<T> clazz) {
            this.wrapper = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
        }

        public <E extends Throwable> Method captureMethod(MethodAccess<T, E> access) throws Throwable {
            access.access(this.wrapper);
            return this.lastMethod;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            this.lastMethod = method;
            return null;
        }
    }

    public static interface MethodAccess<I, T extends Throwable> {
        public void access(I var1) throws T;
    }

    public class TestMethodHandle {
        private final String name;

        public TestMethodHandle(String name) {
            this.name = name;
            try {
                MethodHandles.lookup().findVirtual(TestCasesConfig.this.testCasesInterface, name, MethodType.methodType(Void.TYPE));
                MethodHandles.lookup().findVirtual(TestCasesConfig.this.testClassImpl, name, MethodType.methodType(Void.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        public String getName() {
            return TestCasesConfig.this.testCasesInterface.getName() + "::void " + this.name + "()";
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj != null && this.getClass().equals(obj.getClass())) {
                return this.getName().equals(((TestMethodHandle)obj).getName());
            }
            return false;
        }

        public String toString() {
            return this.getName();
        }
    }
}

