/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.generator.GeneratorBasicSchemas;
import org.apache.druid.segment.generator.GeneratorSchemaInfo;
import org.apache.druid.segment.generator.SegmentGenerator;
import org.apache.druid.segment.vector.ReadableVectorInspector;
import org.apache.druid.segment.vector.VectorCursor;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.segment.virtual.ExpressionVectorSelectors;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ExpressionVectorSelectorsCastTest {
    private static final int ROWS_PER_SEGMENT = 10000;
    private static QueryableIndex INDEX;
    private static Closer CLOSER;

    @BeforeClass
    public static void setupClass() {
        CLOSER = Closer.create();
        GeneratorSchemaInfo schemaInfo = (GeneratorSchemaInfo)GeneratorBasicSchemas.SCHEMA_MAP.get("expression-testbench");
        DataSegment dataSegment = DataSegment.builder().dataSource("foo").interval(schemaInfo.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        SegmentGenerator segmentGenerator = (SegmentGenerator)CLOSER.register((Closeable)new SegmentGenerator());
        INDEX = (QueryableIndex)CLOSER.register((Closeable)segmentGenerator.generate(dataSegment, schemaInfo, Granularities.HOUR, 10000));
    }

    @AfterClass
    public static void teardownClass() throws IOException {
        CLOSER.close();
    }

    @Test
    public void testCastObjectSelectorToValueSelector() {
        ExpressionVectorSelectorsCastTest.testCast(INDEX, "string1", ColumnType.LONG, CLOSER);
        ExpressionVectorSelectorsCastTest.testCast(INDEX, "string2", ColumnType.DOUBLE, CLOSER);
        ExpressionVectorSelectorsCastTest.testCast(INDEX, "string3", ColumnType.FLOAT, CLOSER);
    }

    @Test
    public void testCastValueSelectorSelectorToObjectSelector() {
        ExpressionVectorSelectorsCastTest.testCast(INDEX, "long1", ColumnType.STRING, CLOSER);
        ExpressionVectorSelectorsCastTest.testCast(INDEX, "long2", ColumnType.STRING, CLOSER);
        ExpressionVectorSelectorsCastTest.testCast(INDEX, "double1", ColumnType.STRING, CLOSER);
        ExpressionVectorSelectorsCastTest.testCast(INDEX, "double2", ColumnType.STRING, CLOSER);
        ExpressionVectorSelectorsCastTest.testCast(INDEX, "float1", ColumnType.STRING, CLOSER);
        ExpressionVectorSelectorsCastTest.testCast(INDEX, "float2", ColumnType.STRING, CLOSER);
    }

    public static void testCast(QueryableIndex index, String column, ColumnType castTo, Closer closer) {
        VirtualColumns virtualColumns = VirtualColumns.create((List)ImmutableList.of((Object)new ExpressionVirtualColumn("v", "cast(" + column + ", '" + ExpressionType.fromColumnType((TypeSignature)castTo) + "')", castTo, TestExprMacroTable.INSTANCE)));
        QueryableIndexCursorFactory cursorFactory = new QueryableIndexCursorFactory(index);
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setVirtualColumns(virtualColumns).build();
        VectorCursor cursor = ((CursorHolder)closer.register((Closeable)cursorFactory.makeCursorHolder(buildSpec))).asVectorCursor();
        ColumnCapabilities capabilities = INDEX.getColumnCapabilities(column);
        if (capabilities.isNumeric() && castTo.is((TypeDescriptor)ValueType.STRING)) {
            ExpressionVectorSelectorsCastTest.verifyNumericToString(column, castTo, cursor);
        } else {
            ExpressionVectorSelectorsCastTest.verifyStringToNumeric(column, castTo, cursor);
        }
    }

    private static void verifyStringToNumeric(String column, ColumnType castTo, VectorCursor cursor) {
        VectorValueSelector selector = cursor.getColumnSelectorFactory().makeValueSelector("v");
        VectorValueSelector castSelector = ExpressionVectorSelectors.castObjectSelectorToNumeric((ReadableVectorInspector)cursor.getColumnSelectorFactory().getReadableVectorInspector(), (String)column, (VectorObjectSelector)cursor.getColumnSelectorFactory().makeObjectSelector(column), (ColumnType)ColumnType.STRING, (ColumnType)castTo);
        while (!cursor.isDone()) {
            switch ((ValueType)castTo.getType()) {
                case LONG: {
                    boolean[] nulls = selector.getNullVector();
                    boolean[] castNulls = castSelector.getNullVector();
                    long[] longs = selector.getLongVector();
                    long[] castLongs = castSelector.getLongVector();
                    for (int i = 0; i < selector.getCurrentVectorSize(); ++i) {
                        if (nulls != null) {
                            Assert.assertEquals((Object)nulls[i], (Object)castNulls[i]);
                        }
                        Assert.assertEquals((long)longs[i], (long)castLongs[i]);
                    }
                    break;
                }
                case DOUBLE: {
                    boolean[] nulls = selector.getNullVector();
                    boolean[] castNulls = selector.getNullVector();
                    double[] doubles = selector.getDoubleVector();
                    double[] castDoubles = castSelector.getDoubleVector();
                    for (int i = 0; i < selector.getCurrentVectorSize(); ++i) {
                        if (nulls != null) {
                            Assert.assertEquals((Object)nulls[i], (Object)castNulls[i]);
                        }
                        Assert.assertEquals((double)doubles[i], (double)castDoubles[i], (double)0.0);
                    }
                    break;
                }
                case FLOAT: {
                    boolean[] nulls = selector.getNullVector();
                    boolean[] castNulls = selector.getNullVector();
                    float[] floats = selector.getFloatVector();
                    float[] castFloats = castSelector.getFloatVector();
                    for (int i = 0; i < selector.getCurrentVectorSize(); ++i) {
                        if (nulls != null) {
                            Assert.assertEquals((Object)nulls[i], (Object)castNulls[i]);
                        }
                        Assert.assertEquals((double)floats[i], (double)castFloats[i], (double)0.0);
                    }
                    break;
                }
                default: {
                    Assert.fail((String)"this shouldn't happen");
                    return;
                }
            }
            cursor.advance();
        }
    }

    private static void verifyNumericToString(String column, ColumnType castTo, VectorCursor cursor) {
        VectorObjectSelector objectSelector = cursor.getColumnSelectorFactory().makeObjectSelector("v");
        VectorObjectSelector castSelector = ExpressionVectorSelectors.castValueSelectorToObject((ReadableVectorInspector)cursor.getColumnSelectorFactory().getReadableVectorInspector(), (String)column, (VectorValueSelector)cursor.getColumnSelectorFactory().makeValueSelector(column), (ColumnType)cursor.getColumnSelectorFactory().getColumnCapabilities(column).toColumnType(), (ColumnType)castTo);
        while (!cursor.isDone()) {
            switch ((ValueType)castTo.getType()) {
                case STRING: {
                    Object[] objects = objectSelector.getObjectVector();
                    Object[] otherObjects = castSelector.getObjectVector();
                    Assert.assertEquals((long)objectSelector.getCurrentVectorSize(), (long)castSelector.getCurrentVectorSize());
                    for (int i = 0; i < objectSelector.getCurrentVectorSize(); ++i) {
                        Assert.assertEquals((Object)objects[i], (Object)otherObjects[i]);
                    }
                    break;
                }
                default: {
                    Assert.fail((String)"this shouldn't happen");
                    return;
                }
            }
            cursor.advance();
        }
    }
}

